/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.ui.util.DTRTUIUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.GaugeLabelPosition;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeOptionsModel;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.dvt.IGaugeThreshold;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.Messages;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.ModelChangeComposite;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.HexColorCellEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.ThresholdCellModifier;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.ThresholdContentProvider;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.options.dvt.gauge.ThresholdManager;
import oracle.eclipse.tools.common.util.Pair;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class GaugeOptionsComposite
extends ModelChangeComposite<IGaugeOptionsModel>
implements PropertyChangeListener {
    private Combo _metricValueControl;
    private Text _minValueControl;
    private Text _maxValueControl;
    private Button _topLabelButton;
    private Text _topLabelControl;
    private LabelPositionComboAdapter _topLabelPosControl;
    private Button _bottomLabelButton;
    private Text _bottomLabelControl;
    private LabelPositionComboAdapter _bottomLabelPosControl;
    private Button _metricLabelButton;
    private LabelPositionComboAdapter _metricLabelPosControl;
    private Table _thresholdsTable;
    private TableViewer _tableViewer;
    private final ThresholdManager _thresholdMgr;
    private final ThresholdLabelProvider _thresholdLabelProvider = new ThresholdLabelProvider();

    public GaugeOptionsComposite(Composite parent, int style, IGaugeOptionsModel model) {
        super(parent, style, model);
        this._thresholdMgr = new ThresholdManager(model);
        this.setFont(parent.getFont());
        this.setLayoutData(new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        this.setLayout((Layout)layout);
        this.createMetricSelectionControls(this);
        this.createLabelSelectionControls(this);
        this.createThresholdControls(this);
        this.createListeners();
        this.updateWidgets();
        this._thresholdMgr.addPropertyChangeListener(this);
    }

    public void dispose() {
        this._thresholdMgr.removePropertyChangeListener(this);
        this._tableViewer.getLabelProvider().dispose();
    }

    private void createMetricSelectionControls(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_metricValueLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this._metricValueControl = new Combo(parent, 0x800808);
        this._metricValueControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_minValueLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this._minValueControl = new Text(parent, 2052);
        this._minValueControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_maxValueLabel);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this._maxValueControl = new Text(parent, 2052);
        this._maxValueControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
    }

    private void createLabelSelectionControls(Composite parent) {
        Label spacer = new Label(parent, 16384);
        spacer.setText("");
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        spacer.setLayoutData((Object)data);
        spacer.setVisible(false);
        this._topLabelButton = new Button(parent, 32);
        this._topLabelButton.setText(Messages.GaugeOptionsPage_showTopLabel);
        this._topLabelButton.setSelection(((IGaugeOptionsModel)this.getModel()).showTopLabel());
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        this._topLabelButton.setLayoutData((Object)data);
        Label label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_topLabel);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        this._topLabelControl = new Text(parent, 2052);
        if (((IGaugeOptionsModel)this.getModel()).getTopLabel() != null) {
            this._topLabelControl.setText(((IGaugeOptionsModel)this.getModel()).getTopLabel());
        }
        this._topLabelControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_topLabelPosition);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        Combo combo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        combo.setLayoutData((Object)data);
        this._topLabelPosControl = new LabelPositionComboAdapter(combo);
        this._topLabelPosControl.setItems(((IGaugeOptionsModel)this.getModel()).getTopLabelPositions());
        this._topLabelPosControl.select(((IGaugeOptionsModel)this.getModel()).getTopLabelPosition());
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        spacer = new Label(parent, 16384);
        spacer.setText("");
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        spacer.setLayoutData((Object)data);
        spacer.setVisible(false);
        this._bottomLabelButton = new Button(parent, 32);
        this._bottomLabelButton.setText(Messages.GaugeOptionsPage_showBottomLabel);
        this._bottomLabelButton.setSelection(((IGaugeOptionsModel)this.getModel()).showTopLabel());
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        this._bottomLabelButton.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_bottomLabel);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        this._bottomLabelControl = new Text(parent, 2052);
        if (((IGaugeOptionsModel)this.getModel()).getBottomLabel() != null) {
            this._bottomLabelControl.setText(((IGaugeOptionsModel)this.getModel()).getBottomLabel());
        }
        this._bottomLabelControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_bottomLabelPosition);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        combo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        combo.setLayoutData((Object)data);
        this._bottomLabelPosControl = new LabelPositionComboAdapter(combo);
        this._bottomLabelPosControl.setItems(((IGaugeOptionsModel)this.getModel()).getBottomLabelPositions());
        this._bottomLabelPosControl.select(((IGaugeOptionsModel)this.getModel()).getBottomLabelPosition());
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
        spacer = new Label(parent, 16384);
        spacer.setText("");
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        spacer.setLayoutData((Object)data);
        spacer.setVisible(false);
        this._metricLabelButton = new Button(parent, 32);
        this._metricLabelButton.setText(Messages.GaugeOptionsPage_showMetricLabel);
        this._metricLabelButton.setSelection(((IGaugeOptionsModel)this.getModel()).showTopLabel());
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 3;
        this._metricLabelButton.setLayoutData((Object)data);
        label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_metricLabelPosition);
        data = new GridData(16384, 0x1000000, false, false);
        data.horizontalIndent = 15;
        label.setLayoutData((Object)data);
        combo = new Combo(parent, 0x800808);
        data = new GridData(4, 0x1000000, true, false);
        combo.setLayoutData((Object)data);
        this._metricLabelPosControl = new LabelPositionComboAdapter(combo);
        this._metricLabelPosControl.setItems(((IGaugeOptionsModel)this.getModel()).getMetricLabelPositions());
        this._metricLabelPosControl.select(((IGaugeOptionsModel)this.getModel()).getMetricLabelPosition());
        gridPlaceHolder = new Label(parent, 0);
        gridPlaceHolder.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gridPlaceHolder.setVisible(false);
    }

    protected void createThresholdControls(Composite parent) {
        Label spacer = new Label(parent, 16384);
        spacer.setText("");
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.horizontalSpan = 2;
        spacer.setLayoutData((Object)data);
        spacer.setVisible(false);
        Label label = new Label(parent, 16384);
        label.setText(Messages.GaugeOptionsPage_thresholdAttributesLabel);
        data = new GridData(16384, 0x1000000, true, false);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        this.createTable(parent);
        this.createThresholdToobar(parent);
        this.createTableViewer();
        this.updateThresholdViewerInput();
    }

    private void createThresholdToobar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 0x800200);
        toolBar.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        ToolItem item = new ToolItem(toolBar, 0x800008);
        item.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_ADD));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GaugeOptionsComposite.this._thresholdMgr.createThreshold();
            }
        });
        item = new ToolItem(toolBar, 0x800008);
        item.setImage(DTRTUIUtil.getImage((ImageManager.IImageData)DTRTBundleIcon.ACTION_DELETE));
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object selection = ((IStructuredSelection)GaugeOptionsComposite.this._tableViewer.getSelection()).getFirstElement();
                if (selection instanceof IGaugeThreshold) {
                    GaugeOptionsComposite.this._thresholdMgr.removeThreshold((IGaugeThreshold)selection);
                }
            }
        });
    }

    private void createTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.minimumHeight = 100;
        data.horizontalSpan = 2;
        tableComp.setLayoutData((Object)data);
        int tableStyle = 101124;
        this._thresholdsTable = new Table(tableComp, tableStyle);
        this._thresholdsTable.setFont(parent.getFont());
        this._thresholdsTable.setLinesVisible(true);
        this._thresholdsTable.setHeaderVisible(true);
        TableColumn numberCol = new TableColumn(this._thresholdsTable, 16384, 0);
        numberCol.setText(Messages.GaugeOptionsPage_columnHeaderThresholdNumber);
        TableColumn valueCol = new TableColumn(this._thresholdsTable, 16384, 1);
        valueCol.setText(Messages.GaugeOptionsPage_columnHeaderThreshold);
        TableColumn labelCol = new TableColumn(this._thresholdsTable, 16384, 2);
        labelCol.setText(Messages.GaugeOptionsPage_columnHeaderLabel);
        TableColumn colorCol = new TableColumn(this._thresholdsTable, 16384, 3);
        colorCol.setText(Messages.GaugeOptionsPage_columnHeaderColor);
        TableColumnLayout tcLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tcLayout);
        tcLayout.setColumnData((Widget)numberCol, (ColumnLayoutData)new ColumnWeightData(15));
        tcLayout.setColumnData((Widget)valueCol, (ColumnLayoutData)new ColumnWeightData(30));
        tcLayout.setColumnData((Widget)labelCol, (ColumnLayoutData)new ColumnWeightData(30));
        tcLayout.setColumnData((Widget)colorCol, (ColumnLayoutData)new ColumnWeightData(25));
    }

    private void createTableViewer() {
        this._tableViewer = new TableViewer(this._thresholdsTable);
        this._tableViewer.setColumnProperties(ThresholdManager.getColumnNames());
        CellEditor[] editors = new CellEditor[ThresholdManager.getColumnNames().length];
        TextCellEditor valueEditor = new TextCellEditor((Composite)this._thresholdsTable);
        editors[1] = valueEditor;
        TextCellEditor labelEditor = new TextCellEditor((Composite)this._thresholdsTable);
        editors[2] = labelEditor;
        editors[3] = new HexColorCellEditor((Composite)this._thresholdsTable);
        this._tableViewer.setCellEditors(editors);
        this._tableViewer.setCellModifier((ICellModifier)new ThresholdCellModifier(this._thresholdMgr));
        this._tableViewer.setContentProvider((IContentProvider)new ThresholdContentProvider());
        this._tableViewer.setLabelProvider((IBaseLabelProvider)this._thresholdLabelProvider);
    }

    private void createListeners() {
        this._metricValueControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = GaugeOptionsComposite.this._metricValueControl.getText();
                if (value != null && !value.equals(((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).getMetricValue())) {
                    ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setMetricValue(value);
                    GaugeOptionsComposite.this.updateWidgets();
                    GaugeOptionsComposite.this.firePropertyChange();
                }
            }
        });
        this._minValueControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String oldValue;
                String value = GaugeOptionsComposite.this._minValueControl.getText();
                if (!DTRTUtil.equals((Object)value, (Object)(oldValue = ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).getMinValue()))) {
                    ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setMinValue(value);
                    GaugeOptionsComposite.this.updateWidgets();
                    GaugeOptionsComposite.this.firePropertyChange();
                }
            }
        });
        this._maxValueControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String oldValue;
                String value = GaugeOptionsComposite.this._maxValueControl.getText();
                if (!DTRTUtil.equals((Object)value, (Object)(oldValue = ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).getMaxValue()))) {
                    ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setMaxValue(value);
                    GaugeOptionsComposite.this.updateWidgets();
                    GaugeOptionsComposite.this.firePropertyChange();
                }
            }
        });
        this._topLabelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = GaugeOptionsComposite.this._topLabelButton.getSelection();
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setShowTopLabel(selected);
                GaugeOptionsComposite.this._topLabelControl.setEnabled(selected);
                GaugeOptionsComposite.this._topLabelPosControl.getCombo().setEnabled(selected);
            }
        });
        this._topLabelControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String oldValue;
                String value = GaugeOptionsComposite.this._topLabelControl.getText();
                if (!DTRTUtil.equals((Object)value, (Object)(oldValue = ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).getTopLabel()))) {
                    ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setTopLabel(value);
                }
            }
        });
        this._topLabelPosControl.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setTopLabelPosition(GaugeOptionsComposite.this._topLabelPosControl.getSelectedLabelPosition());
            }
        });
        this._bottomLabelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = GaugeOptionsComposite.this._bottomLabelButton.getSelection();
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setShowBottomLabel(selected);
                GaugeOptionsComposite.this._bottomLabelControl.setEnabled(selected);
                GaugeOptionsComposite.this._bottomLabelPosControl.getCombo().setEnabled(selected);
            }
        });
        this._bottomLabelControl.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                String oldValue;
                String value = GaugeOptionsComposite.this._bottomLabelControl.getText();
                if (!DTRTUtil.equals((Object)value, (Object)(oldValue = ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).getBottomLabel()))) {
                    ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setBottomLabel(value);
                }
            }
        });
        this._bottomLabelPosControl.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setBottomLabelPosition(GaugeOptionsComposite.this._bottomLabelPosControl.getSelectedLabelPosition());
            }
        });
        this._metricLabelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected = GaugeOptionsComposite.this._metricLabelButton.getSelection();
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setShowMetricLabel(selected);
                GaugeOptionsComposite.this._metricLabelPosControl.getCombo().setEnabled(selected);
            }
        });
        this._metricLabelPosControl.getCombo().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IGaugeOptionsModel)GaugeOptionsComposite.this.getModel()).setMetricLabelPosition(GaugeOptionsComposite.this._metricLabelPosControl.getSelectedLabelPosition());
            }
        });
    }

    private void updateWidgets() {
        List<String> possibleValues = ((IGaugeOptionsModel)this.getModel()).getMetricValues();
        this._metricValueControl.setItems(possibleValues.toArray(new String[possibleValues.size()]));
        if (((IGaugeOptionsModel)this.getModel()).getMetricValue() != null) {
            this._metricValueControl.setText(((IGaugeOptionsModel)this.getModel()).getMetricValue());
        }
        if (((IGaugeOptionsModel)this.getModel()).getMinValue() != null) {
            this._minValueControl.setText(((IGaugeOptionsModel)this.getModel()).getMinValue());
        }
        if (((IGaugeOptionsModel)this.getModel()).getMaxValue() != null) {
            this._maxValueControl.setText(((IGaugeOptionsModel)this.getModel()).getMaxValue());
        }
    }

    @Override
    public void updateLayout() {
        this._thresholdLabelProvider.clearImages();
        this.updateThresholdViewerInput();
        this._tableViewer.refresh();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("Change Threshold".equals(evt.getPropertyName()) && evt.getNewValue() instanceof IGaugeThreshold) {
            if (evt.getOldValue() instanceof String) {
                this._thresholdLabelProvider.removeThresholdImage((String)evt.getOldValue());
            }
            IGaugeThreshold threshold = (IGaugeThreshold)evt.getNewValue();
            this._tableViewer.update((Object)threshold, null);
        } else if ("Remove Threshold".equals(evt.getPropertyName()) && evt.getOldValue() instanceof IGaugeThreshold) {
            IGaugeThreshold threshold = (IGaugeThreshold)evt.getOldValue();
            this._thresholdLabelProvider.removeThresholdImage(threshold.getFillColor());
            this.updateThresholdViewerInput();
        } else {
            this.updateThresholdViewerInput();
        }
        this.firePropertyChange();
    }

    private void updateThresholdViewerInput() {
        this._tableViewer.setInput(this.getModel());
    }

    private ImageData createColorImage(RGB color) {
        int indent = 6;
        int extent = 16;
        int size = 16;
        int width = indent + size;
        int height = extent;
        int xoffset = indent;
        int yoffset = (height - size) / 2;
        RGB black = new RGB(0, 0, 0);
        PaletteData dataPalette = new PaletteData(new RGB[]{black, black, color});
        ImageData data = new ImageData(width, height, 4, dataPalette);
        data.transparentPixel = 0;
        int end = size - 1;
        int y = 0;
        while (y < size) {
            int x = 0;
            while (x < size) {
                if (x == 0 || y == 0 || x == end || y == end) {
                    data.setPixel(x + xoffset, y + yoffset, 1);
                } else {
                    data.setPixel(x + xoffset, y + yoffset, 2);
                }
                ++x;
            }
            ++y;
        }
        return data;
    }

    private static final class LabelPositionComboAdapter {
        private final Combo _combo;
        private List<GaugeLabelPosition> _items;

        public LabelPositionComboAdapter(Combo combo) {
            this._combo = combo;
        }

        public Combo getCombo() {
            return this._combo;
        }

        public void setItems(List<GaugeLabelPosition> items) {
            this._items = items;
            String[] names = new String[items.size()];
            int index = 0;
            for (GaugeLabelPosition item : items) {
                names[index++] = item.toString();
            }
            this._combo.setItems(names);
        }

        public GaugeLabelPosition getSelectedLabelPosition() {
            int index = this._combo.getSelectionIndex();
            return this._items.get(index);
        }

        public void select(GaugeLabelPosition labelPosition) {
            int index = this._items.indexOf((Object)labelPosition);
            if (index > -1) {
                this._combo.select(index);
            }
        }
    }

    private class ThresholdLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private final List<Pair<String, Image>> _imageCache = new ArrayList<Pair<String, Image>>();

        private ThresholdLabelProvider() {
        }

        public void dispose() {
            this.clearImages();
        }

        public void clearImages() {
            for (Pair<String, Image> pair : this._imageCache) {
                Image image = (Image)pair.getSecond();
                if (image == null) continue;
                image.dispose();
            }
            this._imageCache.clear();
        }

        private Image getImage(IGaugeThreshold threshold) {
            Image image = null;
            String colorString = threshold.getFillColor();
            if (colorString != null) {
                for (Pair<String, Image> pair : this._imageCache) {
                    if (!colorString.equals(pair.getFirst())) continue;
                    return (Image)pair.getSecond();
                }
                ImageData id = GaugeOptionsComposite.this.createColorImage(HexColorCellEditor.convertHexadecimalStringtoRGB(threshold.getFillColor()));
                ImageData mask = id.getTransparencyMask();
                image = new Image((Device)GaugeOptionsComposite.this._thresholdsTable.getDisplay(), id, mask);
                this._imageCache.add((Pair<String, Image>)new Pair((Object)colorString, (Object)image));
            }
            return image;
        }

        public void removeThresholdImage(String colorString) {
            if (colorString != null && !colorString.isEmpty()) {
                Image image;
                Pair<String, Image> pair2;
                boolean foundPair = false;
                int index = 0;
                for (Pair<String, Image> pair2 : this._imageCache) {
                    if (colorString.equals(pair2.getFirst())) {
                        foundPair = true;
                        break;
                    }
                    ++index;
                }
                if (foundPair && (image = (Image)(pair2 = this._imageCache.remove(index)).getSecond()) != null) {
                    image.dispose();
                }
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            IGaugeThreshold threshold = (IGaugeThreshold)element;
            if (columnIndex == 3) {
                return this.getImage(threshold);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IGaugeThreshold threshold = (IGaugeThreshold)element;
            String result = "";
            switch (columnIndex) {
                case 0: {
                    result = String.valueOf(threshold.getIndex() + 1);
                    break;
                }
                case 1: {
                    result = threshold.isMaxThreshold() ? Messages.GaugeOptionsPage_thresholdMaxValue : threshold.getMaxValue();
                    break;
                }
                case 2: {
                    result = threshold.getText();
                    break;
                }
                case 3: {
                    result = threshold.getFillColor();
                }
            }
            return result;
        }
    }
}

