/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer;

import java.util.Collection;
import oracle.eclipse.tools.adf.dtrt.context.typed.IPageDefinitionContext;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.ui.provider.DescribableLabelProvider;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDataControlProvider;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.util.IDescriptor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.IControlDecorationUpdateFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.FormTextControlDecorationUpdater;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.FormTextPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.PropertyEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.viewer.PropertyEditorViewer;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationUpdater;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class FormTextEditorViewer
extends PropertyEditorViewer<FormTextPropertyEditor> {
    private static final String IMAGE_ID_KEY = "d1";
    private final DescribableLabelProvider labelProvider = new DescribableLabelProvider();
    private final boolean hyperlinkText;
    private final IPageDefinitionContext pageDefContext;
    private IObservableValue uiObservable;
    private Color hyperlinkTextColor;
    private HyperlinkSettings hyperlinkSettings;

    public FormTextEditorViewer(PropertyEditorFactory.FormTextPropertyEditorFactory factory, IPageDefinitionContext pageDefContext, boolean hyperlinkText) {
        super(factory);
        this.hyperlinkText = hyperlinkText;
        this.pageDefContext = pageDefContext;
    }

    @Override
    protected FormTextPropertyEditor createEditor(Composite composite) {
        FormTextPropertyEditor editor = (FormTextPropertyEditor)((Object)super.createEditor(composite));
        return editor;
    }

    @Override
    public Control createControl(FormToolkit toolkit, Composite parent, boolean supportsBrowse, boolean supportsCreation) {
        this.hyperlinkTextColor = toolkit.getColors().createColor("hyperlinkColor", new RGB(0, 102, 204));
        this.hyperlinkSettings = new HyperlinkSettings(parent.getDisplay());
        this.hyperlinkSettings.setForeground(this.hyperlinkTextColor);
        this.hyperlinkSettings.setHyperlinkUnderlineMode(2);
        return super.createControl(toolkit, parent, supportsBrowse, supportsCreation);
    }

    public Binding bind(DataBindingContext context, final IObservableValue modelObservable, FormToolkit toolkit) {
        final FormText text = (FormText)((FormTextPropertyEditor)((Object)this.getPropertyEditor())).getBindingControl();
        text.setColor("hyperlinkColor", this.hyperlinkTextColor);
        text.setHyperlinkSettings(this.hyperlinkSettings);
        text.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                Object value = modelObservable.getValue();
                if (value instanceof String && (value = FormTextEditorViewer.lookupById(FormTextEditorViewer.this.pageDefContext, (String)value)) == null) {
                    return;
                }
                HyperlinkEvent event = new HyperlinkEvent((Widget)text.getParent(), value, e.getLabel(), e.getStateMask());
                FormTextEditorViewer.this.handleHyperlinkActivated(event);
            }
        });
        modelObservable.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                Image image = FormTextEditorViewer.this.labelProvider.getImage(event.getObservableValue().getValue());
                if (image != null) {
                    text.setImage(FormTextEditorViewer.IMAGE_ID_KEY, image);
                }
            }
        });
        this.uiObservable = ((FormTextPropertyEditor)((Object)this.getPropertyEditor())).getObservableValue(0);
        return context.bindValue(this.uiObservable, modelObservable, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new DescribableToHypertextConverter((ILabelProvider)this.labelProvider, this.hyperlinkText, this.pageDefContext)));
    }

    public IControlDecorationUpdateFactory createFormTextControlValidationDecorator(final DataBindingContext context, final FormToolkit toolkit, final FormTextPropertyEditor propertyEditor) {
        return new IControlDecorationUpdateFactory(){

            @Override
            public ControlDecorationUpdater create(ValidationStatusProvider validationStatus) {
                Control bindingControl = propertyEditor.getBindingControl();
                if (bindingControl instanceof FormText) {
                    return new FormTextControlDecorationUpdater(context, toolkit, (FormText)bindingControl, validationStatus.getValidationStatus());
                }
                return new ControlDecorationUpdater();
            }
        };
    }

    private static IDescribable lookupById(IPageDefinitionContext pageDefContext, String sourceObjectId) {
        IObject describable = DTRTObjectUtil.find((Collection)DTRTObjectUtil.getDataControls((IDataControlProvider)pageDefContext), (String)sourceObjectId);
        if (describable != null) {
            return describable;
        }
        describable = DTRTObjectUtil.find((Collection)DTRTObjectUtil.getBindingObjects((IPageDefinition)pageDefContext.getPageDefinition()), (String)sourceObjectId);
        if (describable != null) {
            return describable;
        }
        return null;
    }

    private static class DescribableToHypertextConverter
    extends Converter {
        private final ILabelProvider labelProvider;
        private final boolean hyperlinkText;
        private final IPageDefinitionContext pageDefContext;

        public DescribableToHypertextConverter(ILabelProvider labelProvider, boolean hyperlinkText, IPageDefinitionContext pageDefContext) {
            super(Object.class, String.class);
            this.labelProvider = labelProvider;
            this.hyperlinkText = hyperlinkText;
            this.pageDefContext = pageDefContext;
        }

        public Object convert(Object fromObject) {
            Image image;
            String label;
            Object sourceObject = fromObject;
            if (sourceObject instanceof String && (sourceObject = FormTextEditorViewer.lookupById(this.pageDefContext, (String)sourceObject)) == null) {
                sourceObject = fromObject;
            }
            if (sourceObject instanceof IDescribable || sourceObject instanceof IDescriptor) {
                label = this.labelProvider.getText(sourceObject);
                image = this.labelProvider.getImage(sourceObject);
            } else if (sourceObject instanceof String) {
                label = (String)sourceObject;
                image = null;
            } else {
                return null;
            }
            if (label != null) {
                StringBuilder sb = new StringBuilder("<form><p vspace=\"false\">");
                if (this.hyperlinkText) {
                    sb.append("<a href=\"l1\">");
                }
                sb.append(label);
                if (this.hyperlinkText) {
                    sb.append("</a>");
                }
                if (image != null) {
                    sb.append("<img align=\"middle\" href=\"d1\"/> ");
                }
                return sb.append("</p></form>").toString();
            }
            return "";
        }
    }
}

