/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ColumnWidgetFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TableFactory
extends ColumnWidgetFactory {
    public static TableFactory create() {
        return new TableFactory();
    }

    @Override
    public TableFactory defaults() {
        return (TableFactory)super.defaults();
    }

    @Override
    public TableFactory addColumn(ColumnWidgetFactory.ColumnFactory column) {
        if (column instanceof TableColumnFactory) {
            return (TableFactory)super.addColumn(column);
        }
        throw new IllegalArgumentException();
    }

    protected List<TableColumnFactory> getColumns() {
        return super.getColumns();
    }

    public Table build(FormToolkit toolkit, Composite parent) {
        Table table = toolkit.createTable(parent, 65536);
        table.setHeaderVisible(this.headerVisible);
        table.setLinesVisible(this.linesVisible);
        for (TableColumnFactory columnFactory : this.getColumns()) {
            columnFactory.build(table);
        }
        Layout layout = parent.getLayout();
        if (layout instanceof TableColumnLayout) {
            int[] weights = this.calcColumnWeights();
            int i = 0;
            while (i < this.columnCount()) {
                ColumnWeightData columnWeightData = new ColumnWeightData(weights[i], ((ColumnWidgetFactory.ColumnFactory)this.columns.get(i)).isResizable());
                ((TableColumnLayout)layout).setColumnData((Widget)table.getColumn(i), (ColumnLayoutData)columnWeightData);
                ++i;
            }
        }
        return table;
    }

    public static class TableColumnFactory
    extends ColumnWidgetFactory.ColumnFactory {
        public static TableColumnFactory create() {
            return new TableColumnFactory();
        }

        public TableColumn build(Table parent) {
            TableColumn column = new TableColumn(parent, 0);
            column.setMoveable(this.isMoveable());
            column.setResizable(this.isResizable());
            column.setText(this.getText());
            return column;
        }

        public static /* bridge */ /* synthetic */ ColumnWidgetFactory.ColumnFactory create() {
            return TableColumnFactory.create();
        }
    }
}

