/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.DynamicListBoundComboPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.EnhancedFormWidgetAdapter;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.EnhancedTextPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.FormTextPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ListBoundComboPropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.SelectionBasedEditorFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TableFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TablePropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TreeDrivenTablePropertyEditor;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.TreeTableFactory;
import oracle.eclipse.tools.xml.edit.ui.propeditor.CheckboxPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.DialogCreationStrategy;
import oracle.eclipse.tools.xml.edit.ui.propeditor.FormsWidgetAdapter;
import oracle.eclipse.tools.xml.edit.ui.propeditor.PropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextDialogPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.TextPropertyEditor;
import oracle.eclipse.tools.xml.edit.ui.propeditor.WidgetAdapter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class PropertyEditorFactory {
    public static TextPropertyEditorFactory createText() {
        return PropertyEditorFactory.createText(EnhancedFormWidgetAdapter.INSTANCE);
    }

    public static TextPropertyEditorFactory createText(EnhancedFormWidgetAdapter widgetAdapter) {
        return new TextPropertyEditorFactory(widgetAdapter);
    }

    public static TablePropertyEditorFactory createTable(FormToolkit toolkit) {
        return new TablePropertyEditorFactory(toolkit);
    }

    public static ComboPropertyEditorFactory createCombo(WidgetAdapter widgetAdapter) {
        return new ComboPropertyEditorFactory(widgetAdapter);
    }

    public static CheckPropertyEditorFactory createCheck(FormsWidgetAdapter widgetAdapter) {
        return new CheckPropertyEditorFactory(widgetAdapter);
    }

    public static TextDialogPropertyEditorFactory createTextDialog(EnhancedFormWidgetAdapter widgetAdapter) {
        return new TextDialogPropertyEditorFactory(widgetAdapter);
    }

    public static FormTextPropertyEditorFactory createFormText(FormToolkit toolkit) {
        return new FormTextPropertyEditorFactory(toolkit);
    }

    public static TreeDrivenTablePropertyEditorFactory createTreeDrivenTablePropertyEditorFactory(FormToolkit toolkit) {
        return new TreeDrivenTablePropertyEditorFactory(toolkit);
    }

    public abstract PropertyEditor build(Composite var1);

    public abstract PropertyEditorFactory defaults();

    public abstract PropertyEditorFactory layoutData(GridDataFactory var1);

    public static class CheckPropertyEditorFactory
    extends PropertyEditorFactory {
        private GridDataFactory layoutData;
        private FormsWidgetAdapter widgetAdapter;

        public CheckPropertyEditorFactory(FormsWidgetAdapter widgetAdapter) {
            this.widgetAdapter = widgetAdapter;
        }

        public CheckboxPropertyEditor build(Composite parent) {
            CheckboxPropertyEditor propEditor = new CheckboxPropertyEditor(parent, (WidgetAdapter)this.widgetAdapter);
            this.layoutData.applyTo(propEditor.getControl());
            return propEditor;
        }

        @Override
        public CheckPropertyEditorFactory defaults() {
            return this.layoutData(GridDataFactory.swtDefaults().align(4, 4).span(1, 1).grab(false, false));
        }

        @Override
        public CheckPropertyEditorFactory layoutData(GridDataFactory factory) {
            this.layoutData = factory;
            return this;
        }
    }

    public static class ComboPropertyEditorFactory
    extends PropertyEditorFactory {
        private IObservableList items;
        private GridDataFactory layoutData;
        private ILabelProvider labelProvider;
        private WidgetAdapter widgetAdapter;

        public ComboPropertyEditorFactory(WidgetAdapter widgetAdapter) {
            this.widgetAdapter = widgetAdapter;
        }

        @Override
        public ListBoundComboPropertyEditor build(Composite parent) {
            ListBoundComboPropertyEditor propEditor = new ListBoundComboPropertyEditor(parent, this.items, this.widgetAdapter, this.labelProvider);
            this.layoutData.applyTo((Control)propEditor.getControl());
            return propEditor;
        }

        public DynamicListBoundComboPropertyEditor buildDynamic(Composite parent) {
            DynamicListBoundComboPropertyEditor propEditor = new DynamicListBoundComboPropertyEditor(parent, this.widgetAdapter, this.items, this.labelProvider);
            this.layoutData.applyTo((Control)propEditor.getControl());
            return propEditor;
        }

        public ComboPropertyEditorFactory labelProvider(ILabelProvider labelProvider) {
            this.labelProvider = labelProvider;
            return this;
        }

        public ComboPropertyEditorFactory items(IObservableList items) {
            this.items = items;
            return this;
        }

        @Override
        public ComboPropertyEditorFactory defaults() {
            return this.layoutData(GridDataFactory.swtDefaults().align(4, 4).span(1, 1).grab(false, false));
        }

        @Override
        public ComboPropertyEditorFactory layoutData(GridDataFactory factory) {
            this.layoutData = factory;
            return this;
        }
    }

    public static class FormTextPropertyEditorFactory
    extends PropertyEditorFactory {
        private FormToolkit toolkit;
        private GridDataFactory gridDataFactory;
        private List<DialogCreationStrategy> dialogCreationStrategies = Collections.EMPTY_LIST;

        public FormTextPropertyEditorFactory(FormToolkit toolkit) {
            this.toolkit = toolkit;
        }

        public FormTextPropertyEditor build(Composite parent) {
            FormTextPropertyEditor formTextPropertyEditor = new FormTextPropertyEditor(parent, this.toolkit, this.dialogCreationStrategies);
            this.gridDataFactory.applyTo(formTextPropertyEditor.getControl());
            return formTextPropertyEditor;
        }

        @Override
        public FormTextPropertyEditorFactory layoutData(GridDataFactory factory) {
            this.gridDataFactory = factory;
            return this;
        }

        @Override
        public FormTextPropertyEditorFactory defaults() {
            this.gridDataFactory = GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false);
            return this;
        }

        public FormTextPropertyEditorFactory addDialogCreationStrategy(DialogCreationStrategy strategy) {
            if (this.dialogCreationStrategies.isEmpty()) {
                this.dialogCreationStrategies = new ArrayList<DialogCreationStrategy>(1);
            }
            this.dialogCreationStrategies.add(strategy);
            return this;
        }
    }

    public static class TablePropertyEditorFactory
    extends PropertyEditorFactory {
        private FormToolkit toolkit;
        private GridDataFactory layoutData;
        private SelectionBasedEditorFactory tableEditorFactory;

        public TablePropertyEditorFactory(FormToolkit toolkit) {
            this.toolkit = toolkit;
        }

        public TablePropertyEditor build(Composite parent, TableFactory tableFactory) {
            TablePropertyEditor editor = new TablePropertyEditor(parent, this.toolkit, tableFactory, this.tableEditorFactory);
            editor.getControl().setLayoutData((Object)this.layoutData.create());
            return editor;
        }

        @Override
        public TablePropertyEditorFactory defaults() {
            return this.layoutData(GridDataFactory.swtDefaults().span(1, 1).align(4, 4).grab(true, true));
        }

        @Override
        public TablePropertyEditorFactory layoutData(GridDataFactory factory) {
            this.layoutData = factory;
            return this;
        }

        public TablePropertyEditorFactory editor(SelectionBasedEditorFactory editorFactory) {
            this.tableEditorFactory = editorFactory;
            return this;
        }

        @Override
        public PropertyEditor build(Composite parent) {
            throw new UnsupportedOperationException("Use build(parent, tableFactory");
        }
    }

    public static class TextDialogPropertyEditorFactory
    extends PropertyEditorFactory {
        private final EnhancedFormWidgetAdapter widgetAdapter;
        private boolean mustEditWithDialog;
        private List<DialogCreationStrategy> dialogCreationStrategy = new ArrayList<DialogCreationStrategy>(1);
        private GridDataFactory layoutData;

        public TextDialogPropertyEditorFactory(EnhancedFormWidgetAdapter widgetAdapter) {
            this.widgetAdapter = widgetAdapter;
        }

        public TextDialogPropertyEditor build(Composite parent) {
            TextDialogPropertyEditor editor = new TextDialogPropertyEditor(parent, this.dialogCreationStrategy, (WidgetAdapter)this.widgetAdapter, this.mustEditWithDialog){

                protected Control createBindingControl(Composite parent, int style) {
                    return super.createBindingControl(parent, style | (TextDialogPropertyEditorFactory.this.mustEditWithDialog ? 2048 : 0));
                }
            };
            this.layoutData.applyTo(editor.getControl());
            return editor;
        }

        @Override
        public TextDialogPropertyEditorFactory defaults() {
            this.dialogCreationStrategy.clear();
            this.layoutData(GridDataFactory.fillDefaults().grab(true, false));
            return this;
        }

        public TextDialogPropertyEditorFactory mustEditWithDialog(boolean mustEditWithDialog) {
            this.mustEditWithDialog = mustEditWithDialog;
            return this;
        }

        @Override
        public TextDialogPropertyEditorFactory layoutData(GridDataFactory factory) {
            this.layoutData = factory;
            return this;
        }

        public TextDialogPropertyEditorFactory addCreationStrategy(DialogCreationStrategy dialogCreationStrategy) {
            this.dialogCreationStrategy.add(dialogCreationStrategy);
            return this;
        }
    }

    public static class TextPropertyEditorFactory
    extends PropertyEditorFactory {
        private WidgetAdapter widgetAdapter;
        private GridDataFactory factory;
        private int widgetStyle = 0;

        public TextPropertyEditorFactory(EnhancedFormWidgetAdapter widgetAdapter) {
            this.widgetAdapter = widgetAdapter;
        }

        public TextPropertyEditor build(Composite parent) {
            Object textEditor = this.widgetStyle == 0 ? new TextPropertyEditor(parent, this.widgetAdapter) : new EnhancedTextPropertyEditor(parent, this.widgetAdapter, this.widgetStyle);
            this.factory.applyTo(textEditor.getBindingControl());
            return textEditor;
        }

        @Override
        public TextPropertyEditorFactory layoutData(GridDataFactory factory) {
            this.factory = factory;
            return this;
        }

        @Override
        public TextPropertyEditorFactory defaults() {
            this.factory = GridDataFactory.fillDefaults().align(4, 0x1000008).grab(true, false);
            return this;
        }

        public TextPropertyEditorFactory style(int newStyle) {
            this.widgetStyle = newStyle;
            return this;
        }
    }

    public static class TreeDrivenTablePropertyEditorFactory
    extends PropertyEditorFactory {
        private final FormToolkit toolkit;
        private SelectionBasedEditorFactory treeEditorFactory;
        private GridDataFactory layoutData;
        private SelectionBasedEditorFactory tableEditorFactory;

        public TreeDrivenTablePropertyEditorFactory(FormToolkit toolkit) {
            this.toolkit = toolkit;
        }

        public TreeDrivenTablePropertyEditor build(Composite parent, TableFactory tableFactory, TreeTableFactory treeTableFactory) {
            TreeDrivenTablePropertyEditor editor = new TreeDrivenTablePropertyEditor(parent, this.toolkit, tableFactory, treeTableFactory, this.tableEditorFactory, this.treeEditorFactory);
            editor.getControl().setLayoutData((Object)this.layoutData.create());
            return editor;
        }

        @Override
        public TreeDrivenTablePropertyEditorFactory defaults() {
            return this.layoutData(GridDataFactory.swtDefaults().span(2, 1).align(4, 4).grab(true, true));
        }

        @Override
        public TreeDrivenTablePropertyEditorFactory layoutData(GridDataFactory factory) {
            this.layoutData = factory;
            return this;
        }

        @Override
        public PropertyEditor build(Composite parent) {
            throw new UnsupportedOperationException("Use build(parent, tableFactory");
        }

        public TreeDrivenTablePropertyEditorFactory tableEditor(SelectionBasedEditorFactory editorFactory) {
            this.tableEditorFactory = editorFactory;
            return this;
        }

        public TreeDrivenTablePropertyEditorFactory treeEditor(SelectionBasedEditorFactory editorFactory) {
            this.treeEditorFactory = editorFactory;
            return this;
        }
    }
}

