/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import java.util.ArrayList;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.command.SelectionOperationHandler;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ActionFactory;
import oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control.ISelectionContributionItem;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.databinding.util.JFaceProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class CompositeActionFactory
extends ActionFactory {
    private SelectionBasedActionFactory factory;

    @Override
    public ISelectionContributionItem build() {
        if (this.factory == null) {
            throw new AssertionError((Object)"handlerFactory must both be set");
        }
        MenuContributor contributor = new MenuContributor(this.factory, this.text, this.imageDesc);
        contributor.update();
        if (this.text != null) {
            contributor.setToolTipText(this.text);
        }
        return contributor;
    }

    public CompositeActionFactory factory(SelectionBasedActionFactory actionFactory) {
        this.factory = actionFactory;
        return this;
    }

    @Override
    public CompositeActionFactory handler(SelectionOperationHandler operationHandler) {
        throw new UnsupportedOperationException("Use handler(SelectionOperationHandlerFactory) instead");
    }

    private static class MenuContributor
    extends ActionContributionItem
    implements ISelectionContributionItem {
        private List<ISelectionContributionItem> menuItems = new ArrayList<ISelectionContributionItem>();
        private final SelectionBasedActionFactory factory;
        private IObservableValue enabledObservable;
        private IObservableValue visibleObservable;
        private WritableValue numChildren;

        public MenuContributor(SelectionBasedActionFactory factory, String text, ImageDescriptor image) {
            super((IAction)new Action(text, 4){});
            this.getAction().setImageDescriptor(image);
            this.factory = factory;
            this.getEnabled().setValue((Object)Boolean.FALSE);
            this.getAction().setMenuCreator(new IMenuCreator(){
                private Menu listMenu;
                private MenuManager manager;

                public Menu getMenu(Menu parent) {
                    MenuManager manager = new MenuManager();
                    for (ISelectionContributionItem item : MenuContributor.this.menuItems) {
                        manager.add((IContributionItem)item);
                    }
                    this.listMenu = new Menu(parent);
                    manager.fill(this.listMenu, -1);
                    return this.listMenu;
                }

                public Menu getMenu(Control parent) {
                    if (this.manager == null) {
                        this.manager = new MenuManager();
                        this.manager.setRemoveAllWhenShown(true);
                    }
                    this.manager.addMenuListener(new IMenuListener(){

                        public void menuAboutToShow(IMenuManager manager) {
                            for (ISelectionContributionItem item : MenuContributor.this.menuItems) {
                                manager.add((IContributionItem)item);
                            }
                        }
                    });
                    Menu createContextMenu = this.manager.createContextMenu(parent);
                    return createContextMenu;
                }

                public void dispose() {
                    if (this.listMenu != null) {
                        this.listMenu.dispose();
                    }
                }
            });
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.menuItems = this.factory.createItems(event.getSelection());
            this.numChildren.setValue((Object)this.menuItems.size());
        }

        @Override
        public IObservableValue getNumChildren() {
            if (this.numChildren == null) {
                this.numChildren = new WritableValue((Object)0, Integer.class);
            }
            return this.numChildren;
        }

        @Override
        public void setToolTipText(String toolTip) {
            this.getAction().setToolTipText(toolTip);
        }

        @Override
        public IObservableValue getEnabled() {
            if (this.enabledObservable == null) {
                this.enabledObservable = JFaceProperties.value(Action.class, (String)"enabled", (String)"enabled").observe((Object)this.getAction());
            }
            return this.enabledObservable;
        }

        @Override
        public IObservableValue getVisible() {
            if (this.visibleObservable == null) {
                this.visibleObservable = JFaceProperties.value(Action.class, (String)"visible", (String)"enabled").observe((Object)this.getAction());
            }
            return this.visibleObservable;
        }

        public void dispose() {
            super.dispose();
            if (this.enabledObservable != null) {
                this.enabledObservable.dispose();
                this.enabledObservable = null;
            }
            if (this.visibleObservable != null) {
                this.visibleObservable.dispose();
                this.visibleObservable = null;
            }
        }

        @Override
        public void setSelection(ISelection build) {
        }
    }

    public static abstract class SelectionBasedActionFactory {
        public abstract List<ISelectionContributionItem> createItems(ISelection var1);
    }
}

