/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.ui.editor.control;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class ColumnWidgetFactory {
    protected boolean headerVisible;
    protected boolean linesVisible;
    protected List<ColumnFactory> columns;

    public abstract Composite build(FormToolkit var1, Composite var2);

    public ColumnWidgetFactory defaults() {
        return this.headerVisible(true).linesVisible(false);
    }

    public ColumnWidgetFactory headerVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
        return this;
    }

    public ColumnWidgetFactory linesVisible(boolean linesVisible) {
        this.linesVisible = linesVisible;
        return this;
    }

    public ColumnWidgetFactory addColumn(ColumnFactory column) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnFactory>();
        }
        this.columns.add(column);
        return this;
    }

    protected boolean isHeaderVisible() {
        return this.headerVisible;
    }

    protected boolean isLinesVisible() {
        return this.linesVisible;
    }

    protected List<? extends ColumnFactory> getColumns() {
        return this.columns;
    }

    protected int[] calcColumnWeights() {
        int[] weights = new int[this.columns.size()];
        int equalWeight = Math.round(100 / this.columns.size());
        int i = 0;
        while (i < this.columns.size()) {
            weights[i] = this.columns.get(i).weight == -1000 ? equalWeight : this.columns.get(i).weight;
            ++i;
        }
        return weights;
    }

    public int columnCount() {
        return this.columns.size();
    }

    public static abstract class ColumnFactory {
        public static final int EQUAL_WEIGHT = -1000;
        private boolean isResizable;
        private boolean isMoveable;
        private String text;
        private int weight = -1000;

        public static ColumnFactory create() {
            return null;
        }

        public ColumnFactory resizable(boolean isResizable) {
            this.isResizable = isResizable;
            return this;
        }

        public ColumnFactory moveable(boolean isMoveable) {
            this.isMoveable = isMoveable;
            return this;
        }

        public ColumnFactory text(String text) {
            this.text = text;
            return this;
        }

        public ColumnFactory defaults() {
            return this.moveable(false).resizable(false).weight(-1000).text("UNINITIALIZED");
        }

        public ColumnFactory weight(int weight) {
            this.weight = weight;
            return this;
        }

        public boolean isResizable() {
            return this.isResizable;
        }

        public boolean isMoveable() {
            return this.isMoveable;
        }

        public String getText() {
            return this.text;
        }

        public int getWeight() {
            return this.weight;
        }
    }
}

