/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.util;

import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IComponentModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IFormOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.INamedDefinitionModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ITableFormOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ITableOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IValueBindingModelElement;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ValueBindingPropertyListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        INamedDefinitionModelElement namedDef;
        IValueBindingModelElement newVB;
        Element modelElem = event.property().element();
        ITableFormOptionsModelElement optionsModel = (ITableFormOptionsModelElement)modelElem.nearest(ITableFormOptionsModelElement.class);
        boolean isReadOnly = optionsModel.isReadOnly().content() == Boolean.TRUE;
        ElementList<IValueBindingModelElement> vbList = ValueBindingPropertyListener.getValueBindings(optionsModel);
        if (vbList != null && !vbList.isEmpty() && (newVB = (IValueBindingModelElement)vbList.get(vbList.size() - 1)) != null && (newVB.getValueBinding().content() == null || ((String)newVB.getValueBinding().content()).isEmpty()) && (namedDef = ValueBindingPropertyListener.getNamedDefProposal(optionsModel, vbList)) != null) {
            ElementList<IComponentModelElement> comps;
            newVB.setDisplayLabel("<default>");
            newVB.setValueBinding((String)namedDef.getFullName().content());
            String componentToUse = (String)namedDef.getDefaultComponentId().content();
            if (!isReadOnly && (comps = namedDef.getAvailableComponents()) != null && !comps.isEmpty()) {
                componentToUse = (String)((IComponentModelElement)comps.get(0)).getId().content();
            }
            newVB.setComponentToUse(componentToUse);
        }
    }

    private static ElementList<IValueBindingModelElement> getValueBindings(ITableFormOptionsModelElement optionsModel) {
        if (optionsModel instanceof IFormOptionsModelElement) {
            return ((IFormOptionsModelElement)optionsModel).getFields();
        }
        if (optionsModel instanceof ITableOptionsModelElement) {
            return ((ITableOptionsModelElement)optionsModel).getColumns();
        }
        return null;
    }

    private static INamedDefinitionModelElement getNamedDefProposal(ITableFormOptionsModelElement optionsModel, ElementList<IValueBindingModelElement> vbList) {
        ElementList<INamedDefinitionModelElement> namedDefs = optionsModel.getNamedDefs();
        if (namedDefs != null && namedDefs.size() > 0) {
            for (INamedDefinitionModelElement namedDef : namedDefs) {
                String name = (String)namedDef.getFullName().content();
                boolean alreadyInList = false;
                for (IValueBindingModelElement vb : vbList) {
                    String existingVBName = (String)vb.getValueBinding().content();
                    if (name == null || existingVBName == null || !name.equals(existingVBName)) continue;
                    alreadyInList = true;
                    break;
                }
                if (alreadyInList) continue;
                return namedDef;
            }
            return (INamedDefinitionModelElement)namedDefs.get(0);
        }
        return null;
    }
}

