/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.util;

import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IComponentModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IFormOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.INamedDefinitionModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ITableFormOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.ITableOptionsModelElement;
import oracle.eclipse.tools.adf.dtrt.vcommon.options.faces.IValueBindingModelElement;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.PropertyContentEvent;

public class ReadOnlyTableFormPropertyListener
extends FilteredListener<PropertyContentEvent> {
    protected void handleTypedEvent(PropertyContentEvent event) {
        Element modelElem = event.property().element();
        ITableFormOptionsModelElement optionsModel = (ITableFormOptionsModelElement)modelElem.nearest(ITableFormOptionsModelElement.class);
        boolean isReadOnly = optionsModel.isReadOnly().content() == Boolean.TRUE;
        ElementList<IValueBindingModelElement> vbList = ReadOnlyTableFormPropertyListener.getValueBindings(optionsModel);
        if (vbList != null && !vbList.isEmpty()) {
            for (IValueBindingModelElement vb : vbList) {
                String id;
                String name = (String)vb.getValueBinding().content();
                String componentId = (String)vb.getComponentToUse().content();
                IComponentModelElement comp = ReadOnlyTableFormPropertyListener.getCurrentComponent(optionsModel, name, componentId);
                if (!isReadOnly || comp == null || comp.isRead().content() == Boolean.TRUE || (id = ReadOnlyTableFormPropertyListener.getDefaultComponentId(optionsModel, name)) == null) continue;
                vb.setComponentToUse(id);
            }
        }
    }

    private static ElementList<IValueBindingModelElement> getValueBindings(ITableFormOptionsModelElement optionsModel) {
        if (optionsModel instanceof IFormOptionsModelElement) {
            return ((IFormOptionsModelElement)optionsModel).getFields();
        }
        if (optionsModel instanceof ITableOptionsModelElement) {
            return ((ITableOptionsModelElement)optionsModel).getColumns();
        }
        return null;
    }

    private static IComponentModelElement getCurrentComponent(ITableFormOptionsModelElement optionsModel, String vbName, String compId) {
        for (INamedDefinitionModelElement namedDef : optionsModel.getNamedDefs()) {
            if (!((String)namedDef.getFullName().content()).equals(vbName)) continue;
            for (IComponentModelElement comp : namedDef.getAvailableComponents()) {
                if (!((String)comp.getId().content()).equals(compId)) continue;
                return comp;
            }
        }
        return null;
    }

    private static String getDefaultComponentId(ITableFormOptionsModelElement optionsModel, String vbName) {
        for (INamedDefinitionModelElement namedDef : optionsModel.getNamedDefs()) {
            if (!((String)namedDef.getFullName().content()).equals(vbName)) continue;
            return (String)namedDef.getDefaultComponentId().content();
        }
        return null;
    }
}

