/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.manager;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder.DocumentBinaryRecorder;
import oracle.eclipse.tools.adf.dtrt.vcommon.manager.IManagedFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.impl.PlatformResourceURIHandlerImpl;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseManagedXMLFile
extends DocumentBinaryRecorder
implements IManagedFile<Document, Document> {
    public static final EntityResolver ENTITY_RESOLVER = new EntityResolver(){

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (this.isDTD(systemId) || this.isDTD(publicId)) {
                StringReader stringInput = new StringReader(" ");
                return new InputSource(stringInput);
            }
            return null;
        }

        private boolean isDTD(String id) {
            return id != null && id.toLowerCase().endsWith(".dtd");
        }
    };
    private final IFile file;
    private boolean fileWasLoaded = false;
    private Object persistedContent;
    private long timestamp = -1L;

    public BaseManagedXMLFile(IFile file) {
        assert (file != null);
        this.file = file;
    }

    public final void dispose() {
        this.persistedContent = null;
        this.timestamp = -1L;
        this.resetRecording();
    }

    @Override
    public final IFile getFile() {
        return this.file;
    }

    @Override
    public final Document loadContent() {
        if (this.file.isAccessible()) {
            try {
                Document document = (Document)this.createContent();
                this.loadContent(this.getFileTransformer(), document, new BufferedInputStream(this.file.getContents(true)));
                this.fileWasLoaded = true;
                this.timestamp = this.file.getModificationStamp();
                assert (this.timestamp > 0L) : this.file;
                return document;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public final boolean fileWasLoaded() {
        return this.fileWasLoaded;
    }

    @Override
    public final void storePersistedContent(Document document, boolean beginRecording) {
        this.persistedContent = this.takeSnapshot(document);
        if (beginRecording) {
            this.markAsRecording();
            this.setRecordingData(this.persistedContent);
        }
    }

    @Override
    public final void save(Document document, IProgressMonitor monitor) throws Exception {
        OutputStream fileOutputStream = this.createFileOutputStream(monitor);
        this.writeContent(this.getFileTransformer(), document, fileOutputStream);
        this.persistedContent = this.takeSnapshot(document);
        assert (this.timestamp > 0L) : this.file;
    }

    private OutputStream createFileOutputStream(IProgressMonitor monitor) {
        return new BufferedOutputStream((OutputStream)new PlatformResourceURIHandlerImpl.PlatformResourceOutputStream(this.file, true, true, monitor){

            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    BaseManagedXMLFile.this.timestamp = this.file.getModificationStamp();
                    if (!$assertionsDisabled && BaseManagedXMLFile.this.timestamp <= 0L) {
                        throw new AssertionError(this.file);
                    }
                }
            }
        });
    }

    public final String toString() {
        return this.file.getFullPath().toString();
    }

    @Override
    public final boolean needsSaving(Document document) {
        return this.hasChangedExternally() || !(this.persistedContent == null || !this.file.isAccessible() ? document == null || document.getDocumentElement() == null : this.equals(document, this.persistedContent));
    }

    @Override
    public final boolean hasChangedExternally() {
        return this.file.getModificationStamp() != this.timestamp;
    }

    @Override
    public final boolean beginRecordingByContent(Document content) {
        return this.beginRecording(content);
    }

    @Override
    public final Object applyByContent(Document content, Object recordedData) {
        return this.apply(content, recordedData);
    }

    private Transformer getFileTransformer() {
        return this.getTransformer();
    }
}

