/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder;

import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.documentrecorder.DocumentRecorder;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IDocumentSelectionMediator;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.UndoDocumentEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public final class SSEDocumentRecorder
extends DocumentRecorder {
    public static boolean supports(Document document) {
        return document instanceof IDOMDocument;
    }

    @Override
    public void resetRecording() {
        if (this.getRecordingData() instanceof RecordedData) {
            RecordedData data = (RecordedData)this.getRecordingData();
            this.setRecordingData(null);
            data.structuredDocument = null;
            data.undoManager.getCommandStack().flush();
            data.undoManager = null;
        }
    }

    @Override
    protected void doBeginRecording(Document document) {
        this.aboutToChangeModel(document);
        IDOMDocument domDocument = (IDOMDocument)document;
        final IStructuredDocument structuredDocument = domDocument.getStructuredDocument();
        StructuredTextUndoManager undoManager = new StructuredTextUndoManager();
        undoManager.connect(new IDocumentSelectionMediator(){

            public void undoOperationSelectionChanged(UndoDocumentEvent event) {
            }

            public IDocument getDocument() {
                return structuredDocument;
            }
        });
        undoManager.enableUndoManagement();
        undoManager.beginRecording((Object)this);
        RecordedData data = new RecordedData();
        data.undoManager = undoManager;
        data.structuredDocument = structuredDocument;
        this.setRecordingData(data);
    }

    @Override
    protected Object doEndRecording(Document document, boolean aborted) {
        if (document instanceof IDOMDocument) {
            IDOMDocument domDocument = (IDOMDocument)document;
            IStructuredDocument structuredDocument = domDocument.getStructuredDocument();
            RecordedData data = (RecordedData)this.getRecordingData();
            this.setRecordingData(null);
            if (structuredDocument == data.structuredDocument) {
                data.undoManager.disableUndoManagement();
                if (!aborted) {
                    data.undoManager.endRecording((Object)this);
                    this.changedModel((Document)domDocument);
                    return data;
                }
            }
        }
        this.changedModel(document);
        return null;
    }

    @Override
    public Object apply(Document document, Object recordedData) {
        if (recordedData != null && document != null) {
            if (document instanceof IDOMDocument) {
                RecordedData data = this.checkRecordedData(recordedData);
                IStructuredTextUndoManager undoManager = data.undoManager;
                CommandStack commandStack = undoManager.getCommandStack();
                if (commandStack.getUndoCommand() != null || commandStack.getRedoCommand() != null) {
                    IDOMDocument domDocument;
                    block8: {
                        domDocument = (IDOMDocument)document;
                        try {
                            this.aboutToChangeModel(document);
                            if (commandStack.canUndo()) {
                                undoManager.undo();
                                break block8;
                            }
                            if (commandStack.canRedo()) {
                                undoManager.redo();
                                break block8;
                            }
                            throw new IllegalStateException("Unable to apply the recorded data");
                        }
                        finally {
                            this.changedModel(document);
                        }
                    }
                    data.structuredDocument = domDocument.getStructuredDocument();
                }
                return data;
            }
            throw new IllegalArgumentException("Unknown document type: " + document);
        }
        return null;
    }

    private RecordedData checkRecordedData(Object recordedData) {
        if (!(recordedData instanceof RecordedData)) {
            throw new IllegalArgumentException("The record data must be generated by this recorder - " + recordedData);
        }
        return (RecordedData)recordedData;
    }

    private void aboutToChangeModel(Document document) {
        IDOMModel model = ((IDOMDocument)document).getModel();
        IStructuredTextUndoManager undoManager = model.getUndoManager();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        undoManager.disableUndoManagement();
        structuredDocument.stopPostNotificationProcessing();
        model.aboutToChangeModel();
    }

    private void changedModel(Document document) {
        IDOMModel model = ((IDOMDocument)document).getModel();
        IStructuredTextUndoManager undoManager = model.getUndoManager();
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        model.changedModel();
        structuredDocument.resumePostNotificationProcessing();
        undoManager.enableUndoManagement();
    }

    private static class RecordedData {
        public IStructuredTextUndoManager undoManager;
        public IStructuredDocument structuredDocument;

        private RecordedData() {
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.undoManager == null ? 0 : this.undoManager.hashCode());
            result = 31 * result + (this.structuredDocument == null ? 0 : this.structuredDocument.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RecordedData other = (RecordedData)obj;
            return DTRTUtil.equals((Object)this.undoManager, (Object)other.undoManager) && DTRTUtil.equals((Object)this.structuredDocument, (Object)other.structuredDocument);
        }
    }
}

