/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ISetCommand;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.ContextCommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class SetCommandImpl
extends ContextCommandImpl
implements ISetCommand {
    private static final Object NULL = "null";
    private IObject object;
    private IDescribable property;
    private Object value;
    private Object valueBeforeExecution = NULL;

    public static String getLabel(IDescribable property) {
        String label = DTRTUtil.getLabel((IDescribable)property);
        return label != null ? NLS.bind((String)Messages.setValue, (Object)label) : null;
    }

    public SetCommandImpl(IOEPEExecutableContext context) {
        super(context);
    }

    @Override
    public void dispose() {
        this.object = null;
        this.property = null;
        this.value = null;
        this.valueBeforeExecution = null;
        super.dispose();
    }

    public String getLabel() {
        return SetCommandImpl.getLabel(this.getProperty());
    }

    public List<? extends IObject> getAffectedObjects() {
        return this.getLastOperation() != null && this.getObject() != null ? Collections.singletonList(this.getObject()) : Collections.emptyList();
    }

    public SetCommandImpl setObject(IObject object) {
        this.checkExecuted();
        this.object = object;
        return this;
    }

    public IObject getObject() {
        return this.object;
    }

    public SetCommandImpl setProperty(IDescribable property) {
        this.checkExecuted();
        this.property = property;
        return this;
    }

    public IDescribable getProperty() {
        return this.property;
    }

    public SetCommandImpl setValue(Object value) {
        this.checkExecuted();
        this.value = value;
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public final SetCommandImpl clone() {
        return this.instantiate().setObject(this.getObject()).setProperty(this.getProperty()).setValue(this.getValue());
    }

    protected abstract SetCommandImpl instantiate();

    protected final Object getValueBeforeExecution() {
        return this.isValueBeforeExecutionSet() ? this.valueBeforeExecution : null;
    }

    protected final boolean isValueBeforeExecutionSet() {
        return this.valueBeforeExecution != NULL;
    }

    protected final void initializeValueBeforeExecution(Object valueBeforeExecution) {
        if (!this.isValueBeforeExecutionSet()) {
            this.valueBeforeExecution = valueBeforeExecution;
        }
    }

    @Override
    protected void assertExecution() throws Exception {
        super.assertExecution();
        DTRTUtil.assertTrue((boolean)this.getCommandStack().isKnown(this.getObject()), (String)"The object of a set command must be known by the command stack.");
        DTRTUtil.assertTrue((boolean)DTRTObjectUtil.isAccessible((IObject)this.getObject()), (String)"The object of a set command cannot be null, disposed, nor deleted.");
        DTRTUtil.assertTrue((this.getProperty() != null ? 1 : 0) != 0, (String)"The property of a set command cannot be null.");
    }

    @Override
    protected void assertUndo() throws Exception {
        super.assertUndo();
        DTRTUtil.assertTrue((boolean)this.isValueBeforeExecutionSet(), (String)"The value before the execution must be set in order to undo a set command.");
    }

    @Override
    protected final void doExecute(IProgressMonitor monitor) throws Exception {
        this.doSetValue(this.getValue(), monitor);
    }

    @Override
    protected final void doUndo(IProgressMonitor monitor) throws Exception {
        assert (this.isValueBeforeExecutionSet());
        this.doSetValue(this.getValueBeforeExecution(), monitor);
    }

    protected abstract void doSetValue(Object var1, IProgressMonitor var2) throws Exception;
}

