/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import java.util.Collection;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandRunnable;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.command.IRunnableCommand;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ObjectList;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.CommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.Messages;
import oracle.eclipse.tools.common.util.ProgressMonitorUtil;
import org.eclipse.core.runtime.IProgressMonitor;

public class RunnableCommandImpl
extends CommandImpl
implements IRunnableCommand {
    private String label;
    private ObjectList<Object> affectedObjects;
    private Runnable executionRunnable;
    private Runnable undoRunnable;
    private Runnable redoRunnable;

    public RunnableCommandImpl(ICommandStack commandStack) {
        super(commandStack);
    }

    @Override
    public void dispose() {
        if (this.affectedObjects != null) {
            this.affectedObjects.clear();
            this.affectedObjects = null;
        }
        if (this.executionRunnable instanceof ICommandRunnable) {
            ((ICommandRunnable)this.executionRunnable).dispose();
        }
        this.executionRunnable = null;
        if (this.undoRunnable instanceof ICommandRunnable) {
            ((ICommandRunnable)this.undoRunnable).dispose();
        }
        this.undoRunnable = null;
        if (this.redoRunnable instanceof ICommandRunnable) {
            ((ICommandRunnable)this.redoRunnable).dispose();
        }
        this.redoRunnable = null;
        this.label = null;
        super.dispose();
    }

    public String getLabel() {
        return this.label;
    }

    public List<?> getAffectedObjects() {
        if (this.affectedObjects == null) {
            this.affectedObjects = new ObjectList(0);
        }
        return this.affectedObjects.getUnmodifiableView();
    }

    public IRunnableCommand setExecutionRunnable(String label, Runnable runnable) throws IllegalStateException {
        this.checkExecuted();
        if (label == null) {
            throw new IllegalArgumentException(Messages.labelCannotBeNull);
        }
        this.label = label;
        this.executionRunnable = runnable;
        return this;
    }

    public Runnable getExecutionRunnable() {
        return this.executionRunnable;
    }

    public IRunnableCommand setUndoRunnable(Runnable runnable) throws IllegalStateException {
        this.checkExecuted();
        this.undoRunnable = runnable;
        return this;
    }

    public Runnable getUndoRunnable() {
        return this.undoRunnable;
    }

    public IRunnableCommand setRedoRunnable(Runnable runnable) throws IllegalStateException {
        this.checkExecuted();
        this.redoRunnable = runnable;
        return this;
    }

    public Runnable getRedoRunnable() {
        return this.redoRunnable;
    }

    @Override
    protected void assertExecution() throws Exception {
        DTRTUtil.assertTrue((this.getExecutionRunnable() != null ? 1 : 0) != 0, (String)Messages.executionRunnableMustBeSet);
        if (this.getExecutionRunnable() instanceof ICommandRunnable) {
            DTRTUtil.assertTrue((!((ICommandRunnable)this.getExecutionRunnable()).isDisposed() ? 1 : 0) != 0, (String)Messages.executionRunnableCannotBeDisposed);
        }
    }

    @Override
    protected void doExecute(IProgressMonitor monitor) throws Exception {
        this.run(this.getExecutionRunnable(), ICommand.CommandOperation.EXECUTION, monitor);
    }

    @Override
    protected void assertUndo() throws Exception {
        DTRTUtil.assertTrue((this.getUndoRunnable() != null ? 1 : 0) != 0, (String)Messages.undoRunnableMustBeSet);
        if (this.getUndoRunnable() instanceof ICommandRunnable) {
            DTRTUtil.assertTrue((!((ICommandRunnable)this.getUndoRunnable()).isDisposed() ? 1 : 0) != 0, (String)Messages.undoRunnableCannotBeDisposed);
        }
    }

    @Override
    protected final void doUndo(IProgressMonitor monitor) throws Exception {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
        this.beforeUndo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        this.run(this.getUndoRunnable(), ICommand.CommandOperation.UNDO, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)3));
        this.afterUndo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    @Override
    protected void assertRedo() throws Exception {
        DTRTUtil.assertTrue((this.getRedoRunnable() != null ? 1 : 0) != 0, (String)Messages.redoRunnableMustBeSet);
        if (this.getRedoRunnable() instanceof ICommandRunnable) {
            DTRTUtil.assertTrue((!((ICommandRunnable)this.getRedoRunnable()).isDisposed() ? 1 : 0) != 0, (String)Messages.redoRunnableCannotBeDisposed);
        }
    }

    @Override
    protected final void doRedo(IProgressMonitor monitor) throws Exception {
        ProgressMonitorUtil.beginTask((IProgressMonitor)monitor, (int)5);
        this.beforeRedo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
        this.run(this.getRedoRunnable(), ICommand.CommandOperation.REDO, ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)3));
        this.afterRedo(ProgressMonitorUtil.submon((IProgressMonitor)monitor, (int)1));
    }

    private void run(Runnable runnable, ICommand.CommandOperation commandOperation, IProgressMonitor monitor) throws Exception {
        if (this.affectedObjects != null) {
            this.affectedObjects.clear();
        }
        if (runnable instanceof ICommandRunnable) {
            List list = ((ICommandRunnable)runnable).run(this.getCommandStack(), commandOperation, monitor);
            if (list != null && !list.isEmpty()) {
                if (this.affectedObjects == null) {
                    this.affectedObjects = new ObjectList((Collection)list);
                } else {
                    this.affectedObjects.addAll((Collection)list);
                }
            }
        } else if (runnable != null) {
            runnable.run();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [label=").append(this.label).append(']');
        return builder.toString();
    }

    protected void beforeUndo(IProgressMonitor monitor) throws Exception {
    }

    protected void afterUndo(IProgressMonitor monitor) throws Exception {
    }

    protected void beforeRedo(IProgressMonitor monitor) throws Exception {
    }

    protected void afterRedo(IProgressMonitor monitor) throws Exception {
    }
}

