/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.IDeleteCommand;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.ContextCommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class DeleteCommandImpl
extends ContextCommandImpl
implements IDeleteCommand {
    private IObject parent;
    private IObject object;

    public DeleteCommandImpl(IOEPEExecutableContext context) {
        super(context);
    }

    @Override
    public void dispose() {
        this.parent = null;
        this.object = null;
        super.dispose();
    }

    public String getLabel() {
        String label = DTRTUtil.getLabel((IDescribable)this.getObject());
        return label != null ? NLS.bind((String)Messages.deleteObject, (Object)label) : null;
    }

    public List<? extends IObject> getAffectedObjects() {
        return this.getLastOperation() == ICommand.CommandOperation.UNDO && this.getObject() != null ? Collections.singletonList(this.getObject()) : Collections.emptyList();
    }

    public DeleteCommandImpl setObject(IObject object) {
        this.checkExecuted();
        this.object = object;
        return this;
    }

    public IObject getObject() {
        return this.object;
    }

    public DeleteCommandImpl setParent(IObject parent) {
        this.checkExecuted();
        this.parent = parent;
        return this;
    }

    public IObject getParent() {
        return this.parent;
    }

    @Override
    public DeleteCommandImpl clone() {
        return this.instantiate().setParent(this.getParent()).setObject(this.getObject());
    }

    protected abstract DeleteCommandImpl instantiate();

    @Override
    protected void assertExecution() throws Exception {
        super.assertExecution();
        DTRTUtil.assertTrue((boolean)this.getCommandStack().isKnown(this.getObject()), (String)"The object of a delete command must be known by the command stack.");
        DTRTUtil.assertTrue((boolean)DTRTObjectUtil.isAccessible((IObject)this.getObject()), (String)"The object of a delete command cannot be null, disposed, nor deleted.");
        DTRTUtil.assertTrue((this.getParent() == null || this.getCommandStack().isKnown(this.getParent()) ? 1 : 0) != 0, (String)"The parent of the object to be deleted must be known by the command stack.");
        DTRTUtil.assertTrue((this.getParent() == null || DTRTObjectUtil.isAccessible((IObject)this.getParent()) ? 1 : 0) != 0, (String)"The parent of the object to be deleted cannot be null, disposed, nor deleted.");
    }

    @Override
    protected void assertUndo() throws Exception {
        super.assertUndo();
        DTRTUtil.assertTrue((boolean)DTRTObjectUtil.isNotDisposed((IObject)this.getObject()), (String)"The object can neither be null nor disposed in oder to undo a delete command.");
    }
}

