/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.context.IOEPEExecutableContext;
import oracle.eclipse.tools.adf.dtrt.context.command.ICreateCommand;
import oracle.eclipse.tools.adf.dtrt.object.IObject;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.IDescribable;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.ContextCommandImpl;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.Messages;
import org.eclipse.osgi.util.NLS;

public abstract class CreateCommandImpl
extends ContextCommandImpl
implements ICreateCommand {
    private IObject parent;
    private IDescribable type;
    private String id;
    private IObject createdObject;

    protected CreateCommandImpl(IOEPEExecutableContext context) {
        super(context);
    }

    @Override
    public void dispose() {
        this.parent = null;
        this.type = null;
        this.createdObject = null;
        this.id = null;
        super.dispose();
    }

    public String getLabel() {
        String label = DTRTUtil.getLabel((IDescribable)this.getType());
        return label != null ? NLS.bind((String)Messages.createType, (Object)label) : null;
    }

    public List<? extends IObject> getAffectedObjects() {
        return this.getLastOperation() != ICommand.CommandOperation.UNDO && this.getCreatedObject() != null ? Collections.singletonList(this.getCreatedObject()) : Collections.emptyList();
    }

    public CreateCommandImpl setType(IDescribable type) {
        this.checkExecuted();
        this.type = type;
        return this;
    }

    public IDescribable getType() {
        return this.type;
    }

    public CreateCommandImpl setParent(IObject parent) {
        this.checkExecuted();
        this.parent = parent;
        return this;
    }

    public IObject getParent() {
        return this.parent;
    }

    public ICreateCommand setObjectId(String id) throws IllegalStateException {
        this.checkExecuted();
        this.id = id;
        return this;
    }

    public String getObjectId() {
        return this.id;
    }

    @Override
    public CreateCommandImpl clone() {
        return this.instantiate().setParent(this.getParent()).setType(this.getType());
    }

    protected abstract CreateCommandImpl instantiate();

    protected final void initializeCreatedObject(IObject createdObject) {
        if (this.createdObject == null) {
            this.createdObject = createdObject;
            if (createdObject != null) {
                this.id = createdObject.getId();
            }
        }
    }

    protected final IObject getCreatedObject() {
        return this.createdObject;
    }

    @Override
    protected void assertExecution() throws Exception {
        super.assertExecution();
        DTRTUtil.assertTrue((this.getType() != null ? 1 : 0) != 0, (String)"The type of the object to create cannot be null.");
        DTRTUtil.assertTrue((this.getParent() == null || this.getCommandStack().isKnown(this.getParent()) ? 1 : 0) != 0, (String)"The parent of the object to be created must be known by the command stack.");
        DTRTUtil.assertTrue((this.getParent() == null || DTRTObjectUtil.isAccessible((IObject)this.getParent()) ? 1 : 0) != 0, (String)"The parent of the object to be created cannot be null, disposed, nor deleted.");
    }

    @Override
    protected void assertUndo() throws Exception {
        super.assertUndo();
        DTRTUtil.assertTrue((boolean)DTRTObjectUtil.isAccessible((IObject)this.getCreatedObject()), (String)"The created object must be set in order to undo a create command");
    }

    @Override
    protected void assertRedo() throws Exception {
        DTRTUtil.assertTrue((this.getCreatedObject() != null ? 1 : 0) != 0, (String)"The created object must be set in order to redo a create command");
    }
}

