/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.command;

import oracle.eclipse.tools.adf.dtrt.command.CommandMessages;
import oracle.eclipse.tools.adf.dtrt.command.ICommand;
import oracle.eclipse.tools.adf.dtrt.command.ICommandStack;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.command.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public abstract class CommandImpl
implements ICommand {
    private ICommandStack commandStack;
    private ICommand.CommandOperation lastOperation;

    protected CommandImpl(ICommandStack commandStack) {
        if (commandStack == null) {
            throw new IllegalArgumentException(Messages.commandStackCannotBeNull);
        }
        this.commandStack = commandStack;
    }

    public void dispose() {
        this.commandStack = null;
        this.lastOperation = null;
    }

    public final boolean isDisposed() {
        return this.commandStack == null;
    }

    public ICommandStack getCommandStack() {
        return this.commandStack;
    }

    public final ICommand.CommandOperation getLastOperation() {
        return this.lastOperation;
    }

    protected final void checkExecuted() {
        if (this.lastOperation != null) {
            throw new IllegalStateException(Messages.commandStackHadBeenExecuted);
        }
    }

    public final IStatus canExecute() {
        ICommand.CommandOperation operation = ICommand.CommandOperation.EXECUTION;
        try {
            this.basicCanPerfomOperarion(operation);
            this.assertExecution();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return DTRTUtil.createErrorStatus((String)CommandMessages.getCannotPerformOperationMessage((ICommand)this, (ICommand.CommandOperation)operation), (Throwable)e);
        }
    }

    public final IStatus canUndo() {
        ICommand.CommandOperation operation = ICommand.CommandOperation.UNDO;
        try {
            this.basicCanPerfomOperarion(operation);
            this.assertUndo();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return DTRTUtil.createErrorStatus((String)CommandMessages.getCannotPerformOperationMessage((ICommand)this, (ICommand.CommandOperation)operation), (Throwable)e);
        }
    }

    public final IStatus canRedo() {
        ICommand.CommandOperation operation = ICommand.CommandOperation.REDO;
        try {
            this.basicCanPerfomOperarion(operation);
            this.assertRedo();
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return DTRTUtil.createErrorStatus((String)CommandMessages.getCannotPerformOperationMessage((ICommand)this, (ICommand.CommandOperation)operation), (Throwable)e);
        }
    }

    protected void basicCanPerfomOperarion(ICommand.CommandOperation operation) {
        DTRTUtil.assertTrue((!this.isDisposed() ? 1 : 0) != 0, (String)Messages.commandIsDisposed);
        DTRTUtil.assertTrue((this.getCommandStack() != null ? 1 : 0) != 0, (String)Messages.commandStackCannotBeNull);
        ICommand.CommandOperation nextOperation = ICommand.CommandOperation.nextOperation((ICommand)this);
        DTRTUtil.assertTrue((nextOperation == operation ? 1 : 0) != 0, (String)NLS.bind((String)Messages.invalidNextOperation, (Object)operation, (Object)nextOperation));
    }

    protected void assertExecution() throws Exception {
    }

    protected void assertUndo() throws Exception {
    }

    protected void assertRedo() throws Exception {
    }

    public final void execute(IProgressMonitor monitor) throws Exception {
        IStatus status = this.canExecute();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.doExecute(monitor);
        this.lastOperation = ICommand.CommandOperation.EXECUTION;
    }

    protected abstract void doExecute(IProgressMonitor var1) throws Exception;

    public final void undo(IProgressMonitor monitor) throws Exception {
        IStatus status = this.canUndo();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.doUndo(monitor);
        this.lastOperation = ICommand.CommandOperation.UNDO;
    }

    protected abstract void doUndo(IProgressMonitor var1) throws Exception;

    public final void redo(IProgressMonitor monitor) throws Exception {
        IStatus status = this.canRedo();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        this.doRedo(monitor);
        this.lastOperation = ICommand.CommandOperation.REDO;
    }

    protected void doRedo(IProgressMonitor monitor) throws Exception {
        this.doExecute(monitor);
    }
}

