/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.boundsource;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.adf.common.util.ProjectUtils;
import oracle.eclipse.tools.adf.dtrt.object.IBindingObject;
import oracle.eclipse.tools.adf.dtrt.object.IPageDefinition;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTBundleIcon;
import oracle.eclipse.tools.adf.dtrt.util.DTRTObjectUtil;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.boundsource.BoundSourceUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class TaskFlowActivityBoundSource
extends BaseDescribable
implements IPageDefinition.IBoundSource {
    static final String UNBOUNDED_TASK_FLOW_PAGE_PATH_PREFIX = "PageFlow#";
    private final IFile file;
    private final String taskFlowId;
    private final String activityId;
    private final IPath webRelativePath;
    private final String pagePath;

    static boolean isValid(IFile file, Element documentElement) {
        return TaskFlowActivityBoundSource.isValid(documentElement);
    }

    private static boolean isValid(Element documentElement) {
        return documentElement != null && (documentElement.getParentNode() == null || "http://xmlns.oracle.com/adf/controller".equals(documentElement.getNamespaceURI()) && "adfc-config".equals(documentElement.getLocalName()));
    }

    public TaskFlowActivityBoundSource(IFile file, String taskFlowId, String activityId) {
        if (file == null) {
            throw new IllegalArgumentException("The file argument cannot be null");
        }
        if (activityId == null) {
            throw new IllegalArgumentException("The activityId argument cannot be null");
        }
        IPath path = ProjectUtils.computeWebContentRelativePath((IResource)file);
        if (path == null) {
            throw new IllegalArgumentException("The file argument must be a resource in the web contents folder of a web project");
        }
        this.webRelativePath = path;
        String pagePath = path.toString();
        assert (pagePath.length() > 0);
        assert (pagePath.charAt(0) == '/') : pagePath;
        this.file = file;
        this.taskFlowId = taskFlowId;
        this.activityId = activityId;
        this.pagePath = taskFlowId != null ? pagePath + '#' + taskFlowId + '@' + activityId : UNBOUNDED_TASK_FLOW_PAGE_PATH_PREFIX + activityId;
    }

    public IPageDefinition.IBoundSource.BoundSourceType getType() {
        return IPageDefinition.IBoundSource.BoundSourceType.TASK_FLOW_ACTIVITY;
    }

    public IFile getFile() {
        return this.file;
    }

    public IStatus appliesTo(Object object) {
        if (object instanceof IFile) {
            return object.equals(this.file) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Different file");
        }
        if (object instanceof String) {
            return object.equals(this.taskFlowId) || object.equals(this.activityId) || object.equals(this.pagePath) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Supported string values: taskFlowId, activityId, pagePath");
        }
        if (object instanceof Node) {
            Node node = (Node)object;
            Element activityElement = this.findActivityElement(node.getOwnerDocument());
            return DTRTvCommonUtil.isSameOrParent(activityElement, node) ? Status.OK_STATUS : new Status(4, "oracle.eclipse.tools.adf.dtrt.vcommon", "Not the activity node");
        }
        return Status.CANCEL_STATUS;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getPreferredPageDefinitionFullName() {
        String name;
        if (this.taskFlowId != null) {
            name = this.getPagePath();
            name = name.replace(String.valueOf('.') + this.getFile().getFileExtension() + '#', "#");
        } else {
            String pagePath = DTRTvCommonUtil.removeFileExtension(this.webRelativePath.toString());
            assert (pagePath.length() > 0);
            assert (pagePath.charAt(0) == '/');
            name = String.valueOf(pagePath) + "__" + this.activityId;
        }
        if (name.startsWith("/WEB-INF")) {
            name = name.replace("/WEB-INF", "");
        }
        return BoundSourceUtil.computePageDefinitionFullName(name);
    }

    protected BaseDescriptor createDescriptor() {
        return new BaseDescriptor(){

            public String getLabel() {
                return NLS.bind((String)BoundSourceUtil.Messages.taskFlowLabel, (Object)TaskFlowActivityBoundSource.this.webRelativePath, (Object)TaskFlowActivityBoundSource.this.activityId);
            }

            public String getToolTipText() {
                return NLS.bind((String)BoundSourceUtil.Messages.taskFlowToolTip, (Object)TaskFlowActivityBoundSource.this.webRelativePath, (Object)TaskFlowActivityBoundSource.this.activityId);
            }

            public ImageManager.IImageData getImageData() {
                ImageManager imageManager = ImageManager.getInstance();
                ImageManager.IImageData data = imageManager.getWorkbenchImageData((Object)TaskFlowActivityBoundSource.this.getFile());
                return data != null ? data : DTRTBundleIcon.TASK_FLOW;
            }
        };
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.activityId == null ? 0 : this.activityId.hashCode());
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        result = 31 * result + (this.taskFlowId == null ? 0 : this.taskFlowId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        TaskFlowActivityBoundSource other = (TaskFlowActivityBoundSource)((Object)obj);
        return DTRTUtil.equals((Object)this.file, (Object)other.file) && DTRTUtil.equals((Object)this.taskFlowId, (Object)other.taskFlowId) && DTRTUtil.equals((Object)this.activityId, (Object)other.activityId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaskFlowBoundSource [file=").append(this.file).append(", taskFlowId=").append(this.taskFlowId).append(", activityId=").append(this.activityId).append("]");
        return builder.toString();
    }

    public Map<Node, List<? extends IBindingObject>> collectUsedBindingObjects(IPageDefinition pageDefinition, Node node) {
        return this.collectUsedBindingObjects(pageDefinition, node, false);
    }

    public boolean usesBindingObjects(IPageDefinition pageDefinition, Node node) {
        return !this.collectUsedBindingObjects(pageDefinition, node, true).isEmpty();
    }

    private Map<Node, List<? extends IBindingObject>> collectUsedBindingObjects(IPageDefinition pageDefinition, Node node, boolean stopIfMapIsNotEmpty) {
        Document document;
        Element activityElement;
        if (pageDefinition != null && node != null && (activityElement = this.findActivityElement(document = node instanceof Document ? (Document)node : node.getOwnerDocument())) != null) {
            Element startingNode;
            Node node2 = DTRTvCommonUtil.isSameOrParent(node, activityElement) ? activityElement : (startingNode = DTRTvCommonUtil.isSameOrParent(activityElement, node) ? node : null);
            if (startingNode != null) {
                HashMap<Node, List<IBindingObject>> map = new HashMap<Node, List<IBindingObject>>(1);
                this.collectUsedBindingObjects(map, pageDefinition, activityElement, startingNode, stopIfMapIsNotEmpty);
                if (!map.isEmpty()) {
                    return Collections.unmodifiableMap(map);
                }
            }
        }
        return Collections.emptyMap();
    }

    private void collectUsedBindingObjects(Map<Node, List<IBindingObject>> map, IPageDefinition pageDefinition, Element activityElement, Node node, boolean stopIfMapIsNotEmpty) {
        List bindingObjects = DTRTObjectUtil.findBindingObjects((IPageDefinition)pageDefinition, (Node)node);
        BoundSourceUtil.putBindings(map, activityElement, bindingObjects);
        if (stopIfMapIsNotEmpty && !map.isEmpty()) {
            return;
        }
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node child = childNodes.item(i);
            this.collectUsedBindingObjects(map, pageDefinition, activityElement, child, stopIfMapIsNotEmpty);
            if (stopIfMapIsNotEmpty && !map.isEmpty()) {
                return;
            }
            ++i;
        }
    }

    private Element findActivityElement(Document document) {
        Element activitiesParentElement = this.getActivitiesParentElement(document.getDocumentElement());
        if (activitiesParentElement != null) {
            NodeList childNodes = activitiesParentElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element element;
                Node child = childNodes.item(i);
                if (child instanceof Element && this.activityId.equals(this.getId(element = (Element)child))) {
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    private Element getActivitiesParentElement(Element documentElement) {
        if (TaskFlowActivityBoundSource.isValid(documentElement)) {
            if (this.taskFlowId == null) {
                return documentElement;
            }
            NodeList childNodes = documentElement.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Element element;
                Node child = childNodes.item(i);
                if (child instanceof Element && "task-flow-definition".equals((element = (Element)child).getLocalName()) && this.taskFlowId.equals(this.getId(element))) {
                    return element;
                }
                ++i;
            }
        }
        return null;
    }

    private String getId(Element parent) {
        Attr idAttribute = parent.getAttributeNode("id");
        return idAttribute != null ? idAttribute.getValue() : null;
    }
}

