/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IELMetadata;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IELMetadataPackage;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;

public final class DynamicMetadata
implements IELMetadata {
    private IELMetadataPackage metadataPackage;
    private short staticMetadataId;
    private IPropertyProvider[] propertyProviders;
    private String type;
    private List<AbstractProperty> properties;
    private int[] propertyLocator;

    public DynamicMetadata(IELMetadataPackage metadataPackage, short staticMetadataId, IPropertyProvider propertyProvider) {
        this(metadataPackage, staticMetadataId, new IPropertyProvider[]{propertyProvider});
    }

    private DynamicMetadata(IELMetadataPackage metadataPackage, short staticMetadataId, IPropertyProvider[] propertyProviders) {
        assert (metadataPackage != null);
        assert (staticMetadataId >= 0);
        assert (propertyProviders != null && propertyProviders.length > 0);
        this.metadataPackage = metadataPackage;
        this.staticMetadataId = staticMetadataId;
        this.propertyProviders = propertyProviders;
    }

    public String getType() {
        if (this.type == null && this.metadataPackage != null) {
            this.type = this.metadataPackage.getStaticMetadata(this.staticMetadataId, true).getType();
        }
        return this.type;
    }

    public IELProperty getProperty(String propertyId) {
        return ELUtil.getProperty(this.getPropertyProviders(), propertyId);
    }

    private int[] getPropertyLocator() {
        return this.propertyLocator == null ? (this.propertyLocator = ELUtil.computePropertyLocator(this.getPropertyProviders())) : this.propertyLocator;
    }

    private IPropertyProvider[] getPropertyProviders() {
        if (this.metadataPackage != null) {
            this.propertyProviders = ELUtil.appendIfNecessary(this.propertyProviders, this.metadataPackage.getStaticMetadata(this.staticMetadataId, true));
            this.getType();
            this.metadataPackage = null;
        }
        return this.propertyProviders;
    }

    public final List<? extends IELProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new AbstractList<AbstractProperty>(){

                @Override
                public int size() {
                    return DynamicMetadata.this.getPropertyLocator().length;
                }

                @Override
                public AbstractProperty get(int index) {
                    return DynamicMetadata.this.getProperty(index);
                }
            };
        }
        return this.properties;
    }

    private AbstractProperty getProperty(int index) {
        return ELUtil.getProperty(this.getPropertyProviders(), this.getPropertyLocator(), index);
    }

    public final <T extends IELProperty> List<? extends T> getProperties(final Class<T> type) {
        if (type != null) {
            AbstractList properties = new AbstractList<T>(){

                @Override
                public int size() {
                    return DynamicMetadata.this.getPropertyCount(type);
                }

                @Override
                public T get(int index) {
                    return (IELProperty)type.cast((Object)DynamicMetadata.this.getProperty(DynamicMetadata.this.getIndex(type, index)));
                }
            };
            return properties;
        }
        return Collections.emptyList();
    }

    private final int getIndex(Class<? extends IELProperty> type, int typeIndex) {
        return ELUtil.computeIndex(this.getPropertyProviders(), this.getPropertyLocator(), type, typeIndex);
    }

    private final int getPropertyCount(Class<? extends IELProperty> type) {
        return ELUtil.computePropertyCount(this.getPropertyProviders(), this.getPropertyLocator(), type);
    }

    public String toString() {
        return "DynamicMetadata [staticMetadataId=" + this.staticMetadataId + "]";
    }
}

