/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.AbstractProperty;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELMetadataPackageGenerator;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELUtil;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.IPropertyProvider;

public class BasicPropertyProvider
implements IPropertyProvider {
    private AbstractProperty[] properties;

    protected BasicPropertyProvider() {
    }

    public BasicPropertyProvider(List<? extends AbstractProperty> list) {
        list = new ArrayList<AbstractProperty>(list);
        Collections.sort(list, ELMetadataPackageGenerator.PROPERTIES_COMPARATOR);
        this.properties = list.toArray(new AbstractProperty[list.size()]);
    }

    @Override
    public final int getPropertyCount() {
        return this.getProperties().length;
    }

    @Override
    public final IELProperty getProperty(String propertyId) {
        if (propertyId != null) {
            AbstractProperty[] abstractPropertyArray = this.getProperties();
            int n = abstractPropertyArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractProperty property = abstractPropertyArray[n2];
                if (propertyId.equals(property.getId())) {
                    return property;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public final String[] getPropertyIds() {
        String[] propertyIds = new String[this.getProperties().length];
        int i = 0;
        while (i < this.getProperties().length) {
            propertyIds[i] = this.getProperties()[i].getId();
            ++i;
        }
        return propertyIds;
    }

    @Override
    public final AbstractProperty getProperty(int index) {
        return this.getProperties()[index];
    }

    private AbstractProperty[] getProperties() {
        if (this.properties == null) {
            List<AbstractProperty> list = this.computeProperties();
            Collections.sort(list, ELMetadataPackageGenerator.PROPERTIES_COMPARATOR);
            this.properties = list.toArray(new AbstractProperty[list.size()]);
        }
        return this.properties;
    }

    protected List<AbstractProperty> computeProperties() {
        return null;
    }

    @Override
    public int getIndex(Class<? extends IELProperty> type, int typeIndex) {
        return ELUtil.computeIndex(this, type, typeIndex);
    }

    @Override
    public int getPropertyCount(Class<? extends IELProperty> type) {
        return ELUtil.computePropertyCount(this, type);
    }

    @Override
    public Class<? extends IELProperty> getType(int index) {
        return ELUtil.computeType(this, index);
    }
}

