/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el;

import java.util.List;
import oracle.eclipse.tools.adf.dtrt.object.IELField;
import oracle.eclipse.tools.adf.dtrt.object.IELMethod;
import oracle.eclipse.tools.adf.dtrt.object.IELProperty;
import oracle.eclipse.tools.adf.dtrt.object.IELType;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescribable;
import oracle.eclipse.tools.adf.dtrt.util.BaseDescriptor;
import oracle.eclipse.tools.adf.dtrt.util.DTRTUtil;
import oracle.eclipse.tools.adf.dtrt.util.ImageManager;
import oracle.eclipse.tools.adf.dtrt.vcommon.bindingobject.el.ELType;
import oracle.eclipse.tools.adf.dtrt.vcommon.util.DTRTvCommonBundleIcon;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractProperty
extends BaseDescribable
implements IELProperty {
    private static final ImageManager.IImageData FIELD_IMAGE_DATA = DTRTvCommonBundleIcon.ATTRIBUTE_SM;
    private static final ImageManager.IImageData METHOD_IMAGE_DATA = DTRTvCommonBundleIcon.PUBLIC_METHOD;

    protected static ImageManager.IImageData getImageData(AbstractProperty property) {
        return property instanceof IELField ? FIELD_IMAGE_DATA : (property instanceof IELMethod ? METHOD_IMAGE_DATA : null);
    }

    protected BaseDescriptor createDescriptor() {
        return new BaseDescriptor(){

            public String getLabel() {
                return AbstractProperty.this.getId();
            }

            public String getToolTipText() {
                return DTRTUtil.adjustTooltipText((String)AbstractProperty.this.getDescription());
            }

            public ImageManager.IImageData getImageData() {
                return AbstractProperty.this.getImageData();
            }
        };
    }

    public String getDescription() {
        StringBuilder sb;
        if (this instanceof IELField) {
            String stringType = this.getELType().isCollection() ? NLS.bind((String)Messages.collectionType, (Object)this.getELType().getType(), (Object)this.getELType().getElementType()) : NLS.bind((String)Messages.type, (Object)this.getELType().getType());
            sb = new StringBuilder(stringType);
        } else if (this instanceof IELMethod) {
            sb = new StringBuilder();
            List parameterTypes = ((IELMethod)this).getParameterELTypes();
            if (parameterTypes.isEmpty()) {
                sb.append(Messages.noParameters);
            } else {
                sb.append(Messages.parameterTypes);
                for (IELType type : parameterTypes) {
                    String stringType = type.isCollection() ? NLS.bind((String)Messages.collectionParameterType, (Object)type.getType(), (Object)type.getElementType()) : NLS.bind((String)Messages.parameterType, (Object)type.getType());
                    sb.append(stringType);
                }
            }
            String stringType = this.getELType().isCollection() ? NLS.bind((String)Messages.collectionReturnType, (Object)this.getELType().getType(), (Object)this.getELType().getElementType()) : NLS.bind((String)Messages.returnType, (Object)this.getELType().getType());
            sb.append('\n').append(stringType);
        } else {
            return null;
        }
        String toolTipTextDescription = this.getToolTipTextDescription();
        if (toolTipTextDescription != null) {
            sb.append('\n').append(toolTipTextDescription);
        }
        return sb.toString();
    }

    public final String getToolTipText() {
        return null;
    }

    public IELType getELType() {
        return ELType.STRING;
    }

    protected abstract ImageManager.IImageData getImageData();

    protected String getToolTipTextDescription() {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        AbstractProperty other = (AbstractProperty)((Object)obj);
        return DTRTUtil.equals((Object)this.getId(), (Object)other.getId());
    }

    static class Messages
    extends NLS {
        public static String type;
        public static String collectionType;
        public static String parameterTypes;
        public static String parameterType;
        public static String collectionParameterType;
        public static String noParameters;
        public static String returnType;
        public static String collectionReturnType;

        static {
            NLS.initializeMessages((String)AbstractProperty.class.getName(), Messages.class);
        }

        Messages() {
        }
    }
}

