/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.property;

import java.io.IOException;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.properties.IWebLogicServerModel;
import oracle.eclipse.tools.weblogic.server.properties.WebLogicServerModelResource;
import oracle.eclipse.tools.weblogic.ui.credential.KeystoreDialog;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.server.core.IRuntime;

public final class TestConnectionElementFactory
extends FormComponentPart {
    public FormComponentPresentation createPresentation(SwtPresentation parent, final Composite composite) {
        return new FormComponentPresentation(this, parent, composite){

            public void render() {
                GridData gd = new GridData();
                gd.horizontalIndent = 8;
                composite.setLayoutData((Object)gd);
                Composite parent = new Composite(composite, 0);
                parent.setLayout((Layout)new GridLayout(1, true));
                Button btn = new Button(parent, 8);
                btn.setText("Test Connect&ion");
                btn.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        this.testConnection();
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Hyperlink credentailPrefLink = new Hyperlink(parent, 0);
                credentailPrefLink.setForeground(new Color((Device)Display.getDefault(), 0, 0, 255));
                credentailPrefLink.setText("Configure HTTPS client trust store...");
                credentailPrefLink.setUnderlined(true);
                credentailPrefLink.setVisible(true);
                credentailPrefLink.addHyperlinkListener(new IHyperlinkListener(){

                    public void linkExited(HyperlinkEvent e) {
                    }

                    public void linkEntered(HyperlinkEvent e) {
                    }

                    public void linkActivated(HyperlinkEvent e) {
                        IWebLogicServerModel props = (IWebLogicServerModel)TestConnectionElementFactory.this.getModelElement();
                        WebLogicServerModelResource res = (WebLogicServerModelResource)props.resource();
                        IRuntime runtime = res.getServerWorkingCopy().getRuntime();
                        IPath path = runtime.getLocation();
                        IPath p = path.append("/server/lib/DemoTrust.jks");
                        String passwd = "DemoTrustKeyStorePassPhrase";
                        try {
                            KeystoreResource kres = new KeystoreResource(p.toOSString(), passwd);
                            IStatus ret = kres.refresh();
                            if (!ret.isOK()) {
                                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"", (IStatus)ret);
                                return;
                            }
                            IKeystore ks = (IKeystore)IKeystore.TYPE.instantiate((Resource)kres);
                            KeystoreDialog dlg = new KeystoreDialog(Display.getDefault().getActiveShell(), (Element)ks);
                            dlg.open();
                            ks.dispose();
                        }
                        catch (Exception e1) {
                            IStatus sts = WlsUiPlugin.createErrorStatus(e1);
                            ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error open keystore", (IStatus)sts);
                        }
                    }
                });
            }

            private void testConnection() {
                IWebLogicServerModel props = (IWebLogicServerModel)TestConnectionElementFactory.this.getModelElement();
                WebLogicServerModelResource res = (WebLogicServerModelResource)props.resource();
                try {
                    String protocol;
                    IRuntime runtime = res.getServerWorkingCopy().getRuntime();
                    String hostName = (String)props.getRemoteHost().content();
                    boolean isUseSSL = (Boolean)props.isUseSSLPort().content();
                    boolean isTunneling = (Boolean)props.isUseTunneling().content();
                    String string = protocol = isUseSSL ? "t3s" : "t3";
                    if (isTunneling) {
                        protocol = isUseSSL ? "https" : "http";
                    }
                    String httpsPort = (String)props.getHttpsPort().content();
                    String httpPort = ((Integer)props.getPort().content()).toString();
                    String port = isUseSSL ? httpsPort : httpPort;
                    String userName = (String)props.getUserName().content();
                    String passWord = (String)props.getPassword().content();
                    IJ2EEDeploymentHelper helper = this.createPublisher(runtime, hostName, port, userName, passWord, protocol);
                    IWlsJMXHelper wlsJMXHelper = helper.getWlsJMXHelper();
                    wlsJMXHelper.createConnector();
                    String domainVersion = wlsJMXHelper.getDomainAttribute("DomainVersion");
                    String rtVersion = runtime.getRuntimeType().getVersion();
                    if (domainVersion != null && !domainVersion.contains(rtVersion)) {
                        IStatus sts = CorePlugin.createErrorStatus((String)"The domain version does not match the running server.", (Throwable)new Exception("Server version mismatch"));
                        ErrorDialog dialog = new ErrorDialog(this.shell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, sts, 6);
                        dialog.open();
                        return;
                    }
                }
                catch (IOException ioe) {
                    IStatus sts = CorePlugin.createErrorStatus((String)Resources.testConnectionFailedMessage, (Throwable)ioe.getCause());
                    ErrorDialog dialog = new ErrorDialog(this.shell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, sts, 6);
                    dialog.open();
                    return;
                }
                catch (Exception e) {
                    IStatus sts = CorePlugin.createErrorStatus((String)Resources.testConnectionFailedMessage, (Throwable)e);
                    MultiStatus msts = CorePlugin.createMultiStatus((String)Resources.errorDialogTitle, (IStatus[])new IStatus[]{sts});
                    ErrorDialog dialog = new ErrorDialog(this.shell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, (IStatus)msts, 6);
                    dialog.open();
                    return;
                }
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Resources.successMsg, (String)Resources.testSucceeded);
            }

            private IJ2EEDeploymentHelper createPublisher(IRuntime runtime, String hostName, String port, String userName, String passWord, String protocol) {
                IJ2EEDeploymentHelper h;
                block6: {
                    IWlsDeployRuntime wlsDeployRuntime;
                    block5: {
                        h = null;
                        wlsDeployRuntime = WlsDeployRuntimeFactory.create((IRuntime)runtime);
                        if (wlsDeployRuntime != null) break block5;
                        CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus((String)("Cannot load DeploymentManager for " + runtime.toString())));
                        return null;
                    }
                    boolean debugClassLoader = false;
                    if (debugClassLoader) {
                        ClassLoader pluginClassLoader = Thread.currentThread().getContextClassLoader();
                        System.out.println(pluginClassLoader);
                        ClassLoader wlsJarLoader = wlsDeployRuntime.getClass().getClassLoader();
                        System.out.println(wlsJarLoader);
                    }
                    if ((h = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null) break block6;
                    CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus((String)("Cannot load DeploymentManager for " + runtime.toString())));
                    return null;
                }
                try {
                    String trustStore = runtime.getLocation().append("/server/lib/DemoTrust.jks").toPortableString();
                    h.initialize(hostName, port, userName, passWord, protocol, trustStore);
                }
                catch (Throwable e) {
                    CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus((String)("Cannot load DeploymentManager for " + runtime.toString()), (Throwable)e));
                }
                return h;
            }
        };
    }

    private static final class Resources
    extends NLS {
        public static String errorDialogTitle;
        public static String testConnectionFailedMessage;
        public static String successMsg;
        public static String testSucceeded;

        static {
            Resources.initializeMessages((String)TestConnectionElementFactory.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

