/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.cnf.mbean;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.weblogic.MBeanUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.server.core.IServer;

public class MBeanNode
implements IPropertySource2 {
    private MBeanNode parent;
    private IServer server;
    private String name;
    private String path;
    private Map<String, String> attributes;
    private boolean isChildMBeanListInitialized = false;
    private static final String DESC_KEY = "com.bea.description";
    private static final String MBEAN_DESC_ID = "MBeanDescription";
    private static final String PATH_ID = "Path";
    private static final String MBEAN_INFO_CATEGORY = "MBean Info";

    public MBeanNode(IServer server, String name, MBeanNode parent) {
        this.server = server;
        this.name = name;
        this.parent = parent;
        this.path = parent == null ? null : (parent.path != null ? (parent.path.indexOf(47) < 0 ? String.valueOf(parent.path) + ":/" + name : String.valueOf(parent.path) + "/" + name) : name);
    }

    public boolean isChildMBeanListInitialized() {
        return this.isChildMBeanListInitialized;
    }

    public MBeanNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public IServer getServer() {
        return this.server;
    }

    public String getPath() {
        return this.path;
    }

    public MBeanNode[] getChildren() {
        final ArrayList ret = new ArrayList();
        final WeblogicServer weblogic = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
        try {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask("Retrieving MBean information from WebLogic server", 100);
                    monitor.worked(10);
                    List children = MBeanUtil.getChildMBeanNames((WeblogicServer)weblogic, (String)MBeanNode.this.path);
                    monitor.worked(30);
                    for (String s : children) {
                        ret.add(new MBeanNode(MBeanNode.this.server, s, MBeanNode.this));
                    }
                }
            };
            Shell shell = Display.getDefault().getActiveShell();
            if (shell != null) {
                new ProgressMonitorDialog(shell).run(true, false, op);
            }
        }
        catch (Exception exception) {}
        this.isChildMBeanListInitialized = true;
        return ret.toArray(new MBeanNode[ret.size()]);
    }

    public Map<String, String> getMBeanAttributes() {
        if (this.attributes == null) {
            WeblogicServer weblogic = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
            this.attributes = MBeanUtil.getMBeanAttributes((WeblogicServer)weblogic, (String)this.path);
        }
        return this.attributes;
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        this.getMBeanAttributes();
        return this.attributes.get(id) != null;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.path == null) {
            return new IPropertyDescriptor[0];
        }
        this.getMBeanAttributes();
        IPropertyDescriptor[] ret = new IPropertyDescriptor[this.attributes.size() + 2];
        TextPropertyDescriptor desc = new TextPropertyDescriptor((Object)PATH_ID, PATH_ID);
        desc.setCategory(MBEAN_INFO_CATEGORY);
        ret[0] = desc;
        desc = new TextPropertyDescriptor((Object)MBEAN_DESC_ID, "Description");
        desc.setCategory(MBEAN_INFO_CATEGORY);
        ret[1] = desc;
        int i = 2;
        for (String attrName : this.attributes.keySet()) {
            desc = new TextPropertyDescriptor((Object)attrName, attrName);
            desc.setCategory("Attributes");
            ret[i] = desc;
            ++i;
        }
        return ret;
    }

    public Object getPropertyValue(Object id) {
        if (id.equals(PATH_ID)) {
            return this.path;
        }
        if (id.equals(MBEAN_DESC_ID)) {
            WeblogicServer weblogic = (WeblogicServer)this.server.getAdapter(WeblogicServer.class);
            Map theHelp = MBeanUtil.getMBeanDescription((WeblogicServer)weblogic, (String)this.getPath());
            String desc = (String)theHelp.get(DESC_KEY);
            if (desc != null) {
                desc = desc.replace("<p>", "");
                desc = desc.replace("</p>", "");
            }
            return desc;
        }
        this.getMBeanAttributes();
        return this.attributes.get(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    public String toString() {
        return String.valueOf(this.name) + " " + this.path;
    }
}

