/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.cnf;

import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModule;
import oracle.eclipse.tools.weblogic.server.modules.PublishedModuleTarget;
import oracle.eclipse.tools.weblogic.server.modules.SharedLibraryRoot;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.HideAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IServer;

public abstract class WeblogicCommonActionProvider
extends CommonActionProvider {
    protected Action refreshAction;
    protected HideAction hideAction;

    public void init(ICommonActionExtensionSite aSite) {
        StructuredViewer v;
        super.init(aSite);
        ICommonViewerSite site = aSite.getViewSite();
        if (site instanceof ICommonViewerWorkbenchSite && (v = aSite.getStructuredViewer()) instanceof CommonViewer) {
            CommonViewer cv = (CommonViewer)v;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            this.makeActions(cv, wsSite.getSelectionProvider());
        }
    }

    private void makeActions(CommonViewer cv, ISelectionProvider selectionProvider) {
        this.refreshAction = new RefreshAction();
        this.refreshAction.setId("refreshAction");
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.removeAll();
        ICommonViewerSite site = this.getActionSite().getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            IServer server;
            TreePath path;
            int n;
            TreeSelection ts;
            TreePath[] paths;
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
            if (!(selection.getFirstElement() instanceof PublishedModule)) {
                menu.add((IAction)this.refreshAction);
            }
            if (selection instanceof TreeSelection && (paths = (ts = (TreeSelection)selection).getPaths()).length > 0 && (n = (path = paths[0]).getSegmentCount()) == 2 && path.getFirstSegment() instanceof IServer && (server = (IServer)path.getFirstSegment()).getAdapter(WeblogicServer.class) != null) {
                this.hideAction = new HideAction(this.getActionSite(), this.getExtensionId());
                this.hideAction.setId("hideAction");
                menu.add((IAction)this.hideAction);
            }
            menu.add((IContributionItem)new Separator());
        }
    }

    protected void refresh(Object selection) {
    }

    protected abstract String getExtensionId();

    class RefreshAction
    extends Action {
        public RefreshAction() {
            this.setActionDefinitionId(ActionFactory.REFRESH.getCommandId());
            this.setText(Resources.refresh);
            this.setImageDescriptor(WlsUiPlugin.IMG_DESC_REFRESH);
        }

        public void runWithEvent(Event event) {
            ICommonViewerSite site = WeblogicCommonActionProvider.this.getActionSite().getViewSite();
            if (site instanceof ICommonViewerWorkbenchSite) {
                ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
                ISelection sel = wsSite.getSelectionProvider().getSelection();
                if (sel instanceof TreeSelection) {
                    TreeSelection ts = (TreeSelection)sel;
                    Object obj = ts.getFirstElement();
                    if (obj instanceof SharedLibraryRoot) {
                        SharedLibraryRoot shardLibRoot = (SharedLibraryRoot)obj;
                        shardLibRoot.getParent().refresh();
                    }
                    if (obj instanceof PublishedModuleTarget) {
                        WeblogicCommonActionProvider.this.refresh(obj);
                    }
                    CommonViewer view = (CommonViewer)WeblogicCommonActionProvider.this.getActionSite().getStructuredViewer();
                    Object[] expanded = view.getExpandedElements();
                    view.refresh(obj);
                    view.setExpandedElements(expanded);
                }
                super.run();
            }
        }

        public void run() {
            this.runWithEvent(null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String refresh;

        static {
            Resources.initializeMessages((String)WeblogicCommonActionProvider.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

