/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.actions;

import java.io.File;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.actions.ServerActionBase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenStartupScriptAction
extends ServerActionBase {
    public void run(IAction action) {
        String strServerLocation = this.weblogic.getDomainPath().toOSString();
        String startupScriptName = String.valueOf(strServerLocation) + "/" + "startWebLogic" + "." + CorePlugin.getScriptExtension();
        if (!new File(startupScriptName).exists()) {
            return;
        }
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Servers");
        try {
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            Path location = new Path(startupScriptName);
            IFile file = project.getFile(String.valueOf(this.weblogic.getServerInfo().getDomainName()) + "." + location.lastSegment());
            if (!file.exists()) {
                file.createLink((IPath)location, 0, null);
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (String)"org.eclipse.ui.DefaultTextEditor");
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        action.setActionDefinitionId("oracle.eclipse.tools.weblogic.ui.server.internal.action.openStartupScript");
        super.selectionChanged(action, selection);
        if (this.weblogic != null && this.weblogic.isRemote()) {
            action.setEnabled(false);
        }
    }
}

