/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal.actions;

import java.net.MalformedURLException;
import java.net.URL;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.ui.server.internal.Resources;
import oracle.eclipse.tools.weblogic.ui.server.internal.actions.ServerActionBase;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;

public class OpenAdminConsoleAction
extends ServerActionBase {
    public void run(IAction action) {
        IWorkbenchBrowserSupport support = WorkbenchBrowserSupport.getInstance();
        try {
            String pageName = String.valueOf(Resources.getString("editorPage.adminBrowserTitle", new Object[0])) + " [" + this.getDomainName() + "]";
            IWebBrowser browser = support.createBrowser(6, "wl-console-browser-id" + this.weblogic.getServer().getId(), pageName, null);
            browser.openURL(this.getConsoleURL());
        }
        catch (PartInitException pie) {
            String msgError = Resources.getString("error", new Object[0]);
            String msgFailed = Resources.getString("editorPage.errorOpenBrowser", new Object[0]);
            ErrorDialog dialog = new ErrorDialog(Display.getDefault().getActiveShell(), msgError, msgFailed, pie.getStatus(), 6);
            dialog.open();
        }
    }

    private URL getConsoleURL() {
        WeblogicServer weblogic = this.weblogic;
        if (weblogic == null) {
            return null;
        }
        ServerInfo info = weblogic.getServerInfo();
        if (info == null) {
            return null;
        }
        try {
            String protocol = weblogic.isUseSSLPort() ? "https" : "http";
            return new URL(protocol, info.getHostName(), weblogic.getPort(), "/console");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        action.setActionDefinitionId("oracle.eclipse.tools.weblogic.ui.server.internal.action.openAdminConsole");
        super.selectionChanged(action, selection);
        if (this.weblogic != null && this.weblogic.getServer().getServerState() != 2) {
            action.setEnabled(false);
        }
    }
}

