/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.server.IWlsAdapterListener;
import oracle.eclipse.tools.weblogic.server.IWlsRunnable;
import oracle.eclipse.tools.weblogic.server.IWlsRunnableWithProgress;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerBehaviour;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.PublishWarningDialog;
import oracle.eclipse.tools.weblogic.ui.server.internal.Resources;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.sapphire.ImageData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.eclipse.wst.common.project.facet.ui.internal.FacetUiPlugin;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

public class WlsAdapter
implements IWlsAdapterListener {
    private static final String ERROR_LOG_VIEW_ID = "org.eclipse.pde.runtime.LogView";
    private static final String ID_DEBUG_PERSPECTIVE = "org.eclipse.debug.ui.DebugPerspective";
    private static final String ID_WLS_CONSOLE = "WebLogic Server Command Line Console";
    private static final String PREF_KEY_DONNOT_WARN_JSF20_WORKAROUND = "PREF_KEY_DONNOT_WARN_JSF20_WORKAROUND";
    private static Map<WeblogicServerBehaviour, WlsWorkbenchListener> listenerMap = new HashMap<WeblogicServerBehaviour, WlsWorkbenchListener>();
    private Map<String, IRuntimeComponent> RT_COMP_MAP = new HashMap<String, IRuntimeComponent>();
    private static final Map<Object, ImageData> images = new HashMap<Object, ImageData>();
    private static final String IMAGES_EXTENSION_ID = "images";
    private static final String EL_IMAGE = "image";
    private static final String ATTR_RUNTIME_COMPONENT_TYPE = "runtime-component-type";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_PATH = "path";

    public void publishStarted(WeblogicServerBehaviour behaviour, IProgressMonitor monitor) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ServerUIPlugin.saveEditors();
            }
        });
        boolean needWorkAroundForJSF20 = WebLogicServerUtil.needWorkAroundForJSF20((IServer)behaviour.getServer());
        boolean donNotDisplayMessage = WlsUiPlugin.getInstance().getPreferenceStore().getBoolean(PREF_KEY_DONNOT_WARN_JSF20_WORKAROUND);
        if (needWorkAroundForJSF20) {
            if (!donNotDisplayMessage) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialogWithToggle toggle = MessageDialogWithToggle.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)Resources.getString("warning", new Object[0]), (String)Resources.getString("jsf20NotSupportedInSplitSource", new Object[0]), (String)Resources.getString("dontDisplayJSF20Warning", new Object[0]), (boolean)false, (IPreferenceStore)WlsUiPlugin.getInstance().getPreferenceStore(), (String)WlsAdapter.PREF_KEY_DONNOT_WARN_JSF20_WORKAROUND);
                        boolean val = toggle.getToggleState();
                        WlsUiPlugin.getInstance().getPreferenceStore().setValue(WlsAdapter.PREF_KEY_DONNOT_WARN_JSF20_WORKAROUND, val);
                    }
                });
            }
            try {
                IServer server = behaviour.getServer();
                IServerWorkingCopy swc = server.createWorkingCopy();
                swc.setAttribute("RUN_WEB_MODULE_FROM_WORKSPACE", false);
                final IServer newServer = swc.save(true, (IProgressMonitor)new NullProgressMonitor());
                monitor.setCanceled(true);
                Job republishJob = new Job(Resources.getString("Publishing to " + server.getName(), new Object[0])){

                    public IStatus run(IProgressMonitor monitor) {
                        return newServer.publish(3, monitor);
                    }
                };
                republishJob.schedule(2000L);
            }
            catch (Exception exception) {}
        }
    }

    public void publishFinished(final WeblogicServerBehaviour behaviour, boolean launchBrowser) {
        if (launchBrowser) {
            try {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IProject proj = ServerLaunchUtils.getFirstWebModuleInServer((IServer)behaviour.getServer());
                            if (proj != null) {
                                String contextRoot = J2EEProjectUtilities.getServerContextRoot((IProject)proj);
                                WeblogicServer wls = behaviour.getWeblogicServer();
                                String protocol = wls.isUseSSLPort() ? "https" : "http";
                                String openURL = String.valueOf(protocol) + "://" + wls.getHostname() + ":" + wls.getPort() + "/" + contextRoot;
                                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                                IWebBrowser browser = browserSupport.createBrowser(6, null, null, null);
                                browser.openURL(new URL(openURL));
                            }
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            catch (Exception exception) {}
        }
        this.promptPublishWarning(behaviour);
    }

    private void promptPublishWarning(WeblogicServerBehaviour behaviour) {
        final TreeMap publishWarnings = behaviour.getPublishWarnings();
        TreeSet<Integer> publishWarningIds = new TreeSet<Integer>();
        for (Integer id : publishWarnings.keySet()) {
            publishWarningIds.add(id);
        }
        final WeblogicServer weblogicServer = behaviour.getWeblogicServer();
        final TreeSet ignorableWarnings = weblogicServer.getUserIgnoredWarnings();
        publishWarningIds.removeAll(ignorableWarnings);
        if (publishWarningIds.size() > 0) {
            UIJob job = new UIJob(""){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    PublishWarningDialog dlg = new PublishWarningDialog(shell);
                    TreeMap<Integer, String> intialSelections = new TreeMap<Integer, String>();
                    for (Map.Entry e : publishWarnings.entrySet()) {
                        Integer key = (Integer)e.getKey();
                        for (Integer i : ignorableWarnings) {
                            if (!i.equals(key)) continue;
                            intialSelections.put((Integer)e.getKey(), (String)e.getValue());
                        }
                    }
                    dlg.setInput(publishWarnings);
                    dlg.setInitialSelections(intialSelections.entrySet().toArray());
                    if (dlg.open() == 0) {
                        Set<Integer> userSelectedIds = dlg.getSelectedIds();
                        ServerWorkingCopy swc = (ServerWorkingCopy)weblogicServer.getServer().createWorkingCopy();
                        WeblogicServer wls = (WeblogicServer)swc.getWorkingCopyDelegate((IProgressMonitor)new NullProgressMonitor());
                        wls.setUserIgnoredWarnings(userSelectedIds);
                        try {
                            swc.save(true, monitor);
                        }
                        catch (CoreException coreException) {}
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    public void handleDebugAttach() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                try {
                    workbench.showPerspective(WlsAdapter.ID_DEBUG_PERSPECTIVE, workbench.getActiveWorkbenchWindow());
                }
                catch (Exception e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                }
            }
        });
    }

    public void publishFailed() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                    IWorkbenchPage page = workbenchWindow.getActivePage();
                    IViewPart view2 = page.findView(WlsAdapter.ERROR_LOG_VIEW_ID);
                    if (view2 != null) {
                        IWorkbenchSiteProgressService wsps = (IWorkbenchSiteProgressService)view2.getSite().getAdapter(IWorkbenchSiteProgressService.class);
                        wsps.warnOfContentChange();
                    } else {
                        page.showView(WlsAdapter.ERROR_LOG_VIEW_ID);
                    }
                }
                catch (Exception e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                }
            }
        });
    }

    public void captureScriptFinish() {
        if (PlatformUI.getWorkbench().isClosing()) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                String id;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IConsoleView view = (IConsoleView)page.findView(id = "org.eclipse.ui.console.ConsoleView");
                if (view != null) {
                    view.setPinned(false);
                }
            }
        });
    }

    public OutputStream newMessageOutputStream() {
        MessageConsole wlsTrace = this.findConsole(ID_WLS_CONSOLE);
        this.revealTraceConsole();
        IOConsoleOutputStream os = wlsTrace.newOutputStream();
        return os;
    }

    public OutputStream newMessageErrorStream() {
        MessageConsole wlsTrace = this.findConsole(ID_WLS_CONSOLE);
        final IOConsoleOutputStream os = wlsTrace.newOutputStream();
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                os.setColor(Display.getDefault().getSystemColor(3));
            }
        });
        return os;
    }

    public void captureScriptStart(Process proc, String[] cmd, String encoding) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            StreamsProxy streamProxy = new StreamsProxy(proc, encoding);
            MessageConsole wlsTrace = this.findConsole(ID_WLS_CONSOLE);
            final MessageConsoleStream console = wlsTrace.newMessageStream();
            if (streamProxy.getOutputStreamMonitor() != null) {
                streamProxy.getOutputStreamMonitor().addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        console.println(text);
                    }
                });
                streamProxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        console.println(text);
                    }
                });
            }
            this.revealTraceConsole();
            StringBuffer strCmdLine = new StringBuffer();
            int i = 0;
            while (i < cmd.length) {
                strCmdLine.append(String.valueOf(cmd[i]) + " ");
                ++i;
            }
            console.println(strCmdLine.toString());
        }
    }

    private void revealTraceConsole() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageConsole wasTrace = WlsAdapter.this.findConsole(WlsAdapter.ID_WLS_CONSOLE);
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                String id = "org.eclipse.ui.console.ConsoleView";
                try {
                    IConsoleView view = (IConsoleView)page.showView(id);
                    view.display((IConsole)wasTrace);
                    view.setPinned(true);
                }
                catch (PartInitException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (CoreException)((Object)e));
                }
            }
        });
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        IConsole[] cs = new IConsole[]{myConsole};
        conMan.addConsoles(cs);
        return myConsole;
    }

    public void serverStart(WeblogicServerBehaviour behaviour) {
        WlsWorkbenchListener listener = new WlsWorkbenchListener(behaviour);
        listenerMap.put(behaviour, listener);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)listener);
    }

    public void serverStop(WeblogicServerBehaviour behaviour) {
        WlsWorkbenchListener listener = listenerMap.get(behaviour);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)listener);
    }

    public void run(final IWlsRunnable runnable) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                runnable.run();
            }
        });
    }

    public void run(final IWlsRunnableWithProgress runnable) {
        final IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                runnable.run(monitor);
            }
        };
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    new ProgressMonitorDialog(Display.getDefault().getActiveShell()).run(true, false, op);
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                }
            }
        });
    }

    public String getRuntimeComponentName(IRuntimeComponent comp) {
        IRuntimeComponentLabelProvider provider = (IRuntimeComponentLabelProvider)comp.getAdapter(IRuntimeComponentLabelProvider.class);
        String name = "";
        if (provider == null) {
            StringBuffer label = new StringBuffer();
            label.append(comp.getRuntimeComponentType().getId());
            label.append(' ');
            label.append(comp.getRuntimeComponentVersion().getVersionString());
            name = label.toString();
        } else {
            name = provider.getLabel();
        }
        this.RT_COMP_MAP.put(name, comp);
        return name;
    }

    public ImageData getRuntimeComponentImage(IRuntimeComponent runtimeComponent) {
        if (images.size() == 0) {
            WlsAdapter.readImagesExtensions();
        }
        ImageData image = null;
        if (runtimeComponent != null) {
            image = images.get(runtimeComponent.getRuntimeComponentVersion());
        }
        if (image == null) {
            image = (ImageData)ImageData.readFromClassLoader(FacetUiPlugin.class, (String)"images/unknown.gif").required();
        }
        return image;
    }

    public ImageData getRuntimeComponentImage(String rtCompName) {
        IRuntimeComponent runtimeComponent = this.RT_COMP_MAP.get(rtCompName);
        return this.getRuntimeComponentImage(runtimeComponent);
    }

    private static void readImagesExtensions() {
        for (IConfigurationElement config : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.wst.common.project.facet.ui", (String)IMAGES_EXTENSION_ID))) {
            String ename = config.getName();
            if (!ename.equals(EL_IMAGE)) continue;
            String rct = config.getAttribute(ATTR_RUNTIME_COMPONENT_TYPE);
            HashSet targets = new HashSet();
            if (rct == null || !RuntimeManager.isRuntimeComponentTypeDefined((String)rct)) continue;
            IRuntimeComponentType type = RuntimeManager.getRuntimeComponentType((String)rct);
            String vexpr = config.getAttribute(ATTR_VERSION);
            if (vexpr == null) {
                targets.addAll(type.getVersions());
            } else {
                try {
                    targets.addAll(type.getVersions(vexpr));
                }
                catch (Exception e) {
                    FacetUiPlugin.log((Exception)e);
                }
            }
            String path = config.getAttribute(ATTR_PATH);
            String plugin = config.getContributor().getName();
            Bundle bundle = Platform.getBundle((String)plugin);
            URL url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            if (url == null) continue;
            ClassLoader bundleClassLoader = ((BundleWiring)bundle.adapt(BundleWiring.class)).getClassLoader();
            for (IRuntimeComponentVersion target : targets) {
                images.put(target, (ImageData)ImageData.readFromClassLoader((ClassLoader)bundleClassLoader, (String)path).optional());
            }
        }
    }

    private static class WlsWorkbenchListener
    implements IWindowListener {
        private WeblogicServerBehaviour behaviour;

        public WlsWorkbenchListener(WeblogicServerBehaviour behaviour) {
            this.behaviour = behaviour;
        }

        public void windowClosed(IWorkbenchWindow arg0) {
            boolean shutdown = this.behaviour.preShutdown();
            if (!shutdown) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            Process[] proc = new Process[1];
                            WlsWorkbenchListener.this.behaviour.runStopWeblogicScript(monitor, proc);
                            if (proc[0] != null) {
                                proc[0].waitFor();
                            }
                        }
                        catch (InterruptedException e) {
                            LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                            return;
                        }
                    }
                };
                try {
                    Shell shell = Display.getDefault().getActiveShell();
                    if (shell != null) {
                        new ProgressMonitorDialog(shell).run(true, false, op);
                    } else {
                        Process[] proc = new Process[1];
                        this.behaviour.runStopWeblogicScript((IProgressMonitor)new NullProgressMonitor(), proc);
                        if (proc[0] != null) {
                            proc[0].waitFor();
                        }
                    }
                }
                catch (InvocationTargetException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)e);
                    return;
                }
            }
        }

        public void windowOpened(IWorkbenchWindow arg0) {
        }

        public void windowDeactivated(IWorkbenchWindow arg0) {
        }

        public void windowActivated(IWorkbenchWindow arg0) {
        }
    }
}

