/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.widgets.EnhancedHyperlink;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.DomainLocatorsExtensionPoint;
import oracle.eclipse.tools.weblogic.JRFRuntimeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.credential.keystore.model.IKeystore;
import oracle.eclipse.tools.weblogic.credential.keystore.model.KeystoreResource;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IExternalProcess;
import oracle.eclipse.tools.weblogic.server.IJ2EEDeploymentHelper;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainConfigurator;
import oracle.eclipse.tools.weblogic.server.IWeblogicDomainUpgrade;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsDeployRuntime;
import oracle.eclipse.tools.weblogic.server.IWlsJMXHelper;
import oracle.eclipse.tools.weblogic.server.WlsDeployRuntimeFactory;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.server.operations.ICreateDefaultDomainOp;
import oracle.eclipse.tools.weblogic.server.operations.ICreationTemplate;
import oracle.eclipse.tools.weblogic.ui.credential.KeystoreDialog;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.BaseWizardFragment;
import oracle.eclipse.tools.weblogic.upgrade.DomainUpgradeConditionsExtensionPoint;
import oracle.eclipse.tools.weblogic.upgrade.IDomainUpgradeCondition;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.forms.swt.SapphireWizard;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class WeblogicServerWizardFragment
extends BaseWizardFragment {
    private Composite rootComposite;
    private DirectoryDialog browseDialog;
    private Hyperlink domainUpgradeHyperlink;
    private Button localButton;
    private Button remoteButton;
    private Text hostText;
    private Text portText;
    private Text httpsPortText;
    private Text userText;
    private Text passwordText;
    private Button isUseSSLPort;
    private Button isTunneling;
    private Button isUseLocalSSLPort;
    private Label domainDirLabel;
    private Text domainDirCombo;
    private Label nameLabel;
    private Text nameText;
    private Label hostLabel;
    private Label portLabel;
    private Label debugPortLabel;
    private Label userLabel;
    private Label passwordLabel;
    private Button testBtn;
    private Hyperlink credentailPrefLink;
    private IServerWorkingCopy server;
    private WeblogicServer weblogic;
    private IWeblogicDomainConfigurator configurator;
    private IWeblogicDomainUpgrade upgradeConfigurator;
    private Composite serverOptionsGroup;
    private Button disableAutoPublishButton;
    private Button startWithDebugButton;
    private StackLayout stackLayout = null;
    private Composite localConfigComposite = null;
    private Composite remoteConfigComposite = null;
    private boolean initialized;
    private boolean hasUserModifiedName = false;
    private Text debugPortText;
    private String passWord;
    private boolean showValidateProgressDlg = true;
    private static final String TASK_REFRESH_MODULES = "refresh-modules";
    public static final int AUTO_PUBLISH_ENABLE = 2;
    public static final String NEW_TEST_DOMAIN_SCRIPT = "/wlst.scripts/new_test_domain.py";

    @Override
    public void enter() {
        this.server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        IRuntime r = this.server.getRuntime();
        if (r instanceof IRuntimeWorkingCopy) {
            try {
                IRuntimeWorkingCopy rwc = (IRuntimeWorkingCopy)r;
                rwc.save(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (CoreException)e);
            }
        }
        super.enter();
        String hostname = this.server.getHost();
        if (!hostname.equals("localhost")) {
            this.localButton.setSelection(false);
            this.remoteButton.setSelection(true);
            this.selectRemoteMode();
            this.hostText.setText(hostname);
        } else {
            this.localButton.setSelection(true);
            this.remoteButton.setSelection(false);
            this.selectLocalMode();
        }
    }

    @Override
    public void createContent(Composite parent, IWizardHandle handle) {
        this.hasUserModifiedName = false;
        this.browseDialog = new DirectoryDialog(parent.getShell());
        this.rootComposite = new Composite(parent, 0);
        this.rootComposite.setLayoutData((Object)SwtUtil.gdfill());
        this.rootComposite.setLayout((Layout)SwtUtil.glayout((int)2, (int)0, (int)0));
        this.nameLabel = new Label(this.rootComposite, 0);
        this.nameLabel.setText(Resources.serverNameLabel);
        this.nameText = new Text(this.rootComposite, 2048);
        this.nameText.setLayoutData((Object)SwtUtil.gdhfill());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updateServerName();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.nameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                WeblogicServerWizardFragment.this.hasUserModifiedName = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        Label serverType = new Label(this.rootComposite, 0);
        serverType.setText(Resources.serverType);
        Composite btnGroup = new Composite(this.rootComposite, 0);
        btnGroup.setLayoutData((Object)SwtUtil.gdhfill());
        btnGroup.setLayout((Layout)new RowLayout());
        this.localButton = new Button(btnGroup, 16);
        this.localButton.setText(Resources.localServerRadioButton);
        this.localButton.setSelection(true);
        this.localButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.selectLocalMode();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.remoteButton = new Button(btnGroup, 16);
        this.remoteButton.setText(Resources.remoteServerRadioButton);
        this.remoteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.selectRemoteMode();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        Group configGroup = new Group(this.rootComposite, 0);
        configGroup.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        configGroup.setText(Resources.configurationGroupLabel);
        this.stackLayout = new StackLayout();
        configGroup.setLayout((Layout)this.stackLayout);
        this.createLocalDomainControls((Composite)configGroup);
        this.createRemoteDomainControls((Composite)configGroup);
        String hostname = this.server.getHost();
        this.stackLayout.topControl = hostname.equals("localhost") ? this.localConfigComposite : this.remoteConfigComposite;
        this.initialized = false;
        this.statusUpdated(STATUS_NOT_INIT);
    }

    @Override
    protected void drainModels() {
        if (!this.initialized) {
            this.initialized = true;
            this.weblogic.setDomainPath((IPath)Path.EMPTY);
            this.domainDirCombo.clearSelection();
            this.domainDirCombo.forceFocus();
            this.updateNameToDefault();
            if (this.server.getRuntime().validate(null).getSeverity() == 4) {
                this.updateFragment();
            }
        } else {
            if (this.weblogic.getDomainPath() != null) {
                this.domainDirCombo.setText(this.weblogic.getDomainPath().toOSString());
            } else {
                this.domainDirCombo.clearSelection();
            }
            if (!this.weblogic.isRemote()) {
                this.updateNameForDomain();
            } else {
                this.updateRemoteServer();
            }
            this.updateFragment();
        }
    }

    @Override
    protected void bindTaskModels() {
        this.server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        this.weblogic = (WeblogicServer)this.server.loadAdapter(WeblogicServer.class, null);
        IRuntime runtime = this.server.getRuntime();
        IWeblogicServerRuntime wl = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, null);
        this.configurator = wl.createSilentScriptDomainConfigurator(null);
        this.getTaskModel().putObject("domain-configurator", (Object)this.configurator);
        this.upgradeConfigurator = wl.createSilentDomainUpgrade(null);
        this.getTaskModel().putObject("domain-upgrade", (Object)this.upgradeConfigurator);
    }

    @Override
    protected void unbindTaskModels() {
        this.server = null;
        this.weblogic = null;
    }

    @Override
    protected IStatus validate() {
        return this.validateImpl();
    }

    private IStatus validateImpl() {
        IStatus status;
        if (this.weblogic == null) {
            return STATUS_NOT_INIT;
        }
        String serverName = this.nameText.getText();
        IServer[] iServerArray = ServerCore.getServers();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer s = iServerArray[n2];
            if (s.getName().equals(serverName)) {
                String msg = "Server name already existing";
                return CorePlugin.createErrorStatus((String)msg);
            }
            ++n2;
        }
        if (this.remoteButton.getSelection()) {
            String passwd1;
            status = this.weblogic.validateRemote();
            if (status != Status.OK_STATUS) {
                return status;
            }
            String msgPortErr = Resources.errorInvalidPort;
            if (!this.isValidPort(this.portText.getText())) {
                return CorePlugin.createErrorStatus((String)msgPortErr);
            }
            if ((this.isUseSSLPort.getSelection() || this.httpsPortText.getText().length() != 0) && !this.isValidPort(this.httpsPortText.getText())) {
                return CorePlugin.createErrorStatus((String)msgPortErr);
            }
            String host = this.hostText.getText();
            if (host.indexOf(58) >= 0) {
                String msg;
                if (host.charAt(0) == '[' && host.charAt(host.length() - 1) != ']') {
                    msg = Resources.errorIpV6Format;
                    return CorePlugin.createErrorStatus((String)msg);
                }
                if (host.charAt(0) != '[' && host.charAt(host.length() - 1) == ']') {
                    msg = Resources.errorIpV6Format;
                    return CorePlugin.createErrorStatus((String)msg);
                }
            }
            if ((passwd1 = this.passwordText.getText()).trim().length() == 0) {
                String msg = Resources.errorEmptyPasswd;
                return CorePlugin.createErrorStatus((String)msg);
            }
            return this.weblogic.validateRemote();
        }
        if (this.domainDirCombo.getText().length() == 0) {
            return new Status(1, "oracle.eclipse.tools.weblogic", Resources.specifyDomainPath);
        }
        status = null;
        status = this.weblogic.validateCreatable((IProgressMonitor)new NullProgressMonitor());
        return status;
    }

    @Override
    public String getTitle() {
        this.server = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        if (this.server != null) {
            String serverTypeId = this.server.getServerType().getId();
            return ServerCore.findServerType((String)serverTypeId).getName();
        }
        return "";
    }

    @Override
    public String getDescription() {
        return Resources.wizardDescription;
    }

    private void createLocalDomainControls(Composite parent) {
        this.localConfigComposite = new Composite(parent, 0);
        this.localConfigComposite.setLayoutData((Object)SwtUtil.gdhfill());
        this.localConfigComposite.setLayout((Layout)new GridLayout(3, false));
        this.domainDirLabel = new Label(this.localConfigComposite, 0);
        this.domainDirLabel.setText(Resources.domainDirLabel);
        this.domainDirCombo = new Text(this.localConfigComposite, 2048);
        this.domainDirCombo.setLayoutData((Object)SwtUtil.gdhfill());
        this.domainDirCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.validateDomainPath();
            }
        });
        this.createBrowseAndAddDomainButtons();
        this.domainUpgradeHyperlink = new EnhancedHyperlink(this.localConfigComposite, 0);
        this.domainUpgradeHyperlink.setText(Resources.domainUpgradeHyperlink);
        GridData gd = new GridData(3, 0, true, false, 3, 1);
        this.domainUpgradeHyperlink.setLayoutData((Object)gd);
        this.domainUpgradeHyperlink.setVisible(false);
        this.domainUpgradeHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.launchUpgradeConfiguration();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.serverOptionsGroup = new Composite(this.localConfigComposite, 0);
        this.serverOptionsGroup.setLayout((Layout)new GridLayout());
        this.serverOptionsGroup.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)3));
        this.disableAutoPublishButton = new Button(this.serverOptionsGroup, 32);
        this.disableAutoPublishButton.setText(Resources.disableAutoPublishCheckbox);
        this.disableAutoPublishButton.setSelection(true);
        this.disableAutoPublishButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = WeblogicServerWizardFragment.this.disableAutoPublishButton.getSelection();
                ServerWorkingCopy wc = (ServerWorkingCopy)WeblogicServerWizardFragment.this.weblogic.getServerWorkingCopy();
                if (selection) {
                    wc.setAttribute("auto-publish-setting", 1);
                } else {
                    wc.setAttribute("auto-publish-setting", 2);
                    wc.setAttribute("auto-publish-time", 15);
                }
            }
        });
        this.isUseLocalSSLPort = new Button(this.serverOptionsGroup, 32);
        this.isUseLocalSSLPort.setLayoutData((Object)SwtUtil.gd());
        this.isUseLocalSSLPort.setText(Resources.sslPort);
        this.isUseLocalSSLPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isUseSSL = WeblogicServerWizardFragment.this.isUseLocalSSLPort.getSelection();
                WeblogicServerWizardFragment.this.weblogic.setUseSSLPort(isUseSSL);
                WeblogicServerWizardFragment.this.updateFragment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.startWithDebugButton = new Button(this.serverOptionsGroup, 32);
        this.startWithDebugButton.setText(Resources.startWithDebugCheckbox);
        this.startWithDebugButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = WeblogicServerWizardFragment.this.startWithDebugButton.getSelection();
                ServerWorkingCopy wc = (ServerWorkingCopy)WeblogicServerWizardFragment.this.weblogic.getServerWorkingCopy();
                wc.setAttribute("start_with_debug", selection);
            }
        });
        this.startWithDebugButton.setToolTipText(Resources.startWithDebugDescription);
        Text desc = new Text(this.serverOptionsGroup, 10);
        desc.setText(Resources.startWithDebugDescription);
    }

    private Map<String, String> findExistingDomains() {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        IRuntime runtime = this.server.getRuntime();
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime r = RuntimeBridgeUtil.bridge((IRuntime)runtime);
        if (r != null) {
            for (File domain : DomainLocatorsExtensionPoint.locateDomains((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)r, null)) {
                File path = domain.getAbsoluteFile();
                if (ret.containsKey(path.getName())) {
                    ret.put(String.valueOf(path.getName()) + "[" + path.getAbsolutePath() + "]", path.getAbsolutePath());
                    continue;
                }
                ret.put(path.getName(), path.getAbsolutePath());
            }
        }
        return ret;
    }

    private void createBrowseAndAddDomainButtons() {
        final ToolBar toolbar = new ToolBar(this.localConfigComposite, 0x800100);
        final ToolItem browseToolItem = new ToolItem(toolbar, 8);
        browseToolItem.setImage(WlsUiPlugin.IMG_DESC_BROWSE.createImage());
        String tooltip = Resources.browse;
        browseToolItem.setToolTipText(tooltip);
        browseToolItem.setEnabled(true);
        SelectionAdapter browseToolItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Map existingDomains = WeblogicServerWizardFragment.this.findExistingDomains();
                if (existingDomains.size() == 0) {
                    WeblogicServerWizardFragment.this.popBrowse(WeblogicServerWizardFragment.this.domainDirCombo);
                    WeblogicServerWizardFragment.this.updateFragment();
                } else {
                    Menu popupMenu = new Menu((Decorations)toolbar.getShell(), 8);
                    this.fillMenu(popupMenu);
                    Rectangle rect = browseToolItem.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = browseToolItem.getParent().toDisplay(pt);
                    popupMenu.setLocation(pt);
                    popupMenu.setVisible(true);
                }
            }

            private void fillMenu(Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(Resources.browse);
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        WeblogicServerWizardFragment.this.popBrowse(WeblogicServerWizardFragment.this.domainDirCombo);
                        WeblogicServerWizardFragment.this.updateFragment();
                    }
                });
                MenuItem knowDomainMenuItem2 = new MenuItem(popupMenu, 64);
                knowDomainMenuItem2.setText(Resources.knownDomains);
                knowDomainMenuItem2.setEnabled(true);
                Menu subMenu = new Menu((Decorations)toolbar.getShell(), 4);
                Map existingDomains = WeblogicServerWizardFragment.this.findExistingDomains();
                for (Map.Entry entry : existingDomains.entrySet()) {
                    String name = (String)entry.getKey();
                    MenuItem subMenuItem = new MenuItem(subMenu, 8);
                    subMenuItem.setText(name);
                    subMenuItem.setData(entry.getValue());
                    subMenuItem.setEnabled(true);
                    subMenuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            MenuItem subMenuItem = (MenuItem)e.getSource();
                            WeblogicServerWizardFragment.this.domainDirCombo.setText(subMenuItem.getData().toString());
                        }

                        public void widgetDefaultSelected(SelectionEvent arg0) {
                        }
                    });
                }
                knowDomainMenuItem2.setMenu(subMenu);
            }
        };
        browseToolItem.addSelectionListener((SelectionListener)browseToolItemListener);
        final ToolItem newDomainToolItem = new ToolItem(toolbar, 8);
        newDomainToolItem.setImage(WlsUiPlugin.IMG_DESC_CREATE.createImage());
        tooltip = Resources.newDomain;
        newDomainToolItem.setToolTipText(tooltip);
        newDomainToolItem.setEnabled(true);
        SelectionAdapter toolItemListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Menu popupMenu = new Menu((Decorations)toolbar.getShell(), 8);
                this.fillMenu(popupMenu);
                Rectangle rect = newDomainToolItem.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = newDomainToolItem.getParent().toDisplay(pt);
                popupMenu.setLocation(pt);
                popupMenu.setVisible(true);
            }

            private void fillMenu(Menu popupMenu) {
                MenuItem menuItem = new MenuItem(popupMenu, 8);
                menuItem.setText(Resources.createDefaultDomain);
                menuItem.setEnabled(true);
                menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        WeblogicServerWizardFragment.this.createDefaultDomain();
                        WeblogicServerWizardFragment.this.updateFragment();
                    }
                });
                MenuItem menuItem2 = new MenuItem(popupMenu, 8);
                menuItem2.setText(Resources.launchCfgWzd);
                menuItem2.setEnabled(true);
                menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        WeblogicServerWizardFragment.this.domainDirCombo.setText("");
                        WeblogicServerWizardFragment.this.launchDomainConfiguration();
                        WeblogicServerWizardFragment.this.updateFragment();
                    }
                });
            }
        };
        newDomainToolItem.addSelectionListener((SelectionListener)toolItemListener);
    }

    @Override
    public void widgetDisposed(DisposeEvent e) {
        super.widgetDisposed(e);
        this.browseDialog = null;
        this.rootComposite = null;
        this.domainDirLabel = null;
        this.domainDirCombo = null;
        this.domainUpgradeHyperlink = null;
        this.startWithDebugButton = null;
        this.remoteButton = null;
        this.localButton = null;
        this.hostText = null;
        this.portText = null;
        this.httpsPortText = null;
        this.userText = null;
        this.passwordText = null;
        this.domainDirLabel = null;
        this.hostLabel = null;
        this.userLabel = null;
        this.passwordLabel = null;
        this.upgradeConfigurator = null;
        this.setComplete(false);
    }

    private void createRemoteDomainControls(Composite parent) {
        this.remoteConfigComposite = new Composite(parent, 0);
        this.remoteConfigComposite.setVisible(false);
        GridData remoteGrid = new GridData(4, 4, true, true, 1, 1);
        remoteGrid.horizontalIndent = 15;
        this.remoteConfigComposite.setLayoutData((Object)remoteGrid);
        this.remoteConfigComposite.setLayout((Layout)new GridLayout(2, false));
        this.hostLabel = new Label(this.remoteConfigComposite, 0);
        this.hostLabel.setLayoutData((Object)SwtUtil.gd());
        this.hostLabel.setText(Resources.hostNameLabel);
        this.hostText = new Text(this.remoteConfigComposite, 2048);
        this.hostText.setLayoutData((Object)SwtUtil.gdhfill());
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updateHost();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.portLabel = new Label(this.remoteConfigComposite, 0);
        this.portLabel.setLayoutData((Object)SwtUtil.gd());
        this.portLabel.setText(Resources.portLabel);
        this.portText = new Text(this.remoteConfigComposite, 2048);
        this.portText.setText("7001");
        this.portText.setLayoutData((Object)SwtUtil.gdhfill());
        this.portText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updatePort();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        Label httpsPortLabel = new Label(this.remoteConfigComposite, 0);
        httpsPortLabel.setLayoutData((Object)SwtUtil.gd());
        httpsPortLabel.setText(Resources.httpsPortLabel);
        this.httpsPortText = new Text(this.remoteConfigComposite, 2048);
        this.httpsPortText.setText("");
        this.httpsPortText.setLayoutData((Object)SwtUtil.gdhfill());
        this.httpsPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updateHttpsPort();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        Label spacer = new Label(this.remoteConfigComposite, 0);
        spacer.setLayoutData((Object)SwtUtil.gd());
        this.isUseSSLPort = new Button(this.remoteConfigComposite, 32);
        this.isUseSSLPort.setLayoutData((Object)SwtUtil.gd());
        this.isUseSSLPort.setText(Resources.sslPort);
        this.isUseSSLPort.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WeblogicServerWizardFragment.this.updateUseSSLPort();
                WeblogicServerWizardFragment.this.updateFragment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        spacer = new Label(this.remoteConfigComposite, 0);
        spacer.setLayoutData((Object)SwtUtil.gd());
        this.isTunneling = new Button(this.remoteConfigComposite, 32);
        this.isTunneling.setLayoutData((Object)SwtUtil.gd());
        this.isTunneling.setText(Resources.isTunneling);
        this.isTunneling.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WeblogicServerWizardFragment.this.updateTunneling();
                WeblogicServerWizardFragment.this.updateFragment();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.debugPortLabel = new Label(this.remoteConfigComposite, 0);
        this.debugPortLabel.setLayoutData((Object)SwtUtil.gd());
        this.debugPortLabel.setText(Resources.debugPortLabel);
        this.debugPortText = new Text(this.remoteConfigComposite, 2048);
        this.debugPortText.setText("8453");
        this.debugPortText.setLayoutData((Object)SwtUtil.gdhfill());
        this.debugPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updateDebugPort();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.userLabel = new Label(this.remoteConfigComposite, 0);
        this.userLabel.setLayoutData((Object)SwtUtil.gd());
        this.userLabel.setText(Resources.userLabel);
        this.userText = new Text(this.remoteConfigComposite, 2048);
        this.userText.setText("weblogic");
        this.userText.setLayoutData((Object)SwtUtil.gdhfill());
        this.userText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updateUser();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        this.passwordLabel = new Label(this.remoteConfigComposite, 0);
        this.passwordLabel.setLayoutData((Object)SwtUtil.gd());
        this.passwordLabel.setText(Resources.passwordLabel);
        this.passwordText = new Text(this.remoteConfigComposite, 0x400800);
        this.passwordText.setLayoutData((Object)SwtUtil.gdhfill());
        this.passwordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerWizardFragment.this.updatePassword();
                WeblogicServerWizardFragment.this.updateFragment();
            }
        });
        new Label(this.remoteConfigComposite, 0);
        this.testBtn = new Button(this.remoteConfigComposite, 8);
        this.testBtn.setText(Resources.testBtnLabel);
        this.testBtn.setEnabled(false);
        GridData gd = new GridData(0x1000008, 0x1000000, false, false);
        gd.horizontalAlignment = 128;
        this.testBtn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WeblogicServerWizardFragment.this.testConnection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(this.remoteConfigComposite, 0).setText("");
        this.credentailPrefLink = new Hyperlink(this.remoteConfigComposite, 0);
        this.credentailPrefLink.setForeground(new Color((Device)Display.getDefault(), 0, 0, 255));
        this.credentailPrefLink.setText("Configure HTTPS client trust store...");
        this.credentailPrefLink.setUnderlined(true);
        this.credentailPrefLink.setVisible(false);
        this.credentailPrefLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                IPath path = WeblogicServerWizardFragment.this.server.getRuntime().getLocation();
                IPath p = path.append("/server/lib/DemoTrust.jks");
                String passwd = "DemoTrustKeyStorePassPhrase";
                try {
                    KeystoreResource kres = new KeystoreResource(p.toOSString(), passwd);
                    IStatus ret = kres.refresh();
                    if (!ret.isOK()) {
                        ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"", (IStatus)ret);
                        return;
                    }
                    IKeystore ks = (IKeystore)IKeystore.TYPE.instantiate((Resource)kres);
                    KeystoreDialog dlg = new KeystoreDialog(Display.getDefault().getActiveShell(), (Element)ks);
                    dlg.open();
                    ks.dispose();
                }
                catch (Exception e1) {
                    IStatus sts = WlsUiPlugin.createErrorStatus(e1);
                    ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)"Error open keystore", (IStatus)sts);
                }
            }
        });
    }

    protected void testConnection() {
        try {
            String protocol;
            String hostName = this.hostText.getText();
            boolean isUseSSL = this.isUseSSLPort.getSelection();
            boolean isHttpTunneling = this.isTunneling.getSelection();
            String string = protocol = isUseSSL ? "t3s" : "t3";
            if (isHttpTunneling) {
                protocol = isUseSSL ? "https" : "http";
            }
            String port = isUseSSL ? this.httpsPortText.getText() : this.portText.getText();
            String userName = this.userText.getText();
            String passWord = this.passwordText.getText();
            IJ2EEDeploymentHelper helper = this.createPublisher(hostName, port, userName, passWord, protocol);
            IWlsJMXHelper wlsJMXHelper = helper.getWlsJMXHelper();
            wlsJMXHelper.createConnector();
            String domainVersion = wlsJMXHelper.getDomainAttribute("DomainVersion");
            String rtVersion = this.server.getRuntime().getRuntimeType().getVersion();
            if (domainVersion != null && !domainVersion.contains(rtVersion)) {
                IStatus sts = CorePlugin.createErrorStatus((String)"The domain version does not match the running server.", (Throwable)new Exception("Server version mismatch"));
                ErrorDialog dialog = new ErrorDialog(this.rootComposite.getShell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, sts, 6);
                dialog.open();
                return;
            }
        }
        catch (IOException ioe) {
            IStatus sts = CorePlugin.createErrorStatus((String)"Connection failed", (Throwable)ioe.getCause());
            ErrorDialog dialog = new ErrorDialog(this.rootComposite.getShell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, sts, 6);
            dialog.open();
            return;
        }
        catch (Exception e) {
            IStatus sts = CorePlugin.createErrorStatus((String)"Connection failed", (Throwable)e);
            ErrorDialog dialog = new ErrorDialog(this.rootComposite.getShell(), Resources.errorDialogTitle, Resources.testConnectionFailedMessage, sts, 6);
            dialog.open();
            return;
        }
        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Resources.successMsg, (String)Resources.testSucceeded);
    }

    private IJ2EEDeploymentHelper createPublisher(String hostName, String port, String userName, String passWord, String protocol) {
        IRuntime runtime;
        IJ2EEDeploymentHelper h;
        block6: {
            IWlsDeployRuntime wlsDeployRuntime;
            block5: {
                h = null;
                runtime = this.server.getRuntime();
                wlsDeployRuntime = WlsDeployRuntimeFactory.create((IRuntime)runtime);
                if (wlsDeployRuntime != null) break block5;
                CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus((String)("Cannot load DeploymentManager for " + runtime.toString())));
                return null;
            }
            boolean debugClassLoader = false;
            if (debugClassLoader) {
                ClassLoader pluginClassLoader = Thread.currentThread().getContextClassLoader();
                System.out.println(pluginClassLoader);
                ClassLoader wlsJarLoader = wlsDeployRuntime.getClass().getClassLoader();
                System.out.println(wlsJarLoader);
            }
            if ((h = wlsDeployRuntime.getJ2EEDeploymentHelper()) != null) break block6;
            CorePlugin.getLevelLog().logDebug(CorePlugin.createInfoStatus((String)("Cannot load DeploymentManager for " + runtime.toString())));
            return null;
        }
        try {
            String trustStore = runtime.getLocation().append("/server/lib/DemoTrust.jks").toPortableString();
            h.initialize(hostName, port, userName, passWord, protocol, trustStore);
        }
        catch (Throwable e) {
            CorePlugin.getLevelLog().logInfo(CorePlugin.createErrorStatus((String)("Cannot load DeploymentManager for " + runtime.toString()), (Throwable)e));
        }
        return h;
    }

    protected void updateUseSSLPort() {
        boolean isUseSSL = this.isUseSSLPort.getSelection();
        this.weblogic.setUseSSLPort(isUseSSL);
        this.credentailPrefLink.setVisible(isUseSSL);
    }

    protected void updateTunneling() {
        boolean isTunneling = this.isTunneling.getSelection();
        this.weblogic.setTunneling(isTunneling);
    }

    @Override
    protected void statusUpdated(IStatus status) {
        super.statusUpdated(status);
        this.domainUpgradeHyperlink.setVisible(false);
        if (status.isOK() || this.upgradeConfigurator == null || this.weblogic == null) {
            WizardPage page = (WizardPage)this.getWizard();
            page.setErrorMessage(null);
        } else if (status.getSeverity() == 2) {
            WizardPage page = (WizardPage)this.getWizard();
            page.setMessage(status.getMessage(), 2);
            this.setComplete(true);
            this.getWizard().update();
        } else {
            File domainLocation;
            File wlsInstallLocation = this.server.getRuntime().getLocation().toFile();
            WebLogicServerInstall wlsInstall = new WebLogicServerInstall(wlsInstallLocation);
            File file = domainLocation = this.weblogic.getDomainPath() == null ? null : this.weblogic.getDomainPath().toFile();
            if (status.getCode() != 7001) {
                return;
            }
            IDomainUpgradeCondition.Result result = DomainUpgradeConditionsExtensionPoint.checkConditions((WebLogicServerInstall)wlsInstall, (File)domainLocation);
            if (result == IDomainUpgradeCondition.Result.UPGRADE_AVAILABLE || result == IDomainUpgradeCondition.Result.UPGRADE_REQUIRED) {
                this.domainUpgradeHyperlink.setVisible(true);
                WizardPage page = (WizardPage)this.getWizard();
                page.setMessage(Resources.domainUpgradeMsg, 1);
            } else {
                this.domainUpgradeHyperlink.setVisible(false);
            }
        }
    }

    private void launchDomainConfiguration() {
        try {
            if (this.server == null) {
                throw new CoreException(WlsCorePlugin.createErrorStatus((String)"Error launching WebLogic Domain Configurator"));
            }
            IRuntime runtime = this.server.getRuntime();
            IWeblogicServerRuntime wl = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, null);
            NullProgressMonitor monitor = new NullProgressMonitor();
            IExternalProcess configWizard = wl.createDomainConfigurator((IProgressMonitor)monitor);
            configWizard.apply((IProgressMonitor)monitor);
        }
        catch (CoreException ce) {
            ErrorDialog dialog = new ErrorDialog(this.rootComposite.getShell(), Resources.errorDialogTitle, Resources.configWizardFailedMessage, ce.getStatus(), 6);
            dialog.open();
        }
    }

    private void launchUpgradeConfiguration() {
        try {
            IRuntime runtime = this.server.getRuntime();
            final IWeblogicServerRuntime wl = (IWeblogicServerRuntime)runtime.loadAdapter(IWeblogicServerRuntime.class, null);
            final String domainPath = this.domainDirCombo.getText();
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    IWeblogicDomainUpgrade configWizard = wl.createDomainUpgrade(monitor);
                    configWizard.setDomainPath((IPath)new Path(domainPath));
                    try {
                        configWizard.apply(monitor);
                    }
                    catch (CoreException ce) {
                        ErrorDialog dialog = new ErrorDialog(WeblogicServerWizardFragment.this.rootComposite.getShell(), Resources.errorDialogTitle, Resources.upgradeWizardFailedMessage, ce.getStatus(), 6);
                        dialog.open();
                    }
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            dialog.run(true, false, op);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void selectRemoteMode() {
        if (this.weblogic != null) {
            this.weblogic.setRemote(true);
        }
        ServerWorkingCopy wc = (ServerWorkingCopy)this.weblogic.getServerWorkingCopy();
        wc.setAttribute("auto-publish-setting", 1);
        String host = this.hostText.getText();
        this.server.setHost(host);
        this.weblogic.setHostname(host);
        this.stackLayout.topControl = this.remoteConfigComposite;
        this.rootComposite.layout(true, true);
        this.hostText.setFocus();
        this.updateNameToDefault();
    }

    private void selectLocalMode() {
        if (this.weblogic != null) {
            this.weblogic.setRemote(false);
        }
        this.server.setHost("localhost");
        ServerWorkingCopy wc = (ServerWorkingCopy)this.weblogic.getServerWorkingCopy();
        this.disableAutoPublishButton.setSelection(true);
        wc.setAttribute("auto-publish-setting", 1);
        this.stackLayout.topControl = this.localConfigComposite;
        this.rootComposite.layout(true, true);
        this.updateNameToDefault();
    }

    private void popBrowse(Text path) {
        IRuntime runtime;
        File userProjDir;
        File domainsDir;
        String filterPath = path.getText();
        if (filterPath.length() == 0 && (domainsDir = new File(userProjDir = new File((runtime = this.server.getRuntime()).getLocation().toFile().getParent(), "user_projects"), "domains")).exists()) {
            filterPath = domainsDir.getAbsolutePath();
        }
        this.browseDialog.setFilterPath(filterPath);
        String res = this.browseDialog.open();
        if (res != null) {
            path.setText(res);
        }
    }

    private void createDefaultDomain() {
        String domainDirText;
        String jrfTemplateName;
        File wlHome = this.server.getRuntime().getLocation().toFile();
        File mwHome = WlsRuntimeUtil.getMwHome((File)wlHome);
        String mwHomePath = mwHome.getAbsolutePath();
        try {
            mwHomePath = mwHome.getCanonicalPath();
        }
        catch (IOException iOException) {}
        String newTestDomainName = this.getNewTestDomainName(String.valueOf(mwHome.getAbsolutePath()) + "/user_projects/domains/");
        ICreateDefaultDomainOp op = (ICreateDefaultDomainOp)ICreateDefaultDomainOp.TYPE.instantiate();
        op.setName(newTestDomainName);
        op.setRuntimeid(this.server.getRuntime().getId());
        boolean isJRFInstalled = JRFRuntimeUtil.isJRFRuntimeInstalled((File)wlHome);
        if (isJRFInstalled && (jrfTemplateName = JRFRuntimeUtil.getJRFTemplateName((IRuntime)this.server.getRuntime())) != null) {
            ICreationTemplate template = (ICreationTemplate)op.getTemplates().insert();
            template.setName(jrfTemplateName);
        }
        if ((domainDirText = this.domainDirCombo.getText().trim()).length() > 0) {
            File domainDir = new File(domainDirText);
            if (!domainDir.exists()) {
                domainDir.mkdirs();
            } else if (new File(domainDir, "startWebLogic.sh").exists()) {
                domainDir = domainDir.getParentFile();
            }
            op.setLocation(new Path(domainDir.getAbsolutePath()).toOSString());
            op.setName(this.getNewTestDomainName(domainDir.getAbsolutePath()));
        } else {
            op.setLocation(new Path(String.valueOf(mwHomePath) + "/user_projects/domains/").toOSString());
        }
        SapphireWizard wizard = new SapphireWizard((Element)op, DefinitionLoader.context(((Object)((Object)this)).getClass()).sdef("CreateDefaultDomainWizard").wizard());
        WizardDialog dlg = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        if (dlg.open() == 0) {
            String domainPath = ((org.eclipse.sapphire.modeling.Path)op.getLocation().content()).toOSString();
            domainPath = String.valueOf(domainPath) + "/";
            domainPath = String.valueOf(domainPath) + (String)op.getName().content();
            this.domainDirCombo.setText(new Path(domainPath).toOSString());
        }
        op.dispose();
    }

    private String getNewTestDomainName(String path) {
        File domainsDir = new File(path);
        if (!domainsDir.exists()) {
            domainsDir.mkdirs();
            return "test1";
        }
        HashSet<String> existingNames = new HashSet<String>();
        String[] stringArray = domainsDir.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            existingNames.add(f);
            ++n2;
        }
        int n3 = 1;
        String newName;
        while (existingNames.contains(newName = "test" + n3)) {
            ++n3;
        }
        return newName;
    }

    private void updateUser() {
        this.weblogic.setUsername(this.userText.getText().trim());
    }

    private void updatePassword() {
        String passwd1 = this.passwordText.getText();
        this.weblogic.setPassword(passwd1);
    }

    private void updateHost() {
        String name;
        int n;
        String host = this.hostText.getText().trim();
        if (host.indexOf(58) >= 0 && (host.charAt(0) != '[' || host.charAt(host.length() - 1) != ']')) {
            host = "[" + host + "]";
        }
        if ((n = (name = this.server.getName()).indexOf("at ")) > 0) {
            name = name.substring(0, n + 3).trim();
        } else {
            n = name.indexOf("[");
            if (n > 0) {
                name = name.substring(0, n).trim();
            }
        }
        String serverName = String.valueOf(name) + " [" + host + "]";
        IServer[] iServerArray = ServerCore.getServers();
        int n2 = iServerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IServer s = iServerArray[n3];
            if (s.getName().equals(serverName)) {
                serverName = String.valueOf(serverName) + "-1";
            }
            ++n3;
        }
        this.server.setName(serverName);
        this.server.setHost(host);
        this.weblogic.setHostname(host);
        this.updateNameToDefault();
    }

    private void updatePort() {
        String port = this.portText.getText().trim();
        try {
            int portNum = new Integer(port);
            this.weblogic.setPort(portNum);
        }
        catch (Exception exception) {}
    }

    private void updateHttpsPort() {
        String port = this.httpsPortText.getText().trim();
        try {
            int portNum = new Integer(port);
            this.weblogic.setHttpsPort(portNum);
        }
        catch (Exception exception) {}
    }

    private void updateDebugPort() {
        String port = this.debugPortText.getText().trim();
        try {
            int portNum = new Integer(port);
            this.weblogic.setDebugPort(portNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateDomainPath() {
        try {
            Shell shell = Display.getDefault().getActiveShell();
            if (shell != null && this.showValidateProgressDlg) {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.setTaskName("Validating WebLogic domain path...");
                        WeblogicServerWizardFragment.this.validateDomainPathImpl();
                    }
                };
                new ProgressMonitorDialog(shell).run(true, false, op);
                this.showValidateProgressDlg = false;
            } else {
                this.validateDomainPathImpl();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void validateDomainPathImpl() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IPath oldPath;
                String path = WeblogicServerWizardFragment.this.domainDirCombo.getText().trim();
                Path iPath = path != null ? new Path(path) : null;
                if (!iPath.equals((Object)(oldPath = WeblogicServerWizardFragment.this.weblogic.getDomainPath()))) {
                    WeblogicServerWizardFragment.this.updateDomainPath();
                    WeblogicServerWizardFragment.this.updateFragment();
                }
            }
        });
    }

    private void updateDomainPath() {
        IPath oldPath;
        String path = this.domainDirCombo.getText().trim();
        Path iPath = path != null ? new Path(path) : null;
        if (!iPath.equals((Object)(oldPath = this.weblogic.getDomainPath()))) {
            this.weblogic.setDomainPath((IPath)iPath);
            if (this.weblogic.getServerInfo() != null && this.weblogic.getServerInfo().isListenPortDisabled()) {
                this.weblogic.setUseSSLPort(true);
                this.isUseLocalSSLPort.setSelection(true);
            } else {
                this.isUseLocalSSLPort.setSelection(false);
            }
            this.getTaskModel().putObject(TASK_REFRESH_MODULES, (Object)iPath.toOSString());
            this.updateNameForDomain();
        }
    }

    private void updateNameForDomain() {
        if (this.weblogic != null && this.weblogic.validateCreatable((IProgressMonitor)new NullProgressMonitor()).isOK()) {
            IPath path = this.weblogic.getDomainPath();
            String name = this.server.getName();
            int n = name.indexOf("[");
            if (n > 0) {
                name = name.substring(0, n).trim();
            }
            this.server.setName(String.valueOf(name) + " [" + path.lastSegment() + "]");
            this.nameText.setText(this.server.getName());
        } else {
            this.updateNameToDefault();
        }
    }

    private void updateRemoteServer() {
        if (this.weblogic != null && this.weblogic.validateRemote().isOK()) {
            this.server.setHost(this.hostText.getText().trim());
            Integer port = new Integer(this.portText.getText().trim());
            if (port != null) {
                this.weblogic.setPort(port.intValue());
            }
            this.weblogic.setUsername(this.userText.getText().trim());
            this.weblogic.setPassword(this.passwordText.getText().trim());
        }
    }

    private void updateNameToDefault() {
        if (this.hasUserModifiedName) {
            return;
        }
        ServerWorkingCopy server = (ServerWorkingCopy)this.getTaskModel().getObject("server");
        String name = server.getName();
        if (name != null && name.length() > 0) {
            this.nameText.setText(name);
        } else {
            ServerUtil.setServerDefaultName((IServerWorkingCopy)server);
            this.nameText.setText(server.getName());
        }
    }

    private void updateServerName() {
        this.server.setName(this.nameText.getText().trim());
    }

    @Override
    protected void updateFragment() {
        boolean enabled;
        super.updateFragment();
        boolean bl = enabled = this.server.getRuntime().validate(null).getSeverity() != 4;
        if (!this.remoteButton.getSelection()) {
            this.nameLabel.setEnabled(enabled);
            this.nameText.setEnabled(enabled);
            this.domainDirLabel.setEnabled(enabled);
            this.domainDirCombo.setEnabled(enabled);
            this.domainUpgradeHyperlink.setEnabled(enabled);
            this.serverOptionsGroup.setEnabled(enabled);
            SwtUtil.setEnabledOnChildren((Composite)this.serverOptionsGroup, (boolean)enabled);
            if (this.weblogic.getServerInfo() != null && this.weblogic.getServerInfo().isListenPortDisabled()) {
                this.isUseLocalSSLPort.setEnabled(false);
            }
        } else {
            boolean enableTest;
            this.hostText.setEnabled(enabled);
            this.portText.setEnabled(enabled);
            this.userText.setEnabled(enabled);
            this.passwordText.setEnabled(enabled);
            boolean bl2 = enableTest = this.userText.getText().length() > 0 && this.passwordText.getText().length() > 0 && this.hostText.getText().length() > 0;
            if (enableTest) {
                enableTest = !this.isUseSSLPort.getSelection() ? this.isValidPort(this.portText.getText()) : this.isValidPort(this.httpsPortText.getText());
            }
            this.testBtn.setEnabled(enableTest);
        }
    }

    private boolean isValidPort(String val) {
        if (val.trim().length() > 0) {
            try {
                new Integer(val).intValue();
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IServerWorkingCopy wlsServer = (IServerWorkingCopy)this.getTaskModel().getObject("server");
        final String serverId = wlsServer.getId();
        Job initWlsServerJob = new Job("Initializing WebLogic server"){

            protected IStatus run(IProgressMonitor monitor) {
                IServer server = ResourceManager.getInstance().getServer(serverId);
                if (server != null) {
                    server.loadAdapter(ServerBehaviourDelegate.class, monitor);
                }
                return Status.OK_STATUS;
            }
        };
        initWlsServerJob.schedule(500L);
    }

    private static final class Resources
    extends NLS {
        public static String debugPortLabel;
        public static String serverNameLabel;
        public static String localServerRadioButton;
        public static String remoteServerRadioButton;
        public static String configurationGroupLabel;
        public static String wizardDescription;
        public static String domainDirLabel;
        public static String domainUpgradeHyperlink;
        public static String disableAutoPublishCheckbox;
        public static String startWithDebugCheckbox;
        public static String startWithDebugDescription;
        public static String serverType;
        public static String hostNameLabel;
        public static String portLabel;
        public static String userLabel;
        public static String passwordLabel;
        public static String httpsPortLabel;
        public static String sslPort;
        public static String isTunneling;
        public static String errorDialogTitle;
        public static String configWizardFailedMessage;
        public static String upgradeWizardFailedMessage;
        public static String errorEmptyPasswd;
        public static String specifyDomainPath;
        public static String domainUpgradeMsg;
        public static String errorIpV6Format;
        public static String errorInvalidPort;
        public static String createDefaultDomain;
        public static String launchCfgWzd;
        public static String browse;
        public static String newDomain;
        public static String knownDomains;
        public static String testConnectionFailedMessage;
        public static String successMsg;
        public static String testBtnLabel;
        public static String testSucceeded;

        static {
            Resources.initializeMessages((String)WeblogicServerWizardFragment.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

