/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.util.List;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntimeWorkingCopy;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.server.internal.BaseWizardFragment;
import oracle.eclipse.tools.weblogic.ui.server.internal.Resources;
import oracle.eclipse.tools.weblogic.ui.server.internal.WebLogicServerExtensionsControl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;

public class WeblogicServerRuntimeWizardFragment
extends BaseWizardFragment {
    private static final String HELP_CONTEXT_ID = "oracle.eclipse.tools.weblogic.ui.WeblogicServerRuntimeWizard";
    private Text nameText;
    private Text wlHomeText;
    private Text javaHomeText;
    private Combo patchCombo;
    private WebLogicServerExtensionsControl extensionsControl;
    private IRuntime runtime;
    private IRuntimeWorkingCopy runtimeWC;
    private IWeblogicServerRuntime weblogic;
    private IWeblogicServerRuntimeWorkingCopy wc;
    private boolean showValidateProgressDlg = true;

    @Override
    protected void drainModels() {
        IPath javahome;
        IPath ipath = this.runtime.getLocation();
        if (ipath != null && !ipath.isEmpty()) {
            if (this.weblogic.validate().isOK()) {
                this.wlHomeText.setText(ipath.toOSString());
                this.updateFragment();
            }
        } else {
            this.wlHomeText.setText("");
        }
        this.javaHomeText.setText((javahome = this.wc.getJavaVmLocation()) == null ? "" : javahome.toOSString());
        this.updateRuntimePatchProfileList();
        this.nameText.setText(this.runtime.getName());
        this.extensionsControl.update();
        this.wlHomeText.forceFocus();
    }

    @Override
    protected void bindTaskModels() {
        this.runtime = (IRuntime)this.getTaskModel().getObject("runtime");
        this.runtimeWC = this.runtime.createWorkingCopy();
        this.weblogic = (IWeblogicServerRuntime)this.runtime.loadAdapter(IWeblogicServerRuntime.class, null);
        this.wc = (IWeblogicServerRuntimeWorkingCopy)this.runtimeWC.getAdapter(IWeblogicServerRuntimeWorkingCopy.class);
        this.getWizard().setTitle(this.runtime.getRuntimeType().getName());
        this.extensionsControl.setRuntime(this.runtime);
    }

    @Override
    public void unbindTaskModels() {
        this.runtime = null;
        this.wc = null;
        this.weblogic = null;
    }

    @Override
    protected IStatus validate() {
        final IStatus[] ret = new IStatus[1];
        if (this.showValidateProgressDlg) {
            try {
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        WeblogicServerRuntimeWizardFragment.this.showValidateProgressDlg = false;
                        monitor.setTaskName("Validating WebLogic runtime...");
                        ret[0] = WeblogicServerRuntimeWizardFragment.this.validateImpl();
                    }
                };
                Shell shell = Display.getDefault().getActiveShell();
                if (shell != null) {
                    new ProgressMonitorDialog(shell).run(true, false, op);
                } else {
                    ret[0] = this.validateImpl();
                }
            }
            catch (Exception exception) {}
            return ret[0];
        }
        return this.validateImpl();
    }

    private IStatus validateImpl() {
        if (this.weblogic == null) {
            return STATUS_NOT_INIT;
        }
        return this.weblogic.validate();
    }

    @Override
    public String getTitle() {
        return "";
    }

    @Override
    public String getDescription() {
        return Resources.getString("runtimeWizardDescription", new Object[0]);
    }

    @Override
    public void createContent(Composite parent, IWizardHandle handle) {
        try {
            this.createWeblogicHomeControl(parent);
            this.extensionsControl = new WebLogicServerExtensionsControl(parent);
            this.extensionsControl.setLayoutData(SwtUtil.gdfill());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, HELP_CONTEXT_ID);
        }
        catch (Exception e) {
            WlsUiPlugin.log(e);
        }
    }

    @Override
    public void widgetDisposed(DisposeEvent e) {
        this.wlHomeText = null;
        this.patchCombo = null;
        this.setComplete(false);
    }

    private void createWeblogicHomeControl(Composite content) {
        Composite locGroup = new Composite(content, 16);
        locGroup.setLayout((Layout)SwtUtil.glayout((int)3, (int)0, (int)0));
        locGroup.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(locGroup, 0);
        nameLabel.setText(Resources.getString("runtimeWizard.label.runtimeName", new Object[0]));
        this.nameText = new Text(locGroup, 2052);
        this.nameText.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerRuntimeWizardFragment.this.updateName();
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
            }
        });
        Label wlHomeLabel = new Label(locGroup, 0);
        wlHomeLabel.setText(String.valueOf(Resources.getString("runtimeWizard.label.wlhome", new Object[0])) + ":");
        GridData labelData = new GridData();
        labelData.horizontalSpan = 1;
        wlHomeLabel.setLayoutData((Object)labelData);
        this.wlHomeText = new Text(locGroup, 2052);
        this.wlHomeText.setLayoutData((Object)new GridData(768));
        this.wlHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerRuntimeWizardFragment.this.updateRuntimeLocation();
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
                WeblogicServerRuntimeWizardFragment.this.updateRuntimePatchProfileList();
                WeblogicServerRuntimeWizardFragment.this.resetJavaHome();
                if (WeblogicServerRuntimeWizardFragment.this.isComplete()) {
                    WeblogicServerRuntimeWizardFragment.this.extensionsControl.update();
                } else {
                    WeblogicServerRuntimeWizardFragment.this.extensionsControl.clean();
                }
            }
        });
        ToolBar toolbar = new ToolBar(locGroup, 0x800100);
        ToolItem wlHomeBrowseButton = new ToolItem(toolbar, 8);
        wlHomeBrowseButton.setImage(WlsUiPlugin.IMG_DESC_BROWSE.createImage());
        wlHomeBrowseButton.setToolTipText(Resources.getString("runtimeWizard.label.browse", new Object[0]));
        wlHomeBrowseButton.setEnabled(true);
        wlHomeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                DirectoryDialog browseDialog = new DirectoryDialog(Display.getDefault().getActiveShell());
                browseDialog.setFilterPath(WeblogicServerRuntimeWizardFragment.this.wlHomeText.getText());
                String res = browseDialog.open();
                if (res != null) {
                    WeblogicServerRuntimeWizardFragment.this.wlHomeText.setText(res);
                }
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
                WeblogicServerRuntimeWizardFragment.this.extensionsControl.update();
            }
        });
        this.wlHomeText.forceFocus();
        Label javaHomeLabel = new Label(locGroup, 0);
        javaHomeLabel.setText(String.valueOf(Resources.getString("runtimeWizard.label.javahome", new Object[0])) + ":");
        GridData javaHomeLabelData = new GridData();
        javaHomeLabelData.horizontalSpan = 1;
        javaHomeLabel.setLayoutData((Object)javaHomeLabelData);
        this.javaHomeText = new Text(locGroup, 2052);
        this.javaHomeText.setLayoutData((Object)new GridData(768));
        this.javaHomeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerRuntimeWizardFragment.this.updateJavaHome();
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
            }
        });
        ToolBar toolbar2 = new ToolBar(locGroup, 0x800100);
        ToolItem javaHomeBrowseButton = new ToolItem(toolbar2, 8);
        javaHomeBrowseButton.setImage(WlsUiPlugin.IMG_DESC_BROWSE.createImage());
        javaHomeBrowseButton.setToolTipText(Resources.getString("runtimeWizard.label.browse", new Object[0]));
        javaHomeBrowseButton.setEnabled(true);
        javaHomeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                DirectoryDialog browseDialog = new DirectoryDialog(Display.getDefault().getActiveShell());
                browseDialog.setFilterPath(WeblogicServerRuntimeWizardFragment.this.javaHomeText.getText());
                String res = browseDialog.open();
                if (res != null) {
                    WeblogicServerRuntimeWizardFragment.this.javaHomeText.setText(res);
                }
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
            }
        });
        Label patchComboLabel = new Label(locGroup, 0);
        patchComboLabel.setText(Resources.getString("runtimeWizard.label.patchProfile", new Object[0]));
        this.patchCombo = new Combo(locGroup, 12);
        this.patchCombo.setLayoutData((Object)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2));
        this.patchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!WeblogicServerRuntimeWizardFragment.this.isInAction()) {
                    return;
                }
                WeblogicServerRuntimeWizardFragment.this.updateRuntimePatchProfile();
                WeblogicServerRuntimeWizardFragment.this.updateFragment();
                if (WeblogicServerRuntimeWizardFragment.this.isComplete()) {
                    WeblogicServerRuntimeWizardFragment.this.extensionsControl.update();
                } else {
                    WeblogicServerRuntimeWizardFragment.this.extensionsControl.clean();
                }
            }
        });
    }

    private void updateRuntimeLocation() {
        if (this.runtimeWC != null) {
            this.runtimeWC.setLocation((IPath)new Path(this.wlHomeText.getText()));
        }
    }

    private void updateRuntimePatchProfile() {
        if (this.wc != null && this.patchCombo.isEnabled()) {
            int selection = this.patchCombo.getSelectionIndex();
            if (selection == 0) {
                this.wc.setPatchProfile(null);
            } else if (selection > 0) {
                String profile = this.patchCombo.getItem(selection);
                List profiles = this.wc.getPossiblePatchProfiles();
                for (String possible : profiles) {
                    if (!possible.equals(profile)) continue;
                    this.wc.setPatchProfile(possible);
                    break;
                }
            }
        }
    }

    private void updateRuntimePatchProfileList() {
        if (this.wc != null && this.isComplete()) {
            List possible = this.wc.getPossiblePatchProfiles();
            if (possible.size() > 0) {
                String current = this.wc.getPatchProfile();
                int index = possible.indexOf(current);
                if (index == -1) {
                    index = 0;
                }
                this.patchCombo.setItems(possible.toArray(new String[possible.size()]));
                this.patchCombo.select(index);
                this.patchCombo.setEnabled(true);
            } else {
                this.patchCombo.setItems(new String[0]);
                this.patchCombo.setEnabled(false);
            }
        } else {
            this.patchCombo.setItems(new String[0]);
            this.patchCombo.setEnabled(false);
        }
    }

    private void updateName() {
        this.runtimeWC.setName(this.nameText.getText().trim());
    }

    private void resetJavaHome() {
        IPath path = this.weblogic.getJavaVmLocation();
        if (path == null) {
            this.javaHomeText.setText("");
        } else {
            this.javaHomeText.setText(path.toOSString());
        }
    }

    private void updateJavaHome() {
        if (this.runtimeWC != null) {
            String javaHomeStr = this.javaHomeText.getText().trim();
            if (javaHomeStr.length() == 0) {
                javaHomeStr = null;
            }
            Path javaHome = javaHomeStr == null ? null : new Path(javaHomeStr);
            IPath defaultJavaHome = this.wc.getDefaultJavaVmLocation();
            if (javaHome != null && defaultJavaHome != null && javaHome.equals((Object)defaultJavaHome)) {
                javaHome = null;
            }
            this.wc.setJavaVmLocation((IPath)javaHome);
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public void enter() {
        super.enter();
        this.showValidateProgressDlg = true;
        IStatus envValidationStatus = this.weblogic.validateEclipseEnv();
        if (!envValidationStatus.isOK()) {
            this.statusUpdated(envValidationStatus);
        }
    }
}

