/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.io.File;
import java.io.FilenameFilter;
import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerLaunchConfiguration;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTabGroup;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.sourcelookup.SourceLookupTab;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;

public class WeblogicLaunchConfigurationTabGroup
extends AbstractLaunchConfigurationTabGroup {
    private static final String[] EMPTY_STRINGS = new String[0];
    private WeblogicServerLaunchConfigurationTab mainTab;
    private EnhancedEnvironmentTab envTab;

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration((ILaunchConfiguration)config);
        lc.setDefaults(config);
        super.setDefaults(config);
    }

    protected static IWeblogicServerLaunchConfiguration getWeblogicServerLaunchConfiguration(ILaunchConfiguration config) {
        try {
            ILaunchConfigurationType type = config.getType();
            ILaunchConfigurationDelegate delegate = type.getDelegate("debug");
            if (delegate instanceof IWeblogicServerLaunchConfiguration) {
                return (IWeblogicServerLaunchConfiguration)delegate;
            }
            return null;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        ILaunchConfigurationTab[] tabs;
        this.envTab = new EnhancedEnvironmentTab();
        this.mainTab = new WeblogicServerLaunchConfigurationTab();
        ILaunchConfigurationTab[] iLaunchConfigurationTabArray = tabs = new ILaunchConfigurationTab[]{this.mainTab, new SourceLookupTab(), this.envTab, new CommonTab()};
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfigurationTab tab = iLaunchConfigurationTabArray[n2];
            tab.setLaunchConfigurationDialog(dialog);
            ++n2;
        }
        this.setTabs(tabs);
    }

    class EnhancedEnvironmentTab
    extends EnvironmentTab {
        EnhancedEnvironmentTab() {
        }

        public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
            this.initializeFrom((ILaunchConfiguration)workingCopy);
        }

        public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
            this.performApply(workingCopy);
        }

        public void updateEnvironment(ILaunchConfiguration configuration) {
            super.updateEnvironment(configuration);
        }

        public void performApply(ILaunchConfigurationWorkingCopy configuration) {
            super.performApply(configuration);
            WeblogicLaunchConfigurationTabGroup.this.mainTab.updateEnviornment((ILaunchConfiguration)configuration);
        }
    }

    private static final class Resources
    extends NLS {
        public static String launchInEclipseCheckbox;

        static {
            Resources.initializeMessages((String)WeblogicLaunchConfigurationTabGroup.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    class WeblogicServerLaunchConfigurationTab
    extends AbstractLaunchConfigurationTab {
        private IServer[] servers;
        private Composite parent;
        private Combo serverCombo;
        private Label runtimeLabel;
        private Label hostLabel;
        private Label serverLocationLabel;
        private Label wlhomeLabel;
        private Combo scriptCombo;
        private Button launchButton;
        private boolean inAction;

        WeblogicServerLaunchConfigurationTab() {
        }

        public Image getImage() {
            return ImageResource.getImage((String)"server");
        }

        public String getName() {
            return Messages.serverLaunchConfigurationTab;
        }

        public void createControl(Composite parent) {
            this.parent = parent;
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginWidth = 10;
            layout.marginHeight = 10;
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            Label label = new Label(composite, 64);
            label.setText("&" + Messages.serverLaunchServer);
            label.setLayoutData((Object)new GridData(768));
            this.serverCombo = new Combo(composite, 2060);
            this.serverCombo.setLayoutData((Object)new GridData(768));
            this.serverCombo.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    if (!WeblogicServerLaunchConfigurationTab.this.inAction) {
                        return;
                    }
                    WeblogicServerLaunchConfigurationTab.this.handleServerSelection();
                }
            });
            WorkbenchHelp.setHelp((Control)this.serverCombo, (String)"org.eclipse.wst.server.ui.swsl0000");
            this.serverLocationLabel = new Label(composite, 64);
            this.serverLocationLabel.setLayoutData((Object)new GridData(768));
            this.runtimeLabel = new Label(composite, 0);
            this.runtimeLabel.setLayoutData((Object)new GridData(768));
            this.wlhomeLabel = new Label(composite, 64);
            this.wlhomeLabel.setLayoutData((Object)new GridData(768));
            this.hostLabel = new Label(composite, 0);
            this.hostLabel.setLayoutData((Object)new GridData(768));
            Group border = new Group(composite, 16);
            border.setLayoutData((Object)new GridData(768));
            border.setText(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.startScript.label", new Object[0]));
            border.setLayout((Layout)new GridLayout(2, false));
            this.scriptCombo = new Combo((Composite)border, 4);
            this.scriptCombo.setLayoutData((Object)new GridData(768));
            this.scriptCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!WeblogicServerLaunchConfigurationTab.this.inAction) {
                        return;
                    }
                    WeblogicServerLaunchConfigurationTab.this.handleScriptNameChange();
                }
            });
            this.scriptCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (!WeblogicServerLaunchConfigurationTab.this.inAction) {
                        return;
                    }
                    WeblogicServerLaunchConfigurationTab.this.handleScriptNameChange();
                }
            });
            this.setControl((Control)composite);
            Composite launchOptionControl = this.createLaunchOptionControl();
            launchOptionControl.setLayoutData((Object)new GridData(768));
        }

        private Composite createLaunchOptionControl() {
            Composite launchComposite = new Composite(this.parent, 524288);
            launchComposite.setLayout((Layout)new RowLayout(256));
            this.launchButton = new Button(launchComposite, 32);
            this.launchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!WeblogicServerLaunchConfigurationTab.this.inAction) {
                        return;
                    }
                    WeblogicServerLaunchConfigurationTab.this.handleLaunchOptionSelection();
                }
            });
            this.launchButton.setText(String.valueOf(Resources.launchInEclipseCheckbox) + "(to be moved to LaunchConfigurationTab??)");
            this.launchButton.setEnabled(false);
            return launchComposite;
        }

        public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        }

        public void performApply(ILaunchConfigurationWorkingCopy config) {
            IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration((ILaunchConfiguration)config);
            lc.setServer(config, this.getServer());
            lc.setStartScript(config, this.scriptCombo.getText());
            WeblogicLaunchConfigurationTabGroup.this.envTab.updateEnvironment((ILaunchConfiguration)config);
        }

        public void initializeFrom(ILaunchConfiguration config) {
            IServer server;
            this.inAction = false;
            this.serverCombo.setEnabled(true);
            this.setErrorMessage(null);
            IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration(config);
            this.servers = lc.getSupportedServers(config);
            this.serverCombo.removeAll();
            IServer[] iServerArray = this.servers;
            int n = this.servers.length;
            int n2 = 0;
            while (n2 < n) {
                server = iServerArray[n2];
                this.serverCombo.add(server.getName());
                ++n2;
            }
            server = lc.getServer(config);
            IRuntime runtime = null;
            if (server == null) {
                if (this.servers.length > 0) {
                    this.serverCombo.select(0);
                    server = this.getServer();
                }
            } else {
                this.serverCombo.setText(server.getName());
            }
            if (server != null) {
                runtime = server.getRuntime();
                IWeblogicServer weblogic = (IWeblogicServer)server.loadAdapter(IWeblogicServer.class, null);
                this.hostLabel.setText(String.valueOf(Messages.serverLaunchHost) + " " + server.getHost());
                String label = oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.domainPath.label", new Object[0]);
                this.serverLocationLabel.setText(String.valueOf(label) + ": " + weblogic.getDomainPath().toOSString());
                String[] items = this.getScripts(weblogic.getDomainPath());
                String setScript = lc.getStartScript(config);
                if (items != null && items.length > 0) {
                    this.scriptCombo.setItems(items);
                    if (setScript != null && setScript.length() > 0) {
                        this.scriptCombo.setText(setScript);
                    } else {
                        this.scriptCombo.clearSelection();
                    }
                } else {
                    this.scriptCombo.removeAll();
                    if (setScript != null && setScript.length() > 0) {
                        this.scriptCombo.setText(setScript);
                    } else {
                        this.scriptCombo.clearSelection();
                    }
                }
                if (weblogic.isRemote()) {
                    this.scriptCombo.setEnabled(false);
                    this.scriptCombo.getParent().setEnabled(false);
                }
            } else {
                this.hostLabel.setText(Messages.serverLaunchHost);
                this.serverLocationLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.domainPath.label", new Object[0])) + ": ");
                this.scriptCombo.setItems(EMPTY_STRINGS);
            }
            if (runtime != null) {
                this.runtimeLabel.setText(String.valueOf(Messages.serverLaunchRuntime) + " " + runtime.getName());
                this.wlhomeLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.weblogicHome.label", new Object[0])) + ": " + runtime.getLocation().toOSString());
            } else {
                this.runtimeLabel.setText(Messages.serverLaunchRuntime);
                this.wlhomeLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.weblogicHome.label", new Object[0])) + ": ");
            }
            this.updateEnviornment(config);
            this.updateLaunchConfigurationDialog();
            this.inAction = true;
        }

        private IServer getServer() {
            if (this.servers == null || this.servers.length == 0) {
                return null;
            }
            int i = this.serverCombo.getSelectionIndex();
            if (i >= 0 && i < this.servers.length) {
                return this.servers[i];
            }
            return null;
        }

        private void handleScriptNameChange() {
            this.updateLaunchConfigurationDialog();
        }

        protected void handleDebugPort() {
            this.updateLaunchConfigurationDialog();
        }

        protected void handleLaunchOptionSelection() {
            this.updateLaunchConfigurationDialog();
        }

        protected void handleAllowAttachSelection() {
            this.updateLaunchConfigurationDialog();
        }

        protected void handleServerSelection() {
            this.updateServerChange();
            this.updateLaunchConfigurationDialog();
        }

        private void updateServerChange() {
            IServer server = this.getServer();
            IRuntime runtime = null;
            if (server != null) {
                runtime = server.getRuntime();
                this.hostLabel.setText(String.valueOf(Messages.serverLaunchHost) + " " + server.getHost());
                IWeblogicServer weblogic = (IWeblogicServer)this.getServer().loadAdapter(IWeblogicServer.class, null);
                this.serverLocationLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.domainPath.label", new Object[0])) + ": " + weblogic.getDomainPath().toOSString());
                String[] items = this.getScripts(weblogic.getDomainPath());
                if (items != null && items.length > 0) {
                    this.scriptCombo.setItems(items);
                    this.scriptCombo.select(0);
                }
            } else {
                this.hostLabel.setText(Messages.serverLaunchHost);
                this.serverLocationLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.domainPath.label", new Object[0])) + ": ");
                this.scriptCombo.setItems(EMPTY_STRINGS);
            }
            if (runtime != null) {
                this.runtimeLabel.setText(String.valueOf(Messages.serverLaunchRuntime) + " " + runtime.getName());
                this.wlhomeLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.weblogicHome.label", new Object[0])) + ": " + runtime.getLocation().toOSString());
            } else {
                this.runtimeLabel.setText(Messages.serverLaunchRuntime);
                this.wlhomeLabel.setText(String.valueOf(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("launchWizard.weblogicHome.label", new Object[0])) + ": ");
            }
        }

        public void updateEnviornment(ILaunchConfiguration config) {
            IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration(config);
            lc.isRunWithDebug(config);
        }

        public boolean isValid(ILaunchConfiguration config) {
            IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration(config);
            if (lc == null) {
                this.setErrorMessage(oracle.eclipse.tools.weblogic.ui.server.internal.Resources.getString("errorServerStateInvalid", new Object[0]));
                return false;
            }
            IStatus status = lc.validateStartable(config);
            if (status.isOK()) {
                this.setErrorMessage(null);
                return true;
            }
            this.setErrorMessage(status.getMessage());
            return false;
        }

        protected void verifyConfiguration(ILaunchConfiguration config) {
            IWeblogicServerLaunchConfiguration lc = WeblogicLaunchConfigurationTabGroup.getWeblogicServerLaunchConfiguration(config);
            if (lc == null) {
                return;
            }
            IStatus status = lc.validateStartable(config);
            if (status.isOK()) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(status.getMessage());
            }
        }

        private String[] getScripts(IPath path) {
            File folder = path.toFile();
            String[] exts = CorePlugin.IS_WINDOWS ? CorePlugin.SHELLSCRIPT_WINDOWS_EXT.toArray(new String[CorePlugin.SHELLSCRIPT_WINDOWS_EXT.size()]) : CorePlugin.SHELLSCRIPT_UNIX_EXT.toArray(new String[CorePlugin.SHELLSCRIPT_UNIX_EXT.size()]);
            ScriptFilter filter = new ScriptFilter(folder, exts);
            return folder.list(filter);
        }

        class ScriptFilter
        implements FilenameFilter {
            private final String[] exts;
            private final File dir;

            ScriptFilter(File dir, String[] exts) {
                this.dir = dir;
                this.exts = exts;
            }

            @Override
            public boolean accept(File dir, String name) {
                if (!this.dir.equals(dir)) {
                    return false;
                }
                String[] stringArray = this.exts;
                int n = this.exts.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (name.endsWith(ext)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean accept(File pathname) {
                return this.accept(pathname.getParentFile(), pathname.getName());
            }
        }
    }
}

