/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.util.ArrayList;
import java.util.Map;
import oracle.eclipse.tools.weblogic.MBeanUtil;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServer;
import oracle.eclipse.tools.weblogic.ui.server.internal.cnf.mbean.MBeanNode;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.IServerModule;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerToolTip;
import org.eclipse.wst.server.ui.internal.provisional.IServerToolTip;

public class ServerMBeanToolTip
extends ServerToolTip {
    public ServerMBeanToolTip(Tree tree) {
        super(tree);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        TreeItem o = this.tree.getItem(new Point(event.x, event.y));
        if (o == null) {
            return null;
        }
        IServer server = null;
        IServerModule module = null;
        MBeanNode mbeanNode = null;
        if (o instanceof TreeItem) {
            Object obj = o.getData();
            if (obj instanceof IServer) {
                server = (IServer)obj;
            }
            if (obj instanceof IServerModule) {
                module = (IServerModule)obj;
            }
            if (obj instanceof MBeanNode) {
                mbeanNode = (MBeanNode)obj;
            }
        }
        FillLayout layout = (FillLayout)parent.getLayout();
        layout.type = 512;
        parent.setLayout((Layout)layout);
        StyledText sText = new StyledText(parent, 0);
        sText.setEditable(false);
        sText.setBackground(parent.getDisplay().getSystemColor(29));
        if (module != null) {
            IModule[] modules = module.getModule();
            IModule m = modules[modules.length - 1];
            sText.setText("<b>" + m.getName() + "</b>");
            StyledText sText2 = new StyledText(parent, 0);
            sText2.setEditable(false);
            sText2.setBackground(parent.getDisplay().getSystemColor(29));
            sText2.setText(m.getModuleType().getName());
        }
        if (server != null) {
            sText.setText("<b>" + server.getName() + "</b>");
            if (server.getServerType() != null) {
                ArrayList listOfProviders = (ArrayList)this.toolTipProviders.get(server.getServerType().getId());
                Composite adoptersComposite = new Composite(parent, 0);
                adoptersComposite.setLayout((Layout)new FillLayout());
                adoptersComposite.setBackground(parent.getDisplay().getSystemColor(29));
                if (listOfProviders != null) {
                    for (IServerToolTip tipProvider : listOfProviders) {
                        tipProvider.createContent(adoptersComposite, server);
                    }
                }
            }
        }
        if (mbeanNode != null) {
            Map theHelp;
            String desc;
            TreeItem ti;
            WeblogicServer weblogic;
            sText.setText("<b>" + mbeanNode.getName() + "</b>");
            if (o instanceof TreeItem && (weblogic = this.findWeblogicServer(ti = o)) != null && (desc = (String)(theHelp = MBeanUtil.getMBeanDescription((WeblogicServer)weblogic, (String)mbeanNode.getPath())).get("com.bea.description")) != null) {
                sText.setText(desc);
            }
        }
        this.hintLabel = new Label(parent, 2048);
        this.hintLabel.setAlignment(131072);
        this.hintLabel.setBackground(parent.getDisplay().getSystemColor(29));
        this.hintLabel.setText(Messages.toolTipEnableFocus);
        this.hintLabel.setForeground(parent.getDisplay().getSystemColor(16));
        Display display = parent.getDisplay();
        FontData[] fd = parent.getFont().getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setHeight(7);
            ++i;
        }
        final Font font = new Font((Device)display, fd);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.hintLabel.setFont(font);
        this.parseText(sText.getText(), sText);
        return parent;
    }

    private WeblogicServer findWeblogicServer(TreeItem ti) {
        if (ti == null) {
            return null;
        }
        TreeItem parent = ti.getParentItem();
        Object o = parent.getData();
        if (o != null && o instanceof IServer) {
            IServer s = (IServer)o;
            WeblogicServer weblogic = (WeblogicServer)s.loadAdapter(WeblogicServer.class, null);
            return weblogic;
        }
        return this.findWeblogicServer(parent);
    }
}

