/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public final class Resources {
    public static final String ORACLE_WIZBAN_IMAGE = "oracle-bannerlogo";
    public static final String BEA_WIZBAN_IMAGE = "bea-bannerlogo";
    public static final String ORACLE_LOGO_XTRA_SMALL = "/images/weblogic-server.png";
    private static final ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.eclipse.tools.weblogic.ui.server.internal.Resources");
    private static final ImageRegistry imageRegistry = new ImageRegistry();

    static {
        Bundle bundle = WlsUiPlugin.getInstance().getBundle();
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bundle.getEntry("/images/wizban-wls.gif"));
        imageRegistry.put(ORACLE_WIZBAN_IMAGE, desc);
        desc = ImageDescriptor.createFromURL((URL)bundle.getEntry("/images/wizban-bea.gif"));
        imageRegistry.put(BEA_WIZBAN_IMAGE, desc);
        desc = ImageDescriptor.createFromURL((URL)bundle.getEntry(ORACLE_LOGO_XTRA_SMALL));
        imageRegistry.put(ORACLE_LOGO_XTRA_SMALL, desc);
    }

    public static String getString(String key, Object ... args) {
        try {
            if (args == null || args.length == 0) {
                return resourceBundle.getString(key);
            }
            return String.format(resourceBundle.getString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static Image getImage(String key) {
        ImageDescriptor descriptor;
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = Resources.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return imageRegistry.getDescriptor(key);
    }
}

