/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.dialogs.SelectionDialog;

public class PublishWarningDialog
extends SelectionDialog {
    private IStructuredContentProvider fContentProvider;
    private ITableLabelProvider fLabelProvider;
    private Object fInput;
    private CheckboxTableViewer fTableViewer;
    private boolean fAddCancelButton = true;
    private int widthInChars = 80;
    private int heightInChars = 15;
    private TreeSet<Integer> selectedIDs = new TreeSet();

    public PublishWarningDialog(Shell parent) {
        super(parent);
        this.setTitle(Resources.dlgTitle);
        this.setAddCancelButton(false);
    }

    public void setInput(Object input) {
        this.fInput = input;
    }

    public void setAddCancelButton(boolean addCancelButton) {
        this.fAddCancelButton = addCancelButton;
    }

    public TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fAddCancelButton) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        } else {
            super.createButtonsForButtonBar(parent);
        }
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.createMessageArea(parent);
        this.initTableViewerProviders();
        GridData gd = new GridData(768);
        gd.widthHint = 480;
        Label label = new Label(parent, 64);
        label.setText(Resources.selectIngnorableWarningsLabel);
        label.setLayoutData((Object)gd);
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)this.getTableStyle());
        this.fTableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(this.heightInChars);
        gd.widthHint = this.convertWidthInCharsToPixels(this.widthInChars);
        Table table = this.fTableViewer.getTable();
        table.setLayoutData((Object)gd);
        table.setFont(container.getFont());
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column = new TableColumn(table, 0);
        column.setWidth(20);
        column = new TableColumn(table, 1);
        column.setWidth(40);
        column.setText(Resources.idLabel);
        column = new TableColumn(table, 2);
        column.setWidth(400);
        column.setText(Resources.descriptionLabel);
        this.fTableViewer.setInput(this.fInput);
        Object[] initilaSelections = this.getInitialElementSelections().toArray();
        this.fTableViewer.setCheckedElements(initilaSelections);
        return parent;
    }

    private void initTableViewerProviders() {
        this.fContentProvider = new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                TreeMap warnings = (TreeMap)inputElement;
                Set set = warnings.entrySet();
                return set.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
        this.fLabelProvider = new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                Map.Entry warning = (Map.Entry)element;
                if (columnIndex == 1) {
                    return "" + warning.getKey();
                }
                if (columnIndex == 2) {
                    return (String)warning.getValue();
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        };
    }

    protected int getTableStyle() {
        return 2819;
    }

    protected void okPressed() {
        Object[] selection;
        Object[] objectArray = selection = this.fTableViewer.getCheckedElements();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            Map.Entry e = (Map.Entry)o;
            this.selectedIDs.add((Integer)e.getKey());
            ++n2;
        }
        super.okPressed();
    }

    public Set<Integer> getSelectedIds() {
        return this.selectedIDs;
    }

    public int getHeightInChars() {
        return this.heightInChars;
    }

    public int getWidthInChars() {
        return this.widthInChars;
    }

    public void setHeightInChars(int heightInChars) {
        this.heightInChars = heightInChars;
    }

    public void setWidthInChars(int widthInChars) {
        this.widthInChars = widthInChars;
    }

    private static final class Resources
    extends NLS {
        public static String dlgTitle;
        public static String idLabel;
        public static String descriptionLabel;
        public static String selectIngnorableWarningsLabel;

        static {
            Resources.initializeMessages((String)PublishWarningDialog.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

