/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.server.internal;

import oracle.eclipse.tools.weblogic.server.CorePlugin;
import oracle.eclipse.tools.weblogic.server.IWeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.ui.server.internal.Resources;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public abstract class BaseWizardFragment
extends WizardFragment
implements DisposeListener {
    protected static final IStatus STATUS_NOT_INIT = CorePlugin.createErrorStatus((String)"Not Initialized");
    private IWizardHandle wizard;
    private boolean inAction = false;

    public BaseWizardFragment() {
        this.setComplete(false);
    }

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.wizard = handle;
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout grid = new GridLayout(1, false);
        container.setLayout((Layout)grid);
        handle.setTitle(this.getTitle());
        handle.setDescription(this.getDescription());
        TaskModel taskModel = this.getTaskModel();
        IRuntime runtime = (IRuntime)taskModel.getObject("runtime");
        IRuntimeType type = runtime.getRuntimeType();
        ImageDescriptor imageDescriptor = type == IWeblogicServerRuntime.RUNTIME_TYPE_8_1 || type == IWeblogicServerRuntime.RUNTIME_TYPE_9_0 || type == IWeblogicServerRuntime.RUNTIME_TYPE_9_1 || type == IWeblogicServerRuntime.RUNTIME_TYPE_9_2 || type == IWeblogicServerRuntime.RUNTIME_TYPE_10_0 ? Resources.getImageDescriptor("bea-bannerlogo") : Resources.getImageDescriptor("oracle-bannerlogo");
        handle.setImageDescriptor(imageDescriptor);
        this.createContent(container, handle);
        parent.addDisposeListener((DisposeListener)this);
        return container;
    }

    public void widgetDisposed(DisposeEvent e) {
        this.wizard = null;
    }

    public IWizardHandle getWizard() {
        return this.wizard;
    }

    public void focusGained(FocusEvent e) {
        if (this.inAction) {
            this.updateFragment();
        }
    }

    public void focusLost(FocusEvent e) {
        if (this.inAction) {
            this.updateFragment();
        }
    }

    public void enter() {
        this.inAction = false;
        this.bindTaskModels();
        this.drainModels();
        this.inAction = true;
    }

    protected final boolean isInAction() {
        return this.inAction;
    }

    public final void exit() {
        this.inAction = false;
        this.unbindTaskModels();
    }

    protected abstract void bindTaskModels();

    protected abstract void drainModels();

    protected abstract void unbindTaskModels();

    protected abstract IStatus validate();

    protected void statusUpdated(IStatus status) {
        if (status == null) {
            this.getWizard().setMessage(null, 0);
            this.setComplete(false);
        } else if (status == STATUS_NOT_INIT) {
            this.getWizard().setMessage(null, 0);
            this.setComplete(false);
        } else if (status.isOK()) {
            this.getWizard().setMessage(null, 0);
            this.setComplete(true);
        } else {
            StringBuffer buffer = new StringBuffer();
            IStatus cur = status;
            while (buffer.length() < 180) {
                if (buffer.length() > 0) {
                    buffer.append(" ");
                }
                buffer.append(cur.getMessage());
                IStatus[] children = cur.getChildren();
                if (children == null || children.length < 1) break;
                cur = children[0];
            }
            this.getWizard().setMessage(buffer.toString(), this.getMessageType(status));
            this.setComplete(false);
        }
        this.getWizard().update();
    }

    protected void updateFragment() {
        IStatus status = this.validate();
        this.statusUpdated(status);
    }

    private int getMessageType(IStatus status) {
        switch (status.getSeverity()) {
            case 1: {
                return 1;
            }
            case 2: 
            case 8: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 0: {
                return 0;
            }
        }
        return 2;
    }

    public abstract String getDescription();

    public abstract String getTitle();

    public abstract void createContent(Composite var1, IWizardHandle var2);
}

