/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.migration.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.common.ui.util.ThreadUtil;
import oracle.eclipse.tools.common.util.logging.LoggingService;
import oracle.eclipse.tools.weblogic.migration.RuntimeMigrationDataModelProvider;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationErrorDialog;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationMainPage;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationResources;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class RuntimeMigrationWizard
extends Wizard
implements INewWizard {
    private RuntimeMigrationMainPage mainPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    private IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new RuntimeMigrationDataModelProvider());

    public RuntimeMigrationWizard(Set<IProject> set) {
        this.model.setProperty("IRuntimeMigrationDataModelProperties.PROJECTS", set);
        this.setWindowTitle(RuntimeMigrationResources.ProjectMigration);
    }

    public void addPages() {
        this.mainPage = new RuntimeMigrationMainPage(this.workbench, this.selection, this.model);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public synchronized boolean performCancel() {
        ((Object)((Object)this)).notify();
        return true;
    }

    public boolean performFinish() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(IProgressMonitor monitor) {
                RuntimeMigrationWizard wizard;
                RuntimeMigrationWizard runtimeMigrationWizard = wizard = RuntimeMigrationWizard.this;
                synchronized (runtimeMigrationWizard) {
                    ((Object)((Object)wizard)).notify();
                    try {
                        IStatus status = RuntimeMigrationWizard.this.model.getDefaultOperation().execute(monitor, null);
                        if (status != null && status.getSeverity() != 0) {
                            RuntimeMigrationWizard.this.showMigrationStatusDialog(status);
                        }
                    }
                    catch (ExecutionException ex) {
                        LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)ex);
                        Object exStatus = ex.getCause() instanceof CoreException ? ((CoreException)ex.getCause()).getStatus() : new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, RuntimeMigrationResources.MigrationErrorMessage, (Throwable)ex);
                        RuntimeMigrationWizard.this.showMigrationStatusDialog(exStatus);
                    }
                    catch (RuntimeException re) {
                        LoggingService.logException((String)"oracle.eclipse.tools.weblogic.ui", (Throwable)re);
                        RuntimeMigrationWizard.this.showMigrationStatusDialog((IStatus)new Status(4, "oracle.eclipse.tools.weblogic.ui", 0, RuntimeMigrationResources.MigrationErrorMessage, (Throwable)re));
                    }
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    private void showMigrationStatusDialog(IStatus status) {
        if (status.getSeverity() == 0) {
            return;
        }
        final IStatus errorStatus = status;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Shell activeShell = SwtUtil.getActiveShell();
                RuntimeMigrationErrorDialog dialog = new RuntimeMigrationErrorDialog(activeShell, errorStatus);
                dialog.open();
            }
        };
        ThreadUtil.ensureRunOnUIThread((Runnable)runnable);
    }
}

