/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.migration.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import oracle.eclipse.tools.common.util.CollectionsUtil;
import oracle.eclipse.tools.common.wtp.core.RuntimeBridgeUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.ui.migration.internal.RuntimeMigrationResources;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;

public class RuntimeMigrationServerPage
extends Composite {
    private Combo serverCombo;
    private Combo runtimeCombo;
    private Button newRuntimeButton;
    private Button newServerButton;
    private final IDataModel model;
    private final WebLogicServerVersion highestWLSVersion;
    private Map<String, IRuntime> runtimeNameMap = new HashMap<String, IRuntime>();
    private Map<String, IServer> serverNameMap = new HashMap<String, IServer>();

    public RuntimeMigrationServerPage(Composite parent, int style, IDataModel dm) {
        super(parent, style);
        this.model = dm;
        this.highestWLSVersion = this.getHighestSelectedRuntime((Set)this.model.getProperty("IRuntimeMigrationDataModelProperties.PROJECTS"));
        this.setLayout((Layout)new GridLayout(3, false));
        this.setLayoutData(new GridData(4, 4, true, true));
        EventListener listener = new EventListener();
        GridData buttonGridData = new GridData(256);
        buttonGridData.horizontalAlignment = 768;
        Label runtimeLabel = new Label((Composite)this, 0);
        runtimeLabel.setLayoutData((Object)new GridData(128));
        runtimeLabel.setText(RuntimeMigrationResources.TargetRuntime);
        this.runtimeCombo = new Combo((Composite)this, 2060);
        this.runtimeCombo.addSelectionListener((SelectionListener)listener);
        this.newRuntimeButton = new Button((Composite)this, 0);
        this.newRuntimeButton.setText(RuntimeMigrationResources.NewRuntime);
        this.newRuntimeButton.addSelectionListener((SelectionListener)listener);
        this.newRuntimeButton.setLayoutData((Object)buttonGridData);
        Label serverLabel = new Label((Composite)this, 0);
        serverLabel.setLayoutData((Object)new GridData(128));
        serverLabel.setText(RuntimeMigrationResources.Server);
        this.serverCombo = new Combo((Composite)this, 2060);
        this.serverCombo.addSelectionListener((SelectionListener)listener);
        this.newServerButton = new Button((Composite)this, 0);
        this.newServerButton.setText(RuntimeMigrationResources.NewServer);
        this.newServerButton.addSelectionListener((SelectionListener)listener);
        this.newServerButton.setLayoutData((Object)buttonGridData);
        this.serverCombo.setLayoutData((Object)new GridData(768));
        this.runtimeCombo.setLayoutData((Object)new GridData(768));
        this.populateRuntimeCombo();
        this.populateServerCombo();
        listener.widgetSelected(null);
    }

    protected IRuntime getSelectedRuntime() {
        String runtimeName = null;
        int selectionIndex = this.runtimeCombo.getSelectionIndex();
        runtimeName = selectionIndex > -1 ? this.runtimeCombo.getItem(selectionIndex) : this.runtimeCombo.getText();
        return runtimeName == null ? null : this.runtimeNameMap.get(runtimeName);
    }

    private void setSelectedRuntime(IRuntime runtime) {
        if (runtime != null) {
            int selectionIndex = -1;
            String[] items = this.runtimeCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(runtime.getName())) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex != -1) {
                this.runtimeCombo.select(selectionIndex);
            }
        }
    }

    private boolean isValidRuntime(IRuntime runtime) {
        String[] stringArray = this.runtimeCombo.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String runtimeName = stringArray[n2];
            if (runtimeName.equals(runtime.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IServer getSelectedServer() {
        String serverName = null;
        int selectionIndex = this.serverCombo.getSelectionIndex();
        serverName = selectionIndex > -1 ? this.serverCombo.getItem(selectionIndex) : this.serverCombo.getText();
        return serverName == null ? null : this.serverNameMap.get(serverName);
    }

    private void setSelectedServer(IServer server) {
        int selectionIndex = 0;
        if (server != null) {
            String[] items = this.serverCombo.getItems();
            int i = 1;
            while (i < items.length) {
                if (items[i].equals(server.getName())) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
        }
        this.serverCombo.select(selectionIndex);
    }

    private boolean isValidServer(IServer server) {
        if (server != null) {
            String[] items = this.serverCombo.getItems();
            int i = 1;
            while (i < items.length) {
                if (items[i].equals(server.getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private WebLogicServerVersion getHighestSelectedRuntime(Set<IProject> selectedProjects) {
        WebLogicServerVersion highestVersion = null;
        for (IProject project : selectedProjects) {
            WebLogicServerVersion version = WebLogicServerVersion.detect((IProject)project);
            if (version == null || highestVersion != null && version.compareTo((Enum)highestVersion) <= 0) continue;
            highestVersion = version;
        }
        return highestVersion;
    }

    private void populateRuntimeCombo() {
        IRuntime selectedRuntime = this.getSelectedRuntime();
        this.runtimeNameMap.clear();
        this.runtimeCombo.removeAll();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime : RuntimeManager.getRuntimes()) {
            WebLogicServerVersion version = WebLogicServerVersion.detect((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
            if (version == null || this.highestWLSVersion != null && this.highestWLSVersion.compareTo((Enum)version) >= 0) continue;
            String name = runtime.getName();
            this.runtimeNameMap.put(name, RuntimeBridgeUtil.bridge((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime));
            this.runtimeCombo.add(name);
        }
        if (selectedRuntime == null && this.runtimeCombo.getItemCount() > 0) {
            selectedRuntime = this.runtimeNameMap.get(this.runtimeCombo.getItem(0));
        }
        this.setSelectedRuntime(selectedRuntime);
    }

    private void populateServerCombo() {
        IServer selectedServer = this.getSelectedServer();
        this.serverNameMap.clear();
        this.serverCombo.removeAll();
        this.serverCombo.add(RuntimeMigrationResources.NoServer);
        Set servers = WebLogicServerUtil.getWebLogicServers();
        for (IServer server : servers) {
            IRuntime runtime = server.getRuntime();
            if (runtime == null || !runtime.equals(this.getSelectedRuntime())) continue;
            String serverName = server.getName();
            this.serverNameMap.put(serverName, server);
            this.serverCombo.add(serverName);
        }
        this.setSelectedServer((IServer)(this.isValidServer(selectedServer) ? selectedServer : null));
    }

    private void handleWidgetEnablement() {
        this.runtimeCombo.setEnabled(!this.runtimeNameMap.isEmpty());
        this.serverCombo.setEnabled(!this.serverNameMap.isEmpty());
        this.newServerButton.setEnabled(this.getSelectedRuntime() != null);
    }

    private IRuntime launchNewRuntimeWizard(Shell shell) {
        Set oldRuntimes = CollectionsUtil.set((Object[])ServerCore.getRuntimes());
        if (ServerUIUtil.showNewRuntimeWizard((Shell)shell, null, null)) {
            IRuntime[] iRuntimeArray = ServerCore.getRuntimes();
            int n = iRuntimeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRuntime runtime = iRuntimeArray[n2];
                if (!oldRuntimes.contains(runtime)) {
                    return runtime;
                }
                ++n2;
            }
        }
        return null;
    }

    private IServer launchNewServerWizard(Shell shell) {
        Set oldServers = CollectionsUtil.set((Object[])ServerCore.getServers());
        if (ServerUIUtil.showNewServerWizard((Shell)shell, null, null, null)) {
            IServer[] iServerArray = ServerCore.getServers();
            int n = iServerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IServer server = iServerArray[n2];
                if (!oldServers.contains(server)) {
                    return server;
                }
                ++n2;
            }
        }
        return null;
    }

    private final class EventListener
    extends SelectionAdapter {
        private EventListener() {
        }

        public void widgetSelected(SelectionEvent selEvent) {
            if (selEvent != null) {
                if (selEvent.widget.equals(RuntimeMigrationServerPage.this.runtimeCombo)) {
                    int selIndex = RuntimeMigrationServerPage.this.runtimeCombo.getSelectionIndex();
                    if (selIndex >= 0) {
                        RuntimeMigrationServerPage.this.populateServerCombo();
                    }
                } else if (selEvent.widget.equals(RuntimeMigrationServerPage.this.newRuntimeButton)) {
                    IRuntime newRuntime = RuntimeMigrationServerPage.this.launchNewRuntimeWizard(RuntimeMigrationServerPage.this.getShell());
                    if (newRuntime != null) {
                        RuntimeMigrationServerPage.this.populateRuntimeCombo();
                        RuntimeMigrationServerPage.this.setSelectedRuntime(newRuntime);
                    }
                } else if (selEvent.widget.equals(RuntimeMigrationServerPage.this.newServerButton)) {
                    IRuntime runtime;
                    IServer newServer = RuntimeMigrationServerPage.this.launchNewServerWizard(RuntimeMigrationServerPage.this.getShell());
                    RuntimeMigrationServerPage.this.populateRuntimeCombo();
                    if (newServer != null && RuntimeMigrationServerPage.this.isValidRuntime(runtime = newServer.getRuntime())) {
                        RuntimeMigrationServerPage.this.setSelectedRuntime(runtime);
                        RuntimeMigrationServerPage.this.populateServerCombo();
                        RuntimeMigrationServerPage.this.setSelectedServer(newServer);
                    }
                }
            }
            RuntimeMigrationServerPage.this.handleWidgetEnablement();
            RuntimeMigrationServerPage.this.model.setProperty("IRuntimeMigrationDataModelProperties.SELECTED_RUNTIME", (Object)RuntimeMigrationServerPage.this.getSelectedRuntime());
            RuntimeMigrationServerPage.this.model.setProperty("IRuntimeMigrationDataModelProperties.SELECTED_SERVER", (Object)RuntimeMigrationServerPage.this.getSelectedServer());
        }
    }
}

