/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.jpa.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import oracle.eclipse.tools.common.util.MutableReference;
import oracle.eclipse.tools.weblogic.WebLogicServerInstall;
import oracle.eclipse.tools.weblogic.WebLogicServerVersion;
import oracle.eclipse.tools.weblogic.jpa.WebLogicServerJpaComponent;
import oracle.eclipse.tools.weblogic.ui.AsyncInstallCallback;
import oracle.eclipse.tools.weblogic.ui.WebLogicServerComponentHandler;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class WebLogicServerJpa2ComponentHandler
extends WebLogicServerComponentHandler {
    @Override
    public String getName(WebLogicServerInstall install) {
        return Resources.name;
    }

    @Override
    public boolean applicable(WebLogicServerInstall install) {
        return install.getVersion().compareTo((Enum)WebLogicServerVersion.VERSION_10_3_4) >= 0;
    }

    @Override
    public boolean installed(WebLogicServerInstall install) {
        return WebLogicServerJpaComponent.detect((WebLogicServerInstall)install) == WebLogicServerJpaComponent.VERSION_2_0;
    }

    @Override
    public void install(final WebLogicServerInstall install, Shell shell, AsyncInstallCallback callback) {
        RunnableWithProgress op = new RunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Resources.installingMessage, 1000);
                try {
                    File modulesLocation = install.getModulesLocation();
                    ArrayList<File> module1Files = new ArrayList<File>();
                    ArrayList<File> module2Files = new ArrayList<File>();
                    File[] fileArray = modulesLocation.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name;
                        File f = fileArray[n2];
                        if (f.isFile() && (name = f.getName().toLowerCase()).endsWith(".jar")) {
                            if (name.startsWith("javax.persistence_1.0.0.0_2-") || name.startsWith("javax.persistence_1.1.0.0_2-")) {
                                module1Files.add(f);
                            } else if (name.startsWith("com.oracle.jpa2support_1.0.0.0_2-")) {
                                module2Files.add(f);
                            }
                        }
                        ++n2;
                    }
                    monitor.worked(100);
                    if (!module1Files.isEmpty() && !module2Files.isEmpty()) {
                        Collections.sort(module1Files);
                        Collections.sort(module2Files);
                        ArrayList<File> contributions = new ArrayList<File>();
                        contributions.add((File)module1Files.get(module1Files.size() - 1));
                        contributions.add((File)module2Files.get(module2Files.size() - 1));
                        try {
                            install.addSystemClasspathContributions(contributions, (IProgressMonitor)new SubProgressMonitor(monitor, 900, 2));
                        }
                        catch (IOException ioe) {
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    String msg = Resources.stopWlsBeforeInstall;
                                    WlsUiPlugin.log(WlsUiPlugin.createErrorStatus(msg, ioe));
                                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Resources.error, (String)msg);
                                }
                            });
                        }
                    }
                    WebLogicServerJpaComponent.detect((WebLogicServerInstall)install, (boolean)true);
                }
                finally {
                    monitor.done();
                }
            }
        };
        final MutableReference provisioned = new MutableReference();
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                provisioned.set((Object)install.isSystemClasspathContributionsProvisioned());
            }
        });
        if (((Boolean)provisioned.get()).booleanValue()) {
            BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)op);
        } else {
            try {
                new ProgressMonitorDialog(shell).run(true, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                WlsUiPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean uninstallable(WebLogicServerInstall install) {
        boolean foundModule1 = false;
        boolean foundModule2 = false;
        for (File f : install.getSystemClasspathContributions()) {
            String name = f.getName();
            if (name.startsWith("javax.persistence_1.0.0.0_2-") || name.startsWith("javax.persistence_1.1.0.0_2-")) {
                foundModule1 = true;
                continue;
            }
            if (!name.startsWith("com.oracle.jpa2support_1.0.0.0_2-")) continue;
            foundModule2 = true;
        }
        return foundModule1 && foundModule2;
    }

    @Override
    public void uninstall(final WebLogicServerInstall install, Shell shell) {
        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                ArrayList contributions = new ArrayList(install.getSystemClasspathContributions());
                Iterator itr = contributions.iterator();
                while (itr.hasNext()) {
                    String name = ((File)itr.next()).getName();
                    if (!name.startsWith("javax.persistence_1.0.0.0_2-") && !name.startsWith("com.oracle.jpa2support_1.0.0.0_2-")) continue;
                    itr.remove();
                }
                try {
                    install.setSystemClasspathContributions(contributions, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error", (String)e.getMessage());
                }
                WebLogicServerJpaComponent.detect((WebLogicServerInstall)install, (boolean)true);
            }
        });
    }

    private static final class Resources
    extends NLS {
        public static String name;
        public static String installingMessage;
        public static String stopWlsBeforeInstall;
        public static String error;

        static {
            Resources.initializeMessages((String)WebLogicServerJpa2ComponentHandler.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static abstract class RunnableWithProgress
    implements Runnable,
    IRunnableWithProgress {
        private RunnableWithProgress() {
        }

        @Override
        public final void run() {
            try {
                this.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                WlsUiPlugin.log(e);
            }
        }
    }
}

