/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public final class RemoveLibraryFromDescriptorResolution
implements IMarkerResolution {
    private final IProject project;
    private final String libraryName;

    public RemoveLibraryFromDescriptorResolution(Shell shell, IProject project, String libraryName) {
        this.project = project;
        this.libraryName = libraryName;
    }

    public String getLabel() {
        if (WtpProjectUtil.isDynamicWebProject((IProject)this.project)) {
            return Resources.bind((String)Resources.labelForWeb, (Object)this.libraryName);
        }
        return Resources.bind((String)Resources.labelForEar, (Object)this.libraryName);
    }

    public void run(IMarker marker) {
        try {
            LibraryModulesSvc.removeFromDescriptor((IProject)this.project, (String)this.libraryName);
        }
        catch (EditFailedException editFailedException) {
        }
        catch (CoreException e) {
            DialogService.showErrorDialog((Throwable)e);
        }
    }

    private static final class Resources
    extends NLS {
        public static String labelForWeb;
        public static String labelForEar;

        static {
            Resources.initializeMessages((String)RemoveLibraryFromDescriptorResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

