/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.ClasspathAndDescriptorRefsDoNotMatchProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.IProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.MustBePartOfEarToUseLibProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.MustBePartOfWebAppToUseLibProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.NonWebLibRefInWebDescriptorProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.ProblemFactory;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.RefOnClasspathButNotInDescriptorProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.UnableToResolveLibraryProblem;
import oracle.eclipse.tools.weblogic.j2eelib.internal.validation.problems.WebLibRefInNonWebProjectProblem;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.AddLibraryToDescriptorResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.AddLibraryToRegistryResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.AddProjectToEarResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.AddProjectToWebAppResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.ModifyClasspathToMatchResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.ModifyDescriptorToMatchResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.ModifyLibraryRefInDescriptorResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.ModifyLibraryRefOnClasspathResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.RemoveLibraryFromClasspathResolution;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions.RemoveLibraryFromDescriptorResolution;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class ProblemResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] NO_RESOLUTION = new IMarkerResolution[0];

    public IMarkerResolution[] getResolutions(IMarker marker) {
        IMarkerResolution[] resolutions;
        IProblem problem = ProblemFactory.convertMarker((IMarker)marker);
        IProject project = problem.getProject();
        Shell shell = ProblemResolutionGenerator.findShell();
        if (shell == null) {
            resolutions = NO_RESOLUTION;
        } else if (problem instanceof UnableToResolveLibraryProblem) {
            UnableToResolveLibraryProblem p = (UnableToResolveLibraryProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = p.isClasspathProblem() ? new IMarkerResolution[]{new AddLibraryToRegistryResolution(shell, libref), new ModifyLibraryRefOnClasspathResolution(shell, project, libref), new RemoveLibraryFromClasspathResolution(shell, project, libref.getName())} : new IMarkerResolution[]{new AddLibraryToRegistryResolution(shell, libref), new ModifyLibraryRefInDescriptorResolution(shell, project, libref), new RemoveLibraryFromDescriptorResolution(shell, project, libref.getName())};
        } else if (problem instanceof RefOnClasspathButNotInDescriptorProblem) {
            RefOnClasspathButNotInDescriptorProblem p = (RefOnClasspathButNotInDescriptorProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = new IMarkerResolution[]{new AddLibraryToDescriptorResolution(shell, p.getDescriptorProject(), libref), new RemoveLibraryFromClasspathResolution(shell, project, libref.getName())};
        } else if (problem instanceof WebLibRefInNonWebProjectProblem) {
            WebLibRefInNonWebProjectProblem p = (WebLibRefInNonWebProjectProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = new IMarkerResolution[]{new RemoveLibraryFromClasspathResolution(shell, project, libref.getName())};
        } else if (problem instanceof NonWebLibRefInWebDescriptorProblem) {
            NonWebLibRefInWebDescriptorProblem p = (NonWebLibRefInWebDescriptorProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = new IMarkerResolution[]{new RemoveLibraryFromDescriptorResolution(shell, project, libref.getName())};
        } else if (problem instanceof MustBePartOfEarToUseLibProblem) {
            MustBePartOfEarToUseLibProblem p = (MustBePartOfEarToUseLibProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = new IMarkerResolution[]{new AddProjectToEarResolution(shell, project), new RemoveLibraryFromClasspathResolution(shell, project, libref.getName())};
        } else if (problem instanceof MustBePartOfWebAppToUseLibProblem) {
            MustBePartOfWebAppToUseLibProblem p = (MustBePartOfWebAppToUseLibProblem)problem;
            LibraryModuleRef libref = p.getLibraryModuleRef();
            resolutions = new IMarkerResolution[]{new AddProjectToWebAppResolution(shell, project), new RemoveLibraryFromClasspathResolution(shell, project, libref.getName())};
        } else if (problem instanceof ClasspathAndDescriptorRefsDoNotMatchProblem) {
            ClasspathAndDescriptorRefsDoNotMatchProblem p = (ClasspathAndDescriptorRefsDoNotMatchProblem)problem;
            IProject descProject = p.getDescriptorProject();
            LibraryModuleRef librefFromCp = p.getLibraryModuleRefFromClasspath();
            LibraryModuleRef librefFromDesc = p.getLibraryModuleRefFromDescriptor();
            resolutions = new IMarkerResolution[]{new ModifyClasspathToMatchResolution(shell, project, descProject, librefFromDesc), new ModifyDescriptorToMatchResolution(shell, project, descProject, librefFromCp)};
        } else {
            resolutions = NO_RESOLUTION;
        }
        return resolutions;
    }

    private static Shell findShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return window == null ? null : window.getShell();
    }
}

