/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.ui.j2eelib.SharedLibrariesFrameworkUi;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public final class ModifyLibraryRefOnClasspathResolution
implements IMarkerResolution {
    private final Shell shell;
    private final IProject project;
    private final LibraryModuleRef libraryReference;

    public ModifyLibraryRefOnClasspathResolution(Shell shell, IProject project, LibraryModuleRef libraryReference) {
        this.shell = shell;
        this.project = project;
        this.libraryReference = libraryReference;
    }

    public String getLabel() {
        return Resources.bind((String)Resources.label, (Object)this.libraryReference.getName());
    }

    public void run(IMarker marker) {
        LibraryModuleRef newLibraryReference = SharedLibrariesFrameworkUi.showEditLibraryRefDialog(this.shell, this.libraryReference, false);
        if (newLibraryReference != null && !newLibraryReference.equals((Object)this.libraryReference)) {
            try {
                LibraryModulesSvc.updateInClasspath((IProject)this.project, (String)this.libraryReference.getName(), (LibraryModuleRef)newLibraryReference);
            }
            catch (CoreException e) {
                DialogService.showErrorDialog((Throwable)e);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String label;

        static {
            Resources.initializeMessages((String)ModifyLibraryRefOnClasspathResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

