/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import oracle.eclipse.tools.common.ui.dialogs.CommonDialogs;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.resources.IProjectFilter;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;

public final class AddProjectToEarResolution
implements IMarkerResolution {
    private final Shell shell;
    private final IProject project;

    public AddProjectToEarResolution(Shell shell, IProject project) {
        this.shell = shell;
        this.project = project;
    }

    public String getLabel() {
        return Resources.label;
    }

    public void run(IMarker marker) {
        String dialogMessage = Resources.bind((String)Resources.dialogMessage, (Object)this.project.getName());
        IProject selectedEarProject = CommonDialogs.showSelectProjectDialog((Shell)this.shell, (IProjectFilter)WtpProjectUtil.createEarProjectFilter(), (String)Resources.dialogTitle, (String)dialogMessage);
        if (selectedEarProject != null) {
            try {
                WtpProjectUtil.addProjectToEar((IProject)selectedEarProject, (IProject)this.project);
            }
            catch (CoreException e) {
                DialogService.showErrorDialog((Throwable)e);
            }
        }
    }

    private static final class Resources
    extends NLS {
        public static String label;
        public static String dialogTitle;
        public static String dialogMessage;

        static {
            Resources.initializeMessages((String)AddProjectToEarResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

