/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib.internal.resolutions;

import java.util.Collections;
import java.util.Set;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeUtil;
import oracle.eclipse.tools.weblogic.facets.WlsEarFacet;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.modeling.EditFailedException;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentVersion;

public final class AddLibraryToDescriptorResolution
implements IMarkerResolution {
    private final IProject project;
    private final LibraryModuleRef libraryReference;

    public AddLibraryToDescriptorResolution(Shell shell, IProject project, LibraryModuleRef libraryReference) {
        this.project = project;
        this.libraryReference = libraryReference;
    }

    public String getLabel() {
        if (WtpProjectUtil.isDynamicWebProject((IProject)this.project)) {
            return Resources.bind((String)Resources.labelForWeb, (Object)this.libraryReference.getName());
        }
        return Resources.bind((String)Resources.labelForEar, (Object)this.libraryReference.getName(), (Object)this.project.getName());
    }

    public void run(IMarker marker) {
        try {
            block7: {
                IFacetedProject fproj;
                IProjectFacetVersion wlsEarFacetVersion;
                block9: {
                    block8: {
                        if (!WtpProjectUtil.isEarProject((IProject)this.project) || WlsEarFacet.isInstalled((IProject)this.project)) break block7;
                        String prompt = Resources.bind((String)Resources.installWlsEarFacetDialogMessage, (Object)this.project.getName());
                        if (!DialogService.showYesNoDialog((String)Resources.installWlsEarFacetDialogTitle, (String)prompt)) {
                            return;
                        }
                        wlsEarFacetVersion = null;
                        fproj = ProjectFacetsManager.create((IProject)this.project);
                        IRuntimeComponentVersion wlsVersion = WlsRuntimeUtil.getWlsRuntimeVersion((IProject)this.project);
                        if (wlsVersion == null) break block8;
                        String wlsVersionString = wlsVersion.getVersionString();
                        if (!WlsEarFacet.FACET.hasVersion(wlsVersionString) || AddLibraryToDescriptorResolution.isInstallable(fproj, wlsEarFacetVersion = WlsEarFacet.FACET.getVersion(wlsVersionString))) break block9;
                        wlsEarFacetVersion = null;
                        break block9;
                    }
                    for (IProjectFacetVersion fv : WlsEarFacet.FACET.getSortedVersions(true)) {
                        if (!AddLibraryToDescriptorResolution.isInstallable(fproj, fv)) continue;
                        wlsEarFacetVersion = fv;
                        break;
                    }
                }
                if (wlsEarFacetVersion != null) {
                    fproj.installProjectFacet(wlsEarFacetVersion, null, null);
                } else {
                    DialogService.showErrorDialog((String)Resources.unableToInstallWlsEarFacetDialogTitle, (String)Resources.unableToInstallWlsEarFacetDialogMessage);
                    return;
                }
            }
            LibraryModulesSvc.addToDescriptor((IProject)this.project, (LibraryModuleRef)this.libraryReference, (String[])new String[0]);
        }
        catch (EditFailedException editFailedException) {
        }
        catch (CoreException e) {
            DialogService.showErrorDialog((Throwable)e);
        }
    }

    private static boolean isInstallable(IFacetedProject fproj, IProjectFacetVersion fv) {
        IFacetedProject.Action action;
        Set<IFacetedProject.Action> actions;
        Set baseFacets = fproj.getProjectFacets();
        if (ProjectFacetsManager.check((Set)baseFacets, actions = Collections.singleton(action = new IFacetedProject.Action(IFacetedProject.Action.Type.INSTALL, fv, null))).getSeverity() == 4) {
            return false;
        }
        for (IRuntime runtime : fproj.getTargetedRuntimes()) {
            if (runtime.supports(fv)) continue;
            return false;
        }
        return true;
    }

    private static final class Resources
    extends NLS {
        public static String labelForWeb;
        public static String labelForEar;
        public static String installWlsEarFacetDialogTitle;
        public static String installWlsEarFacetDialogMessage;
        public static String unableToInstallWlsEarFacetDialogTitle;
        public static String unableToInstallWlsEarFacetDialogMessage;

        static {
            Resources.initializeMessages((String)AddLibraryToDescriptorResolution.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

