/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRef;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModuleConfigDialog;
import oracle.eclipse.tools.weblogic.ui.j2eelib.internal.LibraryModuleRefDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public final class SharedLibrariesFrameworkUi {
    public static final String[] BROWSE_FILTER_EXTENSIONS = new String[]{"*.ear;*.war;*.jar", "*.ear", "*.war", "*.jar"};
    public static final String[] BROWSE_FILTER_NAMES = new String[]{Resources.filterAllTypes, Resources.filterEarOnly, Resources.filterWarOnly, Resources.filterJarOnly};
    public static final String[] BROWSE_FILTER_EXTENSIONS_WEBONLY = new String[]{"*.war"};
    public static final String[] BROWSE_FILTER_NAMES_WEBONLY = new String[]{Resources.filterWarOnly};
    private static final String LAST_USED_DIRECTORY = "last.used.directory";

    public static File showFindArchiveDialog(Shell shell) {
        return SharedLibrariesFrameworkUi.showFindArchiveDialog(shell, false);
    }

    public static File showFindArchiveDialog(Shell shell, boolean webOnly) {
        Set<File> result = SharedLibrariesFrameworkUi.showFindArchivesDialog(shell, false, webOnly);
        if (result.size() == 0) {
            return null;
        }
        return result.iterator().next();
    }

    public static Set<File> showFindArchivesDialog(Shell shell) {
        return SharedLibrariesFrameworkUi.showFindArchivesDialog(shell, true, false);
    }

    public static Set<File> showFindArchivesDialog(Shell shell, boolean webOnly) {
        return SharedLibrariesFrameworkUi.showFindArchivesDialog(shell, true, webOnly);
    }

    private static Set<File> showFindArchivesDialog(Shell shell, boolean allowMultiSelect, boolean webOnly) {
        File f;
        int style = 0x8000 | (allowMultiSelect ? 2 : 0);
        FileDialog dialog = new FileDialog(shell, style);
        if (webOnly) {
            dialog.setFilterExtensions(BROWSE_FILTER_EXTENSIONS_WEBONLY);
            dialog.setFilterNames(BROWSE_FILTER_NAMES_WEBONLY);
        } else {
            dialog.setFilterExtensions(BROWSE_FILTER_EXTENSIONS);
            dialog.setFilterNames(BROWSE_FILTER_NAMES);
        }
        IDialogSettings settings = WlsUiPlugin.getDialogSettings(SharedLibrariesFrameworkUi.class);
        String lastUsedDirectory = settings.get(LAST_USED_DIRECTORY);
        if (lastUsedDirectory != null && (f = new File(lastUsedDirectory)).exists() && f.isDirectory()) {
            dialog.setFilterPath(lastUsedDirectory);
        }
        HashSet<File> results = new HashSet<File>();
        if (dialog.open() != null) {
            String dir = dialog.getFilterPath();
            String[] stringArray = dialog.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fname = stringArray[n2];
                results.add(new File(dir, fname));
                ++n2;
            }
            settings.put(LAST_USED_DIRECTORY, dir);
        }
        return results;
    }

    public static LibraryModuleRef showEditLibraryRefDialog(Shell shell, LibraryModuleRef libref, boolean webOnly) {
        LibraryModuleRefDialog.Mode mode = libref == null ? LibraryModuleRefDialog.Mode.ADD : LibraryModuleRefDialog.Mode.EDIT;
        LibraryModuleRefDialog dialog = new LibraryModuleRefDialog(shell, webOnly, mode);
        dialog.setLibraryModuleRef(libref);
        if (dialog.open() == 0) {
            return dialog.getLibraryModuleRef();
        }
        return null;
    }

    public static LibraryModule showAddLibraryDialog(Shell shell, boolean webOnly) {
        return SharedLibrariesFrameworkUi.showEditLibraryDialog(shell, null, webOnly);
    }

    public static LibraryModule showEditLibraryDialog(Shell shell, LibraryModule lib, boolean webOnly) {
        LibraryModuleConfigDialog dialog = new LibraryModuleConfigDialog(shell, webOnly);
        if (dialog.open() == 0) {
            return dialog.getLibraryModule();
        }
        return null;
    }

    private static final class Resources
    extends NLS {
        public static String filterAllTypes;
        public static String filterEarOnly;
        public static String filterWarOnly;
        public static String filterJarOnly;

        static {
            Resources.initializeMessages((String)SharedLibrariesFrameworkUi.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

