/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public final class LibrariesConfigurationPanel
extends Composite {
    private TreeViewer viewer;
    private LibrariesContentProvider contentProvider;
    private Menu popupMenu;
    private MenuItem editMenuItem;
    private MenuItem clearMenuItem;
    private List<Listener> listeners;

    public LibrariesConfigurationPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.setLayout((Layout)layout);
        this.viewer = new TreeViewer((Composite)this);
        this.viewer.getControl().setLayoutData((Object)SwtUtil.gdfill());
        this.contentProvider = new LibrariesContentProvider();
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LibrariesLabelProvider());
        this.viewer.setInput((Object)this);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LibrariesConfigurationPanel.this.invokeEditAction();
            }
        });
        this.viewer.getTree().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                LibrariesConfigurationPanel.this.handleMouseDownEvent(event);
            }
        });
        this.viewer.getTree().addListener(32, new Listener(){

            public void handleEvent(Event event) {
                LibrariesConfigurationPanel.this.handleMouseHoverEvent(event);
            }
        });
        this.viewer.getTree().setToolTipText("");
        this.popupMenu = new Menu((Decorations)this.getShell(), 8);
        this.editMenuItem = new MenuItem(this.popupMenu, 8);
        this.editMenuItem.setText(Resources.editMenuItem);
        this.editMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesConfigurationPanel.this.invokeEditAction();
            }
        });
        this.clearMenuItem = new MenuItem(this.popupMenu, 8);
        this.clearMenuItem.setText(Resources.clearMenuItem);
        this.clearMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LibrariesConfigurationPanel.this.invokeClearAction();
            }
        });
        this.listeners = new ArrayList<Listener>();
    }

    public List<LibraryDescription> getLibraries() {
        return this.contentProvider.getLibraries();
    }

    public void setLibraries(List<LibraryDescription> libraries) {
        this.contentProvider.setLibraries(libraries);
    }

    public void addLibrary(LibraryDescription library) {
        this.contentProvider.addLibrary(library);
    }

    public void removeLibrary(LibraryDescription library) {
        this.contentProvider.removeLibrary(library);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<Listener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        List<Listener> list = this.listeners;
        synchronized (list) {
            for (Listener listener : this.listeners) {
                listener.handleEvent(null);
            }
        }
    }

    public LibraryDescription getSelectedLibrary() {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        Object firstElement = selection.getFirstElement();
        if (firstElement != null && firstElement instanceof LibraryDescription) {
            return (LibraryDescription)firstElement;
        }
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.viewer.removeSelectionChangedListener(listener);
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.viewer.getSelection();
    }

    public boolean isEditActionAvailable() {
        Object selection = this.getSelection().getFirstElement();
        return selection instanceof SubElement;
    }

    public void invokeEditAction() {
        if (!this.isEditActionAvailable()) {
            return;
        }
        Object selection = this.getSelection().getFirstElement();
        SubElement element = (SubElement)selection;
        LibraryDescription library = element.getParent();
        if (element.getType() == 2) {
            IClasspathEntry cpe = JavaCore.newLibraryEntry((IPath)library.getLibraryLocation(), (IPath)library.getSourceLocation(), null);
            cpe = BuildPathDialogAccess.configureSourceAttachment((Shell)this.getShell(), (IClasspathEntry)cpe);
            if (cpe != null) {
                this.setSourceLocation(element, cpe.getSourceAttachmentPath());
            }
        } else {
            URL[] urls = BuildPathDialogAccess.configureJavadocLocation((Shell)this.getShell(), (String)library.getLibraryLocation().toOSString(), (URL)library.getJavadocLocation());
            if (urls != null) {
                this.setJavadocLocation(element, urls[0]);
            }
        }
    }

    public boolean isClearActionAvailable() {
        Object selection = this.getSelection().getFirstElement();
        boolean isAvailable = false;
        if (selection instanceof SubElement) {
            SubElement sub = (SubElement)selection;
            LibraryDescription lib = sub.getParent();
            isAvailable = sub.getType() == 2 ? lib.getSourceLocation() != null : lib.getJavadocLocation() != null;
        }
        return isAvailable;
    }

    public void invokeClearAction() {
        Object selection = this.getSelection().getFirstElement();
        if (!(selection instanceof SubElement)) {
            return;
        }
        SubElement element = (SubElement)selection;
        if (element.getType() == 2) {
            this.setSourceLocation(element, null);
        } else {
            this.setJavadocLocation(element, null);
        }
    }

    private void handleMouseDownEvent(Event event) {
        Object selection = this.getSelection().getFirstElement();
        if (selection != null && selection instanceof SubElement) {
            this.viewer.getTree().setMenu(this.popupMenu);
            this.clearMenuItem.setEnabled(this.isClearActionAvailable());
        } else {
            this.viewer.getTree().setMenu(null);
        }
    }

    private void handleMouseHoverEvent(Event event) {
        String toolTip = "";
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds().contains(event.x, event.y)) {
                Object itemData = item.getData();
                if (!(itemData instanceof LibraryDescription)) break;
                LibraryDescription lib = (LibraryDescription)itemData;
                toolTip = lib.getLibraryLocation().toOSString();
                break;
            }
            ++n2;
        }
        this.viewer.getTree().setToolTipText(toolTip);
    }

    private void setSourceLocation(SubElement sub, IPath sourceLocation) {
        LibraryDescription library = sub.getParent();
        library.setSourceLocation(sourceLocation);
        this.viewer.update((Object)sub, null);
        this.viewer.update((Object)library, null);
        this.notifyListeners();
    }

    private void setJavadocLocation(SubElement sub, URL javadocLocation) {
        LibraryDescription library = sub.getParent();
        library.setJavadocLocation(javadocLocation);
        this.viewer.update((Object)sub, null);
        this.viewer.update((Object)library, null);
        this.notifyListeners();
    }

    private static final class LibrariesContentProvider
    implements ITreeContentProvider {
        private TreeViewer viewer;
        private Map<LibraryDescription, SubElement[]> children = new HashMap<LibraryDescription, SubElement[]>();
        private final List<LibraryDescription> libraries = new ArrayList<LibraryDescription>();
        private final List<LibraryDescription> librariesReadOnly = Collections.unmodifiableList(this.libraries);

        private LibrariesContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.viewer = (TreeViewer)viewer;
        }

        public Object[] getElements(Object input) {
            return this.libraries.toArray(new LibraryDescription[this.libraries.size()]);
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof LibraryDescription) {
                LibraryDescription lib = (LibraryDescription)parent;
                Object[] children = this.children.get(lib);
                if (children == null) {
                    children = new SubElement[]{new SubElement(lib, 2), new SubElement(lib, 1)};
                    this.children.put(lib, (SubElement[])children);
                }
                return children;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof SubElement) {
                return ((SubElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof LibraryDescription;
        }

        public List<LibraryDescription> getLibraries() {
            return this.librariesReadOnly;
        }

        public void setLibraries(List<LibraryDescription> libraries) {
            this.libraries.clear();
            this.libraries.addAll(libraries);
            this.viewer.refresh();
        }

        public void addLibrary(LibraryDescription library) {
            this.libraries.add(library);
            this.viewer.refresh();
        }

        public void removeLibrary(LibraryDescription library) {
            if (this.libraries.remove(library)) {
                this.viewer.refresh();
            }
        }

        public void dispose() {
        }
    }

    private static final class LibrariesLabelProvider
    extends LabelProvider {
        private ImageDescriptorRegistry fRegistry = JavaPlugin.getImageDescriptorRegistry();

        private LibrariesLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof LibraryDescription) {
                LibraryDescription library = (LibraryDescription)element;
                boolean hasSource = library.getSourceLocation() != null;
                String key = hasSource ? "org.eclipse.jdt.ui.jar_lsrc_obj.gif" : "org.eclipse.jdt.ui.jar_l_obj.gif";
                return JavaUI.getSharedImages().getImage(key);
            }
            if (element instanceof SubElement) {
                SubElement sub = (SubElement)element;
                if (sub.getType() == 2) {
                    return this.fRegistry.get(JavaPluginImages.DESC_OBJS_SOURCE_ATTACH_ATTRIB);
                }
                return this.fRegistry.get(JavaPluginImages.DESC_OBJS_JAVADOC_LOCATION_ATTRIB);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof LibraryDescription) {
                LibraryDescription lib = (LibraryDescription)element;
                return lib.getRelativeLibraryLocation().lastSegment();
            }
            if (element instanceof SubElement) {
                SubElement sub = (SubElement)element;
                StringBuilder text = new StringBuilder();
                if (sub.getType() == 2) {
                    text.append(Resources.sourceLabel);
                    IPath source = sub.getParent().getSourceLocation();
                    if (source != null) {
                        text.append(source.toOSString());
                    } else {
                        text.append(Resources.none);
                    }
                } else {
                    text.append(Resources.javadocLabel);
                    URL javadoc = sub.getParent().getJavadocLocation();
                    if (javadoc != null) {
                        text.append(javadoc.toExternalForm());
                    } else {
                        text.append(Resources.none);
                    }
                }
                return text.toString();
            }
            return null;
        }
    }

    public static class LibraryDescription {
        private final IPath library;
        private final IPath relative;
        private IPath sourceLocation;
        private URL javadocLocation;

        public LibraryDescription(IPath library, IPath relative, IPath sourceLocation, URL javadocLocation) {
            this.library = library;
            this.relative = relative;
            this.setSourceLocation(sourceLocation);
            this.setJavadocLocation(javadocLocation);
        }

        public IPath getLibraryLocation() {
            return this.library;
        }

        public IPath getRelativeLibraryLocation() {
            return this.relative;
        }

        public IPath getSourceLocation() {
            return this.sourceLocation;
        }

        public void setSourceLocation(IPath sourceLocation) {
            this.sourceLocation = sourceLocation == null || sourceLocation.equals((Object)Path.EMPTY) ? null : sourceLocation;
        }

        public URL getJavadocLocation() {
            return this.javadocLocation;
        }

        public void setJavadocLocation(URL javadocLocation) {
            this.javadocLocation = javadocLocation;
        }
    }

    private static final class Resources
    extends NLS {
        public static String sourceLabel;
        public static String javadocLabel;
        public static String none;
        public static String editMenuItem;
        public static String clearMenuItem;

        static {
            Resources.initializeMessages((String)LibrariesConfigurationPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private static final class SubElement {
        public static final int JAVADOC_URL = 1;
        public static final int SOURCE_PATH = 2;
        private final LibraryDescription parent;
        private final int type;

        public SubElement(LibraryDescription parent, int type) {
            this.parent = parent;
            this.type = type;
        }

        public LibraryDescription getParent() {
            return this.parent;
        }

        public int getType() {
            return this.type;
        }
    }
}

