/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.j2eelib;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModule;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModuleRegistry;
import oracle.eclipse.tools.weblogic.j2eelib.LibraryModulesSvc;
import oracle.eclipse.tools.weblogic.j2eelib.Version;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import oracle.eclipse.tools.weblogic.ui.j2eelib.LibraryModuleConfigDialog;
import oracle.eclipse.tools.weblogic.ui.j2eelib.SharedLibrariesFrameworkUi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;

public final class BrowseLibraryModulesPanel
extends Composite {
    private final boolean allowEdits;
    private final boolean webOnly;
    private final TableViewer table;
    private final Button editButton;
    private final Button removeButton;
    private final Button reloadButton;
    private final LibraryModuleRegistry.IListener registryChangedListener;
    private final LibraryModuleRegistry registry = LibraryModulesSvc.getRegistry();

    public BrowseLibraryModulesPanel(Composite parent, int style, boolean allowEdits, boolean webOnly) {
        super(parent, style);
        this.allowEdits = allowEdits;
        this.webOnly = webOnly;
        this.setLayout((Layout)SwtUtil.glayout((int)(this.allowEdits ? 2 : 1), (int)0, (int)0));
        this.table = new TableViewer((Composite)this, 67586);
        this.table.getTable().setLayoutData((Object)SwtUtil.gdfill());
        this.table.getTable().setLinesVisible(true);
        TableSorter tableSorter = new TableSorter(this.table);
        this.table.setContentProvider((IContentProvider)new TableContentProvider());
        this.table.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.table.setSorter((ViewerSorter)tableSorter);
        TableColumn column = new TableColumn(this.table.getTable(), 0);
        column.setWidth(20);
        column.setResizable(false);
        column.addSelectionListener((SelectionListener)tableSorter);
        column = new TableColumn(this.table.getTable(), 16384);
        column.setText(Resources.nameColumnLabel);
        column.setWidth(this.computeNameColumnWidth());
        column.addSelectionListener((SelectionListener)tableSorter);
        column = new TableColumn(this.table.getTable(), 16384);
        column.setText(Resources.versionColumnLabel);
        column.setWidth(this.computeVersionColumnWidth());
        column.addSelectionListener((SelectionListener)tableSorter);
        this.table.getTable().setHeaderVisible(true);
        this.table.setInput((Object)5);
        this.registryChangedListener = new LibraryModuleRegistry.IListener(){

            public void registryChanged() {
                BrowseLibraryModulesPanel.this.handleRegistryChangedEvent();
            }
        };
        this.registry.addListener(this.registryChangedListener);
        DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                BrowseLibraryModulesPanel.this.handleDisposedEvent();
            }
        };
        this.addDisposeListener(disposeListener);
        if (this.allowEdits) {
            ISelectionChangedListener tableSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    BrowseLibraryModulesPanel.this.removeButton.setEnabled(!selection.isEmpty());
                    BrowseLibraryModulesPanel.this.editButton.setEnabled(selection.size() == 1);
                }
            };
            this.table.addSelectionChangedListener(tableSelectionListener);
            IDoubleClickListener tableDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    BrowseLibraryModulesPanel.this.performEdit();
                }
            };
            this.table.addDoubleClickListener(tableDoubleClickListener);
            Composite buttons = new Composite((Composite)this, 0);
            buttons.setLayoutData((Object)SwtUtil.gdvfill());
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttons.setLayout((Layout)layout);
            BrowseLibraryModulesPanel.createButton(buttons, Resources.addButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseLibraryModulesPanel.this.performAdd();
                }
            });
            BrowseLibraryModulesPanel.createButton(buttons, Resources.addMultipleButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseLibraryModulesPanel.this.performAddMultiple();
                }
            });
            this.editButton = BrowseLibraryModulesPanel.createButton(buttons, Resources.editButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseLibraryModulesPanel.this.performEdit();
                }
            });
            this.editButton.setEnabled(false);
            this.removeButton = BrowseLibraryModulesPanel.createButton(buttons, Resources.removeButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    BrowseLibraryModulesPanel.this.performRemove();
                }
            });
            this.removeButton.setEnabled(false);
            this.reloadButton = BrowseLibraryModulesPanel.createButton(buttons, Resources.reloadButtonLabel, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    WlsRuntimeSpy.refreshWlsRuntimes();
                }
            });
            this.reloadButton.setEnabled(true);
        } else {
            this.editButton = null;
            this.removeButton = null;
            this.reloadButton = null;
        }
    }

    public Set<LibraryModule> getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        HashSet<LibraryModule> res = new HashSet<LibraryModule>(selection.size());
        Iterator itr = selection.iterator();
        while (itr.hasNext()) {
            res.add((LibraryModule)itr.next());
        }
        return res;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.table.addSelectionChangedListener(listener);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.table.addDoubleClickListener(listener);
    }

    private static Button createButton(Composite parent, String label, SelectionListener listener) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.addSelectionListener(listener);
        GridData gd = SwtUtil.gdhfill();
        gd.verticalAlignment = 1;
        button.setLayoutData((Object)gd);
        return button;
    }

    private void performAdd() {
        LibraryModuleConfigDialog dialog = new LibraryModuleConfigDialog(this.getShell(), this.webOnly);
        dialog.open();
        final LibraryModule libmodule = dialog.getLibraryModule();
        if (libmodule != null) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Resources.addingTaskLabel, 1);
                    BrowseLibraryModulesPanel.this.getRegistry().add(libmodule);
                    monitor.done();
                }
            };
            this.runInProgressDialog(op);
        }
    }

    private void performAddMultiple() {
        final Set<File> selection = SharedLibrariesFrameworkUi.showFindArchivesDialog(this.getShell());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(Resources.addingTaskLabel, selection.size());
                for (File f : selection) {
                    String fname = f.getName();
                    monitor.subTask(fname);
                    try {
                        LibraryModulesSvc.registerLibraryModule((File)f);
                    }
                    catch (CoreException coreException) {
                        String msg = NLS.bind((String)Resources.invalidLibraryModule, (Object)fname);
                        DialogService.showErrorDialog((String)msg);
                    }
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        this.runInProgressDialog(op);
    }

    private void performEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        final LibraryModule oldlib = (LibraryModule)selection.iterator().next();
        LibraryModuleConfigDialog dialog = new LibraryModuleConfigDialog(this.getShell(), oldlib, this.webOnly);
        dialog.open();
        final LibraryModule newlib = dialog.getLibraryModule();
        if (newlib != null && !newlib.equals(oldlib)) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(Resources.updatingTaskLabel, 1);
                    BrowseLibraryModulesPanel.this.getRegistry().swap(oldlib, newlib);
                    StructuredSelection ssel = new StructuredSelection((Object)newlib);
                    BrowseLibraryModulesPanel.this.getTable().setSelection((ISelection)ssel);
                    monitor.done();
                }
            };
            this.runInProgressDialog(op);
        }
    }

    private TableViewer getTable() {
        return this.table;
    }

    private void performRemove() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                IStructuredSelection selection = (IStructuredSelection)BrowseLibraryModulesPanel.this.getTable().getSelection();
                monitor.beginTask(Resources.deletingTaskLabel, selection.size());
                for (LibraryModule libmodule : selection) {
                    monitor.subTask(libmodule.getName());
                    BrowseLibraryModulesPanel.this.getRegistry().remove(libmodule);
                    monitor.worked(1);
                }
                monitor.done();
            }
        };
        this.runInProgressDialog(op);
    }

    private void runInProgressDialog(IRunnableWithProgress op) {
        ProgressMonitorDialog prog = new ProgressMonitorDialog(this.getShell());
        try {
            prog.run(false, false, op);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void handleRegistryChangedEvent() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                TableViewer t = BrowseLibraryModulesPanel.this.getTable();
                if (!t.getTable().isDisposed()) {
                    BrowseLibraryModulesPanel.this.getTable().refresh();
                }
            }
        });
    }

    private void handleDisposedEvent() {
        this.registry.removeListener(this.registryChangedListener);
    }

    private LibraryModuleRegistry getRegistry() {
        return this.registry;
    }

    private int computeNameColumnWidth() {
        int columnLabelWidth;
        GC gc = new GC((Drawable)this.getDisplay());
        int maxLibNameWidth = 0;
        try {
            gc.setFont(this.table.getTable().getFont());
            LibraryModule[] libraryModuleArray = this.getRegistry().list();
            int n = libraryModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryModule lib = libraryModuleArray[n2];
                maxLibNameWidth = Math.max(maxLibNameWidth, gc.textExtent((String)lib.getName()).x);
                ++n2;
            }
            columnLabelWidth = gc.textExtent((String)Resources.nameColumnLabel).x;
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxLibNameWidth, columnLabelWidth) + 30;
    }

    private int computeVersionColumnWidth() {
        int columnLabelWidth;
        GC gc = new GC((Drawable)this.getDisplay());
        int maxLibVersionWidth = 0;
        try {
            gc.setFont(this.table.getTable().getFont());
            LibraryModule[] libraryModuleArray = this.getRegistry().list();
            int n = libraryModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                LibraryModule lib = libraryModuleArray[n2];
                String versionLabel = BrowseLibraryModulesPanel.createVersionLabel(lib);
                maxLibVersionWidth = Math.max(maxLibVersionWidth, gc.textExtent((String)versionLabel).x);
                ++n2;
            }
            columnLabelWidth = gc.textExtent((String)Resources.versionColumnLabel).x;
        }
        finally {
            gc.dispose();
        }
        return Math.max(maxLibVersionWidth, columnLabelWidth) + 30;
    }

    private static String createVersionLabel(LibraryModule lib) {
        StringBuilder label = new StringBuilder();
        if (lib.getSpecificationVersion() != null) {
            label.append(lib.getSpecificationVersion());
        }
        if (lib.getImplementationVersion() != null) {
            if (lib.getSpecificationVersion() != null) {
                label.append('/');
            }
            label.append(lib.getImplementationVersion());
        }
        return label.toString();
    }

    private static final class Resources
    extends NLS {
        public static String nameColumnLabel;
        public static String versionColumnLabel;
        public static String addButtonLabel;
        public static String addMultipleButtonLabel;
        public static String editButtonLabel;
        public static String removeButtonLabel;
        public static String reloadButtonLabel;
        public static String addingTaskLabel;
        public static String updatingTaskLabel;
        public static String deletingTaskLabel;
        public static String invalidLibraryModule;

        static {
            Resources.initializeMessages((String)BrowseLibraryModulesPanel.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    private final class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public Object[] getElements(Object element) {
            if (BrowseLibraryModulesPanel.this.webOnly) {
                ArrayList<LibraryModule> res = new ArrayList<LibraryModule>();
                LibraryModule[] libraryModuleArray = LibraryModulesSvc.getRegistry().list();
                int n = libraryModuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    LibraryModule libmod = libraryModuleArray[n2];
                    if (libmod.getType() == LibraryModule.Type.WAR) {
                        res.add(libmod);
                    }
                    ++n2;
                }
                return res.toArray();
            }
            return LibraryModulesSvc.getRegistry().list();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private static final class TableLabelProvider
    implements ITableLabelProvider {
        private final ImageRegistry images = WlsUiPlugin.getInstance().getImageRegistry();

        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int column) {
            LibraryModule libmodule = (LibraryModule)element;
            switch (column) {
                case 1: {
                    return libmodule.getName();
                }
                case 2: {
                    return BrowseLibraryModulesPanel.createVersionLabel(libmodule);
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int column) {
            if (column == 0) {
                LibraryModule libmodule = (LibraryModule)element;
                return this.images.get("j2eelib." + libmodule.getType().toString());
            }
            return null;
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }
    }

    private static final class TableSorter
    extends ViewerSorter
    implements SelectionListener {
        private final TableViewer table;
        private int sortColumn;
        private boolean sortDesc;

        public TableSorter(TableViewer table) {
            this.table = table;
            this.sortColumn = 1;
            this.sortDesc = false;
        }

        public int compare(Viewer viewer, Object obj1, Object obj2) {
            LibraryModule y;
            LibraryModule x;
            if (this.sortDesc) {
                x = (LibraryModule)obj2;
                y = (LibraryModule)obj1;
            } else {
                x = (LibraryModule)obj1;
                y = (LibraryModule)obj2;
            }
            switch (this.sortColumn) {
                case 0: {
                    int comp = x.getType().compareTo((Enum)y.getType());
                    if (comp != 0) {
                        return comp;
                    }
                }
                case 1: {
                    String n1 = x.getName().toLowerCase();
                    String n2 = y.getName().toLowerCase();
                    int comp = n1.compareTo(n2);
                    if (comp != 0) {
                        return comp;
                    }
                }
                case 2: {
                    Version spv1 = x.getSpecificationVersion();
                    Version spv2 = y.getSpecificationVersion();
                    int comp = this.compareOptionalVersions(spv1, spv2);
                    if (comp != 0) {
                        return comp;
                    }
                    Version implv1 = x.getImplementationVersion();
                    Version implv2 = y.getImplementationVersion();
                    return this.compareOptionalVersions(implv1, implv2);
                }
            }
            return 0;
        }

        private int compareOptionalVersions(Version x, Version y) {
            if (x == null) {
                if (y == null) {
                    return 0;
                }
                return -1;
            }
            if (y == null) {
                return 1;
            }
            return x.compareTo(y);
        }

        public void widgetSelected(SelectionEvent e) {
            int column = this.table.getTable().indexOf((TableColumn)e.widget);
            if (this.sortColumn == column) {
                this.sortDesc = !this.sortDesc;
            } else {
                this.sortColumn = column;
                this.sortDesc = false;
            }
            this.table.setSorter(null);
            this.table.setSorter((ViewerSorter)this);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

