/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.internal;

import oracle.eclipse.tools.common.ui.util.ProblemOverlayImageDescriptor;
import oracle.eclipse.tools.weblogic.WebLogicServerUtil;
import oracle.eclipse.tools.weblogic.WlsRuntimeSpy;
import oracle.eclipse.tools.weblogic.credential.WeblogicCredentialConfig;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerRuntime;
import oracle.eclipse.tools.weblogic.server.internal.util.ServerLaunchUtils;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.UpdateServerJob;

public final class WlsUiPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String PLUGIN_ID = "oracle.eclipse.tools.weblogic.ui";
    public static final String IMG_LOCATION_SHARED_LIB_EAR = "images/ear.gif";
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_EAR = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/ear.gif");
    public static final String IMG_SHARED_LIB_EAR = "j2eelib.ear";
    public static final String IMG_LOCATION_SHARED_LIB_EJB = "images/ejb.gif";
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_EJB = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/ejb.gif");
    public static final String IMG_SHARED_LIB_EJB = "j2eelib.ejb";
    public static final String IMG_LOCATION_SHARED_LIB_JAR = "images/jar.gif";
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_JAR = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/jar.gif");
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_JAR_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_SHARED_LIB_JAR, 4);
    public static final String IMG_SHARED_LIB_JAR = "j2eelib.jar";
    public static final String IMG_LOCATION_SHARED_LIB_WAR = "images/war.gif";
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_WAR = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/war.gif");
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_WAR_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_SHARED_LIB_WAR, 4);
    public static final String IMG_SHARED_LIB_WAR = "j2eelib.war";
    public static final String IMG_LOCATION_SHARED_LIB_ERROR = "images/lib-error.gif";
    public static final ImageDescriptor IMG_DESC_SHARED_LIB_ERROR = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/lib-error.gif");
    public static final String IMG_SHARED_LIB_ERROR = "shared.lib.error";
    public static final String IMG_SHARED_LIB_WIZBAN = "j2eelib.wizban";
    private static final String IMG_LOCATION_SHARED_LIB_WIZBAN = "images/container_wizban.gif";
    public static final String IMG_SHARED_LIB_NEWER_VERSIONS_OK = "j2eelib.newer.versions.ok";
    public static final String IMG_SHARED_LIB_NEWER_VERSIONS_NOT_OK = "j2eelib.newer.versions.not.ok";
    private static final String IMG_LOCATION_CLASSLOADER = "images/classloader-16.png";
    public static final ImageDescriptor IMG_DESC_CLASSLOADER = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/classloader-16.png");
    public static final ImageDescriptor IMG_DESC_CLASSLOADER_WITH_ERROR = new ProblemOverlayImageDescriptor(IMG_DESC_CLASSLOADER, 4);
    public static final String IMG_EAR = "ear";
    private static final String IMG_LOCATION_EAR = "images/ear.gif";
    public static final String IMG_WAR = "war";
    private static final String IMG_LOCATION_WAR = "images/war.gif";
    public static final String IMG_LOCATION_FORMS_EDITOR_ADD_CLASS_LOADER = "images/forms-editor-add-class-loader.png";
    public static final ImageDescriptor IMG_DESC_FORMS_EDITOR_ADD_CLASS_LOADER = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/forms-editor-add-class-loader.png");
    public static final String IMG_LOCATION_FORMS_EDITOR_ADD_MODULE = "images/forms-editor-add-module.png";
    public static final ImageDescriptor IMG_DESC_FORMS_EDITOR_ADD_MODULE = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/forms-editor-add-module.png");
    public static final ImageDescriptor IMG_DESC_DATABASE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/database.png");
    public static final ImageDescriptor IMG_DESC_EJB_ENTITY_BEAN = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-entity-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_ENTITY_BEAN_WIZ = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-entity-wiz-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_ENTITY_BEAN_WIZ_PAGE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-entity-wiz.gif");
    public static final ImageDescriptor IMG_DESC_EJB_SESSION_BEAN = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-session-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_SESSION_BEAN_WIZ = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-session-wiz-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_SESSION_BEAN_WIZ_PAGE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-session-wiz.gif");
    public static final ImageDescriptor IMG_DESC_EJB_MESSAGE_BEAN = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-message-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_MESSAGE_BEAN_WIZ = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-message-wiz-16.gif");
    public static final ImageDescriptor IMG_DESC_EJB_MESSAGE_BEAN_WIZ_PAGE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-message-wiz.gif");
    public static final ImageDescriptor IMG_DESC_EJB_PROJECT_LABEL_DECORATOR = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/ejb-icon-16.gif");
    public static final ImageDescriptor IMG_DESC_DEPLOY_PLAN_WIZ_PAGE = WlsUiPlugin.imageDescriptorFromPluginClassloader("images/descriptors/deployment-plan-wizard-banner.png");
    public static final ImageDescriptor DESC_VALIDATE_DEPLOY_PLAN = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/validate-deploy-plan.png");
    public static final ImageDescriptor IMG_DESC_REFRESH = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/refresh.gif");
    public static final ImageDescriptor IMG_DESC_BROWSE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/browse.png");
    public static final ImageDescriptor IMG_DESC_CREATE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/create.png");
    public static final ImageDescriptor IMG_DESC_MBEAN_HIERARCHY = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/mbean-hierarchy.png");
    public static final ImageDescriptor IMG_DESC_DOMAIN_EXTENSIONS = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/domain-extensions.png");
    public static final ImageDescriptor IMG_DESC_DOMAIN_EXTENSION = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/domain-extension.png");
    public static final ImageDescriptor IMG_DESC_PUBLISHED_MODULES = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/published-modules.png");
    public static final ImageDescriptor IMG_DESC_WEB_MODULE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/WebModule.png");
    public static final ImageDescriptor IMG_DESC_WEB_MODULE_INACTIVE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/WebModuleInactive.png");
    public static final ImageDescriptor IMG_DESC_EAR_MODULE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/ApplicationModule.png");
    public static final ImageDescriptor IMG_DESC_EAR_MODULE_INACTIVE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/ApplicationModuleInactive.png");
    public static final ImageDescriptor IMG_DESC_EJB_MODULE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/EjbModule.png");
    public static final ImageDescriptor IMG_DESC_EJB_MODULE_INACTIVE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/EjbModuleInactive.png");
    public static final ImageDescriptor IMG_DESC_GAR_MODULE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/coherence-module.png");
    public static final ImageDescriptor IMG_DESC_ADMIN_SERVER = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/server.gif");
    public static final ImageDescriptor IMG_DESC_MANAGED_SERVER = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/server.gif");
    public static final ImageDescriptor IMG_DESC_CLUSTER = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/obj16/server.gif");
    public static final ImageDescriptor IMG_DESC_WEB_SERVICE = WlsUiPlugin.imageDescriptorFromPluginClassloader("icons/web_service.gif");
    private static WlsUiPlugin instance;

    public WlsUiPlugin() {
        instance = this;
    }

    public static WlsUiPlugin getInstance() {
        return instance;
    }

    public static IDialogSettings getDialogSettings(Class cl) {
        IDialogSettings settings = WlsUiPlugin.getInstance().getDialogSettings();
        IDialogSettings node = settings.getSection(cl.getName());
        if (node == null) {
            node = settings.addNewSection(cl.getName());
        }
        return node;
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        imageRegistry.put(IMG_SHARED_LIB_EAR, WlsUiPlugin.createImageDescriptor("images/ear.gif"));
        imageRegistry.put(IMG_SHARED_LIB_EJB, WlsUiPlugin.createImageDescriptor(IMG_LOCATION_SHARED_LIB_EJB));
        imageRegistry.put(IMG_SHARED_LIB_JAR, WlsUiPlugin.createImageDescriptor(IMG_LOCATION_SHARED_LIB_JAR));
        imageRegistry.put(IMG_SHARED_LIB_WAR, WlsUiPlugin.createImageDescriptor("images/war.gif"));
        imageRegistry.put(IMG_SHARED_LIB_ERROR, WlsUiPlugin.createImageDescriptor(IMG_LOCATION_SHARED_LIB_ERROR));
        imageRegistry.put(IMG_SHARED_LIB_WIZBAN, WlsUiPlugin.createImageDescriptor(IMG_LOCATION_SHARED_LIB_WIZBAN));
        imageRegistry.put(IMG_EAR, WlsUiPlugin.createImageDescriptor("images/ear.gif"));
        imageRegistry.put(IMG_WAR, WlsUiPlugin.createImageDescriptor("images/war.gif"));
        imageRegistry.put(IMG_SHARED_LIB_NEWER_VERSIONS_OK, WlsUiPlugin.createImageDescriptor("images/newer-versions-allowed.gif"));
        imageRegistry.put(IMG_SHARED_LIB_NEWER_VERSIONS_NOT_OK, WlsUiPlugin.createImageDescriptor("images/newer-versions-not-allowed.gif"));
    }

    private static ImageDescriptor createImageDescriptor(String path) {
        return WlsUiPlugin.imageDescriptorFromPluginClassloader(path);
    }

    private static ImageDescriptor imageDescriptorFromPluginClassloader(String path) {
        ImageDescriptor imageDescriptor = SwtUtil.createImageDescriptor(WlsUiPlugin.class, (String)path);
        return imageDescriptor;
    }

    public static void logException(Exception e) {
        WlsUiPlugin.log(e);
    }

    public static void log(Exception e) {
        String msg = String.valueOf(e.getMessage());
        WlsUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, (Throwable)e));
    }

    public static void log(IStatus status) {
        WlsUiPlugin.getInstance().getLog().log(status);
    }

    public static void log(String msg) {
        WlsUiPlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static IStatus createErrorStatus(String msg) {
        return WlsUiPlugin.createErrorStatus(msg, null);
    }

    public static IStatus createErrorStatus(Exception e) {
        return WlsUiPlugin.createErrorStatus(e.getMessage(), e);
    }

    public static IStatus createErrorStatus(String msg, Exception e) {
        return new Status(4, PLUGIN_ID, 0, msg, (Throwable)e);
    }

    public void earlyStartup() {
        ServerLaunchUtils.updateWlsServerState();
        IServerLifecycleListener serverLifecycleListener = new IServerLifecycleListener(){

            public void serverAdded(IServer server) {
                if (WebLogicServerUtil.isWebLogicServer((IServer)server) && server.getServerState() == 0) {
                    UpdateServerJob job = new UpdateServerJob(new IServer[]{server});
                    job.schedule();
                }
            }

            public void serverChanged(IServer server) {
            }

            public void serverRemoved(IServer server) {
            }
        };
        ResourceManager.getInstance().addServerLifecycleListener(serverLifecycleListener);
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new IRuntimeLifecycleListener(){

            public void runtimeRemoved(IRuntime runtime) {
                WlsUiPlugin.this.updateTrustStorePreference(runtime, true);
            }

            public void runtimeChanged(IRuntime runtime) {
            }

            public void runtimeAdded(IRuntime runtime) {
                WlsUiPlugin.this.updateTrustStorePreference(runtime, false);
            }
        });
        WorkspaceJob refreshLibraryModuleRegistry = new WorkspaceJob("Refresh WebLogic Library Module Registry "){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                WlsRuntimeSpy.refreshWlsRuntimes();
                return Status.OK_STATUS;
            }
        };
        refreshLibraryModuleRegistry.schedule();
    }

    private void updateTrustStorePreference(final IRuntime runtime, final boolean remove) {
        if (runtime.getAdapter(WeblogicServerRuntime.class) == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                WeblogicCredentialConfig.updateWeblogicDemoTrustStorePreference((IRuntime)runtime, (boolean)remove);
            }
        });
    }
}

