/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.internal;

import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.eclipse.tools.common.ui.dialogs.DialogService;
import oracle.eclipse.tools.jaxrs.descriptors.JAXRSWebXml;
import oracle.eclipse.tools.jaxrs.launcher.JaxrsResource;
import oracle.eclipse.tools.jaxrs.launcher.Messages;
import oracle.eclipse.tools.weblogic.server.IWeblogicServer;
import oracle.eclipse.tools.weblogic.server.ServerInfo;
import oracle.eclipse.tools.weblogic.server.internal.WeblogicServerLaunchableAdapterDelegate;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.model.LaunchableAdapterDelegate;
import org.eclipse.wst.server.core.util.HttpLaunchable;

public final class JaxrsWebLogicLaunchableAdapter
extends LaunchableAdapterDelegate {
    private static final String HTTPS_PROTOCOL = "https";
    private static final String HTTP_PROTOCOL = "http";
    private boolean useHttpsProtocol = false;
    private List<WeakReference<IModuleArtifact>> notifiedArtifacts = null;

    public Object getLaunchable(IServer server, IModuleArtifact moduleArtifact) throws CoreException {
        if (moduleArtifact instanceof JaxrsResource) {
            JaxrsResource jaxrsResource;
            block9: {
                jaxrsResource = (JaxrsResource)moduleArtifact;
                try {
                    if (jaxrsResource.getCompilationUnit().getTypes() != null && jaxrsResource.getCompilationUnit().getTypes().length != 0) break block9;
                    return null;
                }
                catch (JavaModelException e) {
                    WlsUiPlugin.logException((Exception)((Object)e));
                    return null;
                }
            }
            IType type = jaxrsResource.getCompilationUnit().getTypes()[0];
            boolean isIface = type.isInterface();
            boolean isAbstract = Flags.isAbstract((int)type.getFlags());
            if ((isIface || isAbstract) && !this.notifiedForModuleArtifact(moduleArtifact)) {
                String reason = isIface ? Messages.launchable_adapter_is_interface : Messages.launchable_adapter_is_abstract;
                DialogService.showInfoDialog((String)Messages.launchable_adapter_not_runnable_title, (String)Messages.bind((String)Messages.launchable_adapter_not_runnable_msg, (Object)reason));
            }
            Object launchableObj = new WeblogicServerLaunchableAdapterDelegate().getLaunchable(server, moduleArtifact);
            if (launchableObj instanceof HttpLaunchable) {
                HttpLaunchable launchable = (HttpLaunchable)launchableObj;
                try {
                    URL launchURL = this.forWADL(jaxrsResource.getModule().getProject(), this.wlsFromIServer(server), launchable.getURL(), true, this.useHttpsProtocol);
                    return new HttpLaunchable(launchURL);
                }
                catch (UnsupportedEncodingException e) {
                    WlsUiPlugin.logException(e);
                }
                catch (MalformedURLException e) {
                    WlsUiPlugin.logException(e);
                }
            }
        }
        return null;
    }

    private URL forWADL(IProject project, IWeblogicServer wlsServer, URL url, boolean includeWadl, boolean useHttpsProtocol) throws UnsupportedEncodingException, MalformedURLException {
        int httpsPort = 7002;
        ServerInfo info = null;
        if (wlsServer != null && (info = wlsServer.getServerInfo()) != null && (httpsPort = info.getHttpsPort()) == -1) {
            httpsPort = 7002;
        }
        String file = "";
        if (url != null) {
            if (useHttpsProtocol) {
                url = new URL(HTTPS_PROTOCOL, url.getHost(), httpsPort, url.getFile());
            }
            if (includeWadl) {
                JAXRSWebXml webXml = new JAXRSWebXml();
                String contextRoot = webXml.findContextRoot(project);
                if (contextRoot == null) {
                    contextRoot = "/";
                }
                file = String.valueOf(url.getPath()) + contextRoot + "application.wadl";
            }
            if (useHttpsProtocol) {
                return new URL(HTTPS_PROTOCOL, url.getHost(), httpsPort, file);
            }
            return new URL(url.getProtocol(), url.getHost(), url.getPort(), file);
        }
        if (info != null) {
            if (useHttpsProtocol) {
                return new URL(HTTPS_PROTOCOL, info.getHostName(), httpsPort, file);
            }
            return new URL(HTTP_PROTOCOL, info.getHostName(), info.getPortNumber(), file);
        }
        return null;
    }

    private IWeblogicServer wlsFromIServer(IServer server) {
        if (server == null) {
            return null;
        }
        if (server instanceof IWeblogicServer) {
            return (IWeblogicServer)server;
        }
        IWeblogicServer wlServer = null;
        Object adapter = server.getAdapter(IWeblogicServer.class);
        if (adapter != null && adapter instanceof IWeblogicServer) {
            wlServer = (IWeblogicServer)adapter;
        } else {
            adapter = server.loadAdapter(IWeblogicServer.class, null);
            if (adapter != null && adapter instanceof IWeblogicServer) {
                wlServer = (IWeblogicServer)adapter;
            }
        }
        return wlServer;
    }

    private boolean notifiedForModuleArtifact(IModuleArtifact artifact) {
        boolean notified = false;
        if (this.notifiedArtifacts == null) {
            this.notifiedArtifacts = new ArrayList<WeakReference<IModuleArtifact>>();
        }
        Iterator<WeakReference<IModuleArtifact>> iter = this.notifiedArtifacts.iterator();
        while (iter.hasNext()) {
            WeakReference<IModuleArtifact> ref = iter.next();
            if (ref.get() == null) {
                iter.remove();
                continue;
            }
            if (ref.get() != artifact) continue;
            notified = true;
        }
        if (!notified) {
            this.notifiedArtifacts.add(new WeakReference<IModuleArtifact>(artifact));
        }
        return notified;
    }
}

