/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ejb.wizards;

import java.util.Set;
import oracle.eclipse.tools.common.util.wtp.WtpProjectUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.ui.AbstractFacetWizardPage;

public final class EJBGenFacetInstallPage
extends AbstractFacetWizardPage {
    private IDataModel ejbFacetDataModel;
    private IDataModelListener ejbFacetDataModelListener;
    private Composite composite;

    public EJBGenFacetInstallPage() {
        super("ejbgen.facet.install.page");
        this.setTitle(Resources.pageTitle);
        this.setDescription(Resources.pageDescription);
    }

    public void setConfig(Object config) {
    }

    public boolean isPageComplete() {
        EJBArtifactEdit ejbEdit;
        IVirtualComponent comp;
        IProject project;
        String projectName;
        if (this.ejbFacetDataModel == null && (projectName = this.context.getProjectName()) != null && projectName.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)).exists() && WtpProjectUtil.isEJBProject((IProject)project) && (comp = (ejbEdit = new EJBArtifactEdit(project, true, false)).getEJBClientJarModule()) != null) {
            this.setErrorMessage(Resources.bind((String)Resources.existingEjbClientProject, (Object[])new String[]{comp.getProject().getName()}));
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        this.composite.setFont(parent.getFont());
        Label label = new Label(this.composite, 64);
        label.setText(Resources.pageText);
        this.setControl((Control)this.composite);
        Set actions = this.context.getActions();
        for (Object o : actions) {
            String facetId;
            IFacetedProject.Action action = (IFacetedProject.Action)o;
            if (!action.getType().equals(IFacetedProject.Action.Type.INSTALL) || !(facetId = action.getProjectFacetVersion().getProjectFacet().getId()).equals("jst.ejb")) continue;
            this.ejbFacetDataModel = (IDataModel)action.getConfig();
            this.ejbFacetDataModelListener = new IDataModelListener(){

                public void propertyChanged(DataModelEvent event) {
                    if (event.getPropertyName().equals("IEjbFacetInstallDataModelProperties.CREATE_CLIENT")) {
                        EJBGenFacetInstallPage.this.updateCreateClient();
                    }
                }
            };
            this.ejbFacetDataModel.addListener(this.ejbFacetDataModelListener);
        }
        this.updateCreateClient();
    }

    public void setWizard(IWizard wizard) {
        super.setWizard(wizard);
        if (this.ejbFacetDataModel != null && wizard == null) {
            this.ejbFacetDataModel.removeListener(this.ejbFacetDataModelListener);
        }
    }

    private void updateCreateClient() {
        if (this.ejbFacetDataModel != null && this.ejbFacetDataModel.getBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT")) {
            this.ejbFacetDataModel.setBooleanProperty("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", false);
        }
    }

    private static final class Resources
    extends NLS {
        public static String pageTitle;
        public static String pageDescription;
        public static String pageText;
        public static String existingEjbClientProject;

        static {
            Resources.initializeMessages((String)EJBGenFacetInstallPage.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

