/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal.jms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.eclipse.tools.weblogic.descriptors.jms.IMessageLoggingFormatPart;
import oracle.eclipse.tools.weblogic.internal.WlsCorePlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionHandler;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.AbstractSlushBucketPropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.GridLayoutUtil;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtUtil;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class MessageLoggingFormatPropertyEditor
extends AbstractSlushBucketPropertyEditorPresentation {
    private TreeViewer sourceTreeViewer;
    private Tree sourceTree;
    private MoveRightActionHandler moveRightActionHandler;
    private ElementType memberType = this.property().definition().getType();
    private ValueProperty memberProperty = (ValueProperty)this.memberType.properties().first();
    private List<Format> formats;

    public MessageLoggingFormatPropertyEditor(PropertyEditorPart part, SwtPresentation parent, Composite composite, Format[] formats) {
        this(part, parent, composite);
        this.formats = ListFactory.start().add((Object[])formats).result();
    }

    public MessageLoggingFormatPropertyEditor(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
        super((FormComponentPart)part, parent, composite);
    }

    protected Control createSourceControl(Composite parent) {
        this.sourceTreeViewer = new TreeViewer(parent, 2050);
        this.sourceTree = this.sourceTreeViewer.getTree();
        this.sourceTree.setLayoutData((Object)GridLayoutUtil.gdfill());
        this.sourceTreeViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.sourceTreeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.sourceTreeViewer.setInput((Object)this);
        this.sourceTreeViewer.expandAll();
        this.sourceTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent event) {
                MessageLoggingFormatPropertyEditor.this.handleSourceTreeDoubleClickEvent(event);
            }
        });
        this.sourceTree.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event) {
                MessageLoggingFormatPropertyEditor.this.handleSourceTreeFocusGainedEvent();
            }
        });
        this.sourceTree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\r') {
                    MessageLoggingFormatPropertyEditor.this.handleSourceTreeEnterKeyPressEvent();
                }
            }
        });
        return this.sourceTree;
    }

    protected SapphireActionHandler createMoveRightActionHandler() {
        this.moveRightActionHandler = new MoveRightActionHandler();
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ArrayList<Object> input = new ArrayList<Object>();
                Iterator itr = ((IStructuredSelection)event.getSelection()).iterator();
                while (itr.hasNext()) {
                    input.add(itr.next());
                }
                MessageLoggingFormatPropertyEditor.this.moveRightActionHandler.setInput(input);
            }
        };
        this.sourceTreeViewer.addSelectionChangedListener(listener);
        return this.moveRightActionHandler;
    }

    protected void handlePropertyChangedEvent() {
        super.handlePropertyChangedEvent();
        this.sourceTreeViewer.refresh();
        this.moveRightActionHandler.refreshEnablementState();
    }

    protected void handleChildPropertyEvent(PropertyContentEvent event) {
        super.handleChildPropertyEvent(event);
        this.sourceTreeViewer.refresh();
        this.moveRightActionHandler.refreshEnablementState();
    }

    protected void handleTableFocusGainedEvent() {
        super.handleTableFocusGainedEvent();
        this.sourceTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
    }

    private void handleSourceTreeDoubleClickEvent(MouseEvent event) {
        Object doubleClickedItem = MessageLoggingFormatPropertyEditor.findTreeItem(this.sourceTree.getItems(), event.x, event.y);
        if (doubleClickedItem != null) {
            this.moveRightActionHandler.setInput(Collections.singleton(doubleClickedItem));
            this.moveRightActionHandler.execute((Presentation)this);
        }
    }

    private void handleSourceTreeFocusGainedEvent() {
        this.setSelectedElements(Collections.emptyList());
        if (this.sourceTreeViewer.getSelection().isEmpty() && this.sourceTree.getItemCount() > 0) {
            Object firstItem = this.sourceTree.getItem(0).getData();
            this.sourceTreeViewer.setSelection((ISelection)new StructuredSelection(firstItem));
        }
    }

    private void handleSourceTreeEnterKeyPressEvent() {
        if (!this.sourceTreeViewer.getSelection().isEmpty()) {
            this.moveRightActionHandler.execute((Presentation)this);
        }
    }

    private static Object findTreeItem(TreeItem[] items, int x, int y) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getBounds().contains(x, y)) {
                return item.getData();
            }
            Object res = MessageLoggingFormatPropertyEditor.findTreeItem(item.getItems(), x, y);
            if (res != null) {
                return res;
            }
            ++n2;
        }
        return null;
    }

    private static boolean collectionContains(Collection<String> collection, String str) {
        for (String s : collection) {
            if (!s.equalsIgnoreCase(str)) continue;
            return true;
        }
        return false;
    }

    private class ContentProvider
    implements ITreeContentProvider {
        private ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Format) {
                ElementList list = MessageLoggingFormatPropertyEditor.this.list();
                HashSet<String> valuesToRemove = new HashSet<String>();
                for (Element member : list) {
                    String str = member.property(MessageLoggingFormatPropertyEditor.this.memberProperty).text();
                    if (str == null) continue;
                    valuesToRemove.add(str);
                }
                ArrayList<String> children = new ArrayList<String>();
                String[] stringArray = ((Format)parentElement).getSubFormat();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (!valuesToRemove.contains(str)) {
                        children.add(str);
                    }
                    ++n2;
                }
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof String) {
                for (Format format : MessageLoggingFormatPropertyEditor.this.formats) {
                    if (!format.contains((String)element)) continue;
                    return format;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Format) {
                String[] subFormat = ((Format)element).getSubFormat();
                return subFormat != null && subFormat.length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ElementList list = MessageLoggingFormatPropertyEditor.this.list();
            HashSet<String> valuesToRemove = new HashSet<String>();
            for (Element member : list) {
                String str = member.property(MessageLoggingFormatPropertyEditor.this.memberProperty).text();
                if (str == null || !str.startsWith("%")) continue;
                valuesToRemove.add(str);
            }
            ArrayList<Format> formatList = new ArrayList<Format>();
            for (Format format : MessageLoggingFormatPropertyEditor.this.formats) {
                if (MessageLoggingFormatPropertyEditor.collectionContains(valuesToRemove, format.getText())) continue;
                formatList.add(format);
            }
            return formatList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    public static final class ExpirationLoggingPolicyFactory
    extends PropertyEditorPresentationFactory {
        private static final Format[] FORMATS = new Format[]{new Format("%header%", Resources.allHeaderNodeLabel, IMessageLoggingFormatPart.SYSTEM_HEADERS), new Format("%properties%", Resources.allPropertiesNodeLabel, IMessageLoggingFormatPart.SYSTEM_PROPERTIES)};

        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new MessageLoggingFormatPropertyEditor(part, parent, composite, FORMATS);
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        private static final Format[] FORMATS = new Format[]{new Format("%body%", Resources.allBodyNodeLabel), new Format("%header%", Resources.allHeaderNodeLabel, IMessageLoggingFormatPart.SYSTEM_HEADERS), new Format("%properties%", Resources.allPropertiesNodeLabel, IMessageLoggingFormatPart.SYSTEM_PROPERTIES)};

        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new MessageLoggingFormatPropertyEditor(part, parent, composite, FORMATS);
        }
    }

    private static class Format {
        private String text;
        private String label;
        private String[] subFormat;

        public Format(String text, String label) {
            this(text, label, Collections.emptySet());
        }

        public Format(String text, String label, Set<String> subFormat) {
            this.text = text;
            this.label = label;
            this.subFormat = subFormat.toArray(new String[subFormat.size()]);
        }

        public String getText() {
            return this.text;
        }

        public String getLabel() {
            return this.label;
        }

        public String[] getSubFormat() {
            return this.subFormat;
        }

        public List<String> getSubFormatCollection() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.subFormat != null) {
                String[] stringArray = this.subFormat;
                int n = this.subFormat.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    list.add(str);
                    ++n2;
                }
            }
            return list;
        }

        public boolean contains(String value) {
            if (this.subFormat != null) {
                String[] stringArray = this.subFormat;
                int n = this.subFormat.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    if (str.equals(value)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    private static class LabelProvider
    implements ILabelProvider {
        private final Image imgBody;
        private final Image imgHeader;
        private final Image imgProperty;
        private final Image imgPropertyCustom;

        public LabelProvider() {
            ImageDescriptor desc = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"images/descriptors/jms/message-body.png");
            this.imgBody = desc.createImage();
            desc = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"images/descriptors/jms/message-header.png");
            this.imgHeader = desc.createImage();
            desc = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"images/descriptors/jms/message-property.png");
            this.imgProperty = desc.createImage();
            desc = SwtUtil.createImageDescriptor(WlsCorePlugin.class, (String)"images/descriptors/jms/message-custom-property.png");
            this.imgPropertyCustom = desc.createImage();
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            String item = element instanceof Format ? ((Format)element).getText() : (String)element;
            if ("%body%".equals(item)) {
                return this.imgBody;
            }
            if ("%header%".equals(item) || IMessageLoggingFormatPart.SYSTEM_HEADERS.contains(item)) {
                return this.imgHeader;
            }
            if ("%properties%".equals(item) || IMessageLoggingFormatPart.SYSTEM_PROPERTIES.contains(item)) {
                return this.imgProperty;
            }
            return this.imgPropertyCustom;
        }

        public void dispose() {
            this.imgBody.dispose();
            this.imgHeader.dispose();
            this.imgProperty.dispose();
            this.imgPropertyCustom.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class MoveRightActionHandler
    extends SapphireActionHandler {
        private Collection<Object> input = Collections.emptyList();

        private MoveRightActionHandler() {
        }

        public void setInput(Collection<Object> input) {
            this.input = input;
            this.refreshEnablementState();
        }

        public void refreshEnablementState() {
            ElementList list = MessageLoggingFormatPropertyEditor.this.list();
            boolean enabled = false;
            if (list != null) {
                enabled = !this.input.isEmpty();
            }
            this.setEnabled(enabled);
        }

        protected Object run(Presentation context) {
            ElementList list = MessageLoggingFormatPropertyEditor.this.list();
            if (list != null) {
                HashSet<String> valuesToRemove = new HashSet<String>();
                HashSet<String> valuesToAdd = new HashSet<String>();
                for (Object obj : this.input) {
                    if (obj instanceof Format) {
                        Format format = (Format)obj;
                        Element entry = list.insert();
                        entry.property(MessageLoggingFormatPropertyEditor.this.memberProperty).write((Object)format.getText());
                        valuesToRemove.addAll(format.getSubFormatCollection());
                        continue;
                    }
                    valuesToAdd.add((String)obj);
                }
                for (String str : valuesToAdd) {
                    if (valuesToRemove.contains(str)) continue;
                    Element entry = list.insert();
                    entry.property(MessageLoggingFormatPropertyEditor.this.memberProperty).write((Object)str);
                }
                for (Element member : list) {
                    String str = member.property(MessageLoggingFormatPropertyEditor.this.memberProperty).text();
                    if (!valuesToRemove.contains(str)) continue;
                    list.remove((Object)member);
                }
            }
            return null;
        }
    }

    private static final class Resources
    extends NLS {
        public static String allBodyNodeLabel;
        public static String allHeaderNodeLabel;
        public static String allPropertiesNodeLabel;

        static {
            Resources.initializeMessages((String)MessageLoggingFormatPropertyEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

