/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal.dynamic;

import oracle.eclipse.tools.common.ui.util.SwtUtil;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class ValidationMessageToolTip
extends ToolTip {
    private final MousePositionResolver mousePositionResolver;

    public ValidationMessageToolTip(Control control, MousePositionResolver mousePositionResolver) {
        super(control);
        this.mousePositionResolver = mousePositionResolver;
        this.setPopupDelay(250);
        this.setShift(new Point(10, 3));
    }

    public ValidationMessageToolTip(Tree tree) {
        this((Control)tree, new TreeMousePositionResolver(tree));
    }

    protected final Composite createToolTipContentArea(Event event, Composite parent) {
        Element element = this.mousePositionResolver.getElement(event.x, event.y);
        Status status = element.validation();
        Display display = parent.getDisplay();
        Composite composite = new Composite(parent, 0);
        composite.setBackground(display.getSystemColor(29));
        composite.setLayout((Layout)SwtUtil.glayout((int)1, (int)2, (int)2, (int)2, (int)2));
        Label titleLabel = new Label(composite, 0);
        titleLabel.setLayoutData((Object)SwtUtil.gdhfill());
        titleLabel.setBackground(display.getSystemColor(29));
        titleLabel.setText(status.message());
        return composite;
    }

    protected final boolean shouldCreateToolTip(Event event) {
        Element element = this.mousePositionResolver.getElement(event.x, event.y);
        if (element != null) {
            return !element.validation().ok();
        }
        return false;
    }

    public static abstract class MousePositionResolver {
        public abstract Element getElement(int var1, int var2);
    }

    public static class TreeMousePositionResolver
    extends MousePositionResolver {
        protected final Tree tree;

        public TreeMousePositionResolver(Tree tree) {
            this.tree = tree;
        }

        @Override
        public Element getElement(int x, int y) {
            Object data;
            TreeItem treeItem = SwtUtil.getTreeItem((Tree)this.tree, (int)x, (int)y);
            if (treeItem != null && (data = treeItem.getData()) instanceof Element) {
                return (Element)data;
            }
            return null;
        }
    }
}

