/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import oracle.eclipse.tools.common.ui.CommonImages;
import oracle.eclipse.tools.common.ui.util.ImageCache;
import oracle.eclipse.tools.common.ui.util.SwtUtil;
import oracle.eclipse.tools.weblogic.descriptors.IClassLoaderStructure;
import oracle.eclipse.tools.weblogic.descriptors.IModuleRef;
import oracle.eclipse.tools.weblogic.descriptors.IWebLogicAppDescriptor;
import oracle.eclipse.tools.weblogic.ui.ddeditor.internal.dynamic.ValidationMessageToolTip;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.platform.StatusBridge;
import org.eclipse.sapphire.ui.Presentation;
import org.eclipse.sapphire.ui.SapphireActionGroup;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentation;
import org.eclipse.sapphire.ui.forms.swt.PropertyEditorPresentationFactory;
import org.eclipse.sapphire.ui.forms.swt.SapphireTextCellEditor;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public final class ClassLoaderStructurePropertyEditor
extends PropertyEditorPresentation {
    public ClassLoaderStructurePropertyEditor(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
        super((FormComponentPart)part, parent, composite);
    }

    protected void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)SwtUtil.gdhindent((GridData)SwtUtil.hspan((GridData)SwtUtil.gdhfill(), (int)2), (int)10));
        composite.setLayout((Layout)SwtUtil.glayout((int)2, (int)0, (int)0, (int)0, (int)0));
        Tree tree = new Tree(composite, 2048);
        tree.setLayoutData((Object)SwtUtil.gdhhint((GridData)SwtUtil.gdfill(), (int)150));
        this.addControl((Control)tree);
        final TreeViewer treeViewer = new TreeViewer(tree);
        final ClassLoaderTreeEditingSupport editingSupport = new ClassLoaderTreeEditingSupport(treeViewer);
        treeViewer.setColumnProperties(new String[]{"a"});
        ICellModifier cellModifier = new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return editingSupport.canEdit(element);
            }

            public Object getValue(Object element, String property) {
                return editingSupport.getValue(element);
            }

            public void modify(Object element, String property, Object value) {
                TreeItem tableItem = (TreeItem)element;
                editingSupport.setValue(tableItem.getData(), value);
            }
        };
        treeViewer.setCellModifier(cellModifier);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object sel = ((IStructuredSelection)treeViewer.getSelection()).getFirstElement();
                if (sel != null && editingSupport.canEdit(sel)) {
                    CellEditor cellEditor = editingSupport.getCellEditor(sel);
                    treeViewer.setCellEditors(new CellEditor[]{cellEditor});
                }
            }
        });
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 3 || event.eventType == 4 || event.eventType == 5;
            }
        };
        TreeViewerEditor.create((TreeViewer)treeViewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)20);
        final Element modelElement = this.element();
        ClassLoaderContentProvider contentProvider = new ClassLoaderContentProvider(modelElement);
        treeViewer.setContentProvider((IContentProvider)contentProvider);
        ClassLoaderLabelProvider labelProvider = new ClassLoaderLabelProvider(modelElement);
        treeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        treeViewer.setInput(new Object());
        new ValidationMessageToolTip(tree);
        ToolBar toolBar = new ToolBar(composite, 0x800200);
        toolBar.setLayoutData((Object)SwtUtil.gdvfill());
        Image addClassloaderButtonImage = WlsUiPlugin.IMG_DESC_FORMS_EDITOR_ADD_CLASS_LOADER.createImage();
        final ToolItem addClassloaderButton = new ToolItem(toolBar, 8);
        addClassloaderButton.setImage(addClassloaderButtonImage);
        addClassloaderButton.setToolTipText(Resources.addClassLoaderButtonToolTip);
        Image addModuleButtonImage = WlsUiPlugin.IMG_DESC_FORMS_EDITOR_ADD_MODULE.createImage();
        final ToolItem addModuleButton = new ToolItem(toolBar, 8);
        addModuleButton.setImage(addModuleButtonImage);
        addModuleButton.setToolTipText(Resources.addModuleButtonToolTip);
        final ToolItem editButton = new ToolItem(toolBar, 8);
        editButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_EDIT));
        editButton.setToolTipText(Resources.editButtonToolTip);
        final ToolItem removeButton = new ToolItem(toolBar, 8);
        removeButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_DELETE));
        removeButton.setToolTipText(Resources.deleteButtonToolTip);
        new ToolItem(toolBar, 2);
        final ToolItem moveUpButton = new ToolItem(toolBar, 8);
        moveUpButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_UP));
        moveUpButton.setToolTipText(Resources.moveUpButtonToolTip);
        final ToolItem moveDownButton = new ToolItem(toolBar, 8);
        moveDownButton.setImage(CommonImages.createImage((ImageDescriptor)CommonImages.DESC_BUTTON_MOVE_DOWN));
        moveDownButton.setToolTipText(Resources.moveDownButtonToolTip);
        Menu menu = new Menu((Control)tree);
        tree.setMenu(menu);
        final MenuItem addClassLoaderMenuItem = new MenuItem(menu, 8);
        addClassLoaderMenuItem.setImage(addClassloaderButtonImage);
        addClassLoaderMenuItem.setText(Resources.addClassLoaderMenuItem);
        final MenuItem addModuleMenuItem = new MenuItem(menu, 8);
        addModuleMenuItem.setImage(addModuleButtonImage);
        addModuleMenuItem.setText(Resources.addModuleMenuItem);
        final MenuItem editMenuItem = new MenuItem(menu, 8);
        editMenuItem.setText(Resources.editMenuItem);
        final MenuItem deleteMenuItem = new MenuItem(menu, 8);
        deleteMenuItem.setText(Resources.deleteMenuItem);
        new MenuItem(menu, 2);
        final MenuItem moveUpMenuItem = new MenuItem(menu, 8);
        moveUpMenuItem.setText(Resources.moveUpMenuItem);
        final MenuItem moveDownMenuItem = new MenuItem(menu, 8);
        moveDownMenuItem.setText(Resources.moveDownMenuItem);
        final Runnable updateButtonsOperation = new Runnable(){

            @Override
            public void run() {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                if (sel != null) {
                    Object element = sel.getFirstElement();
                    IClassLoaderStructure root = ClassLoaderStructurePropertyEditor.getRootClassLoaderStructure(modelElement);
                    boolean canRemove = sel.size() == 1 && !element.equals(root) && !(element instanceof String);
                    removeButton.setEnabled(canRemove);
                    deleteMenuItem.setEnabled(canRemove);
                    boolean canEdit = element instanceof IModuleRef;
                    editButton.setEnabled(canEdit);
                    editMenuItem.setEnabled(canEdit);
                    boolean canAdd = element == null || element instanceof IClassLoaderStructure || element instanceof String;
                    addClassloaderButton.setEnabled(canAdd);
                    addClassLoaderMenuItem.setEnabled(canAdd);
                    addModuleButton.setEnabled(canAdd);
                    addModuleMenuItem.setEnabled(canAdd);
                    boolean canMoveUp = false;
                    boolean canMoveDown = false;
                    if (element != null && element != root && element instanceof Element) {
                        ElementList parentList = (ElementList)((Element)element).parent();
                        int index = parentList.indexOf(element);
                        if (index > 0) {
                            canMoveUp = true;
                        }
                        if (index >= 0 && index < parentList.size() - 1) {
                            canMoveDown = true;
                        }
                    }
                    moveUpButton.setEnabled(canMoveUp);
                    moveUpMenuItem.setEnabled(canMoveUp);
                    moveDownButton.setEnabled(canMoveDown);
                    moveDownMenuItem.setEnabled(canMoveDown);
                }
            }
        };
        SelectionAdapter addClassLoaderListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IClassLoaderStructure cls = ClassLoaderStructurePropertyEditor.getSelectedClassLoaderStructure(modelElement, treeViewer);
                IClassLoaderStructure newCls = (IClassLoaderStructure)cls.getChildClassLoaderStructures().insert();
                treeViewer.refresh();
                treeViewer.expandToLevel((Object)cls, 1);
                treeViewer.setSelection((ISelection)new StructuredSelection((Object)newCls));
            }
        };
        addClassloaderButton.addSelectionListener((SelectionListener)addClassLoaderListener);
        addClassLoaderMenuItem.addSelectionListener((SelectionListener)addClassLoaderListener);
        SelectionAdapter addModuleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IClassLoaderStructure cls = ClassLoaderStructurePropertyEditor.getSelectedClassLoaderStructure(modelElement, treeViewer);
                IModuleRef ref = (IModuleRef)cls.getModuleRefs().insert();
                treeViewer.refresh();
                treeViewer.expandToLevel((Object)cls, 1);
                treeViewer.setSelection((ISelection)new StructuredSelection((Object)ref));
                treeViewer.editElement((Object)ref, 0);
            }
        };
        addModuleButton.addSelectionListener((SelectionListener)addModuleListener);
        addModuleMenuItem.addSelectionListener((SelectionListener)addModuleListener);
        SelectionAdapter editListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                IModuleRef element = (IModuleRef)sel.getFirstElement();
                treeViewer.editElement((Object)element, 0);
            }
        };
        editButton.addSelectionListener((SelectionListener)editListener);
        editMenuItem.addSelectionListener((SelectionListener)editListener);
        SelectionAdapter removeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                Element element = (Element)sel.getFirstElement();
                ElementList list = (ElementList)element.parent();
                list.remove((Object)element);
                IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)element.nearest(IWebLogicAppDescriptor.class);
                IClassLoaderStructure root = (IClassLoaderStructure)descriptor.getClassLoaderStructure().content();
                if (root != null && root.getChildClassLoaderStructures().isEmpty() && root.getModuleRefs().isEmpty()) {
                    descriptor.getClassLoaderStructure().clear();
                }
                treeViewer.refresh();
            }
        };
        removeButton.addSelectionListener((SelectionListener)removeListener);
        deleteMenuItem.addSelectionListener((SelectionListener)removeListener);
        SelectionAdapter moveUpListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                Element element = (Element)sel.getFirstElement();
                ElementList parentList = (ElementList)element.parent();
                parentList.moveUp(element);
                treeViewer.refresh();
                updateButtonsOperation.run();
            }
        };
        moveUpButton.addSelectionListener((SelectionListener)moveUpListener);
        moveUpMenuItem.addSelectionListener((SelectionListener)moveUpListener);
        SelectionAdapter moveDownListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
                Element element = (Element)sel.getFirstElement();
                ElementList parentList = (ElementList)element.parent();
                parentList.moveDown(element);
                treeViewer.refresh();
                updateButtonsOperation.run();
            }
        };
        moveDownButton.addSelectionListener((SelectionListener)moveDownListener);
        moveDownMenuItem.addSelectionListener((SelectionListener)moveDownListener);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                updateButtonsOperation.run();
            }
        });
        updateButtonsOperation.run();
        FilteredListener<PropertyEvent> propertyChangeListener = new FilteredListener<PropertyEvent>(){

            protected void handleTypedEvent(PropertyEvent event) {
                treeViewer.refresh();
            }
        };
        modelElement.attach((Listener)propertyChangeListener, "ClassLoaderStructure");
        modelElement.attach((Listener)propertyChangeListener, "ClassLoaderStructure/*");
        tree.addDisposeListener(new DisposeListener((Listener)propertyChangeListener, addClassloaderButtonImage, addModuleButtonImage){
            private final /* synthetic */ Listener val$propertyChangeListener;
            private final /* synthetic */ Image val$addClassloaderButtonImage;
            private final /* synthetic */ Image val$addModuleButtonImage;
            {
                this.val$propertyChangeListener = listener;
                this.val$addClassloaderButtonImage = image;
                this.val$addModuleButtonImage = image2;
            }

            public void widgetDisposed(DisposeEvent event) {
                modelElement.detach(this.val$propertyChangeListener, "ClassLoaderStructure");
                modelElement.detach(this.val$propertyChangeListener, "ClassLoaderStructure/*");
                this.val$addClassloaderButtonImage.dispose();
                this.val$addModuleButtonImage.dispose();
            }
        });
    }

    private static IClassLoaderStructure getRootClassLoaderStructure(Element element) {
        return ClassLoaderStructurePropertyEditor.getRootClassLoaderStructure(element, false);
    }

    private static IClassLoaderStructure getRootClassLoaderStructure(Element element, boolean createIfNecessary) {
        IWebLogicAppDescriptor descriptor = (IWebLogicAppDescriptor)element.nearest(IWebLogicAppDescriptor.class);
        return (IClassLoaderStructure)descriptor.getClassLoaderStructure().content(createIfNecessary);
    }

    private static IClassLoaderStructure getSelectedClassLoaderStructure(Element modelElement, TreeViewer treeViewer) {
        Object firstElement;
        IStructuredSelection sel = (IStructuredSelection)treeViewer.getSelection();
        IClassLoaderStructure cstr = null;
        if (sel.size() > 0 && (firstElement = sel.getFirstElement()) instanceof IClassLoaderStructure) {
            cstr = (IClassLoaderStructure)firstElement;
        }
        if (cstr == null) {
            cstr = ClassLoaderStructurePropertyEditor.getRootClassLoaderStructure(modelElement, true);
        }
        return cstr;
    }

    private static final class ClassLoaderContentProvider
    implements ITreeContentProvider {
        private final Element modelElement;

        public ClassLoaderContentProvider(Element modelElement) {
            this.modelElement = modelElement;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IClassLoaderStructure) {
                ElementList cls = ((IClassLoaderStructure)parentElement).getChildClassLoaderStructures();
                ElementList refs = ((IClassLoaderStructure)parentElement).getModuleRefs();
                Object[] children = new Object[cls.size() + refs.size()];
                if (refs.size() > 0) {
                    IModuleRef[] refsArray = refs.toArray(new IModuleRef[refs.size()]);
                    System.arraycopy(refsArray, 0, children, 0, refs.size());
                }
                if (cls.size() > 0) {
                    IClassLoaderStructure[] clsArray = cls.toArray(new IClassLoaderStructure[cls.size()]);
                    System.arraycopy(clsArray, 0, children, refs.size(), cls.size());
                }
                return children;
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IClassLoaderStructure) {
                ElementList cls = ((IClassLoaderStructure)element).getChildClassLoaderStructures();
                if (cls.size() > 0) {
                    return true;
                }
                ElementList refs = ((IClassLoaderStructure)element).getModuleRefs();
                if (refs.size() > 0) {
                    return true;
                }
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            IClassLoaderStructure root = ClassLoaderStructurePropertyEditor.getRootClassLoaderStructure(this.modelElement);
            if (root == null) {
                return new Object[]{Resources.applicationClassloader};
            }
            return new Object[]{root};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static final class ClassLoaderLabelProvider
    extends LabelProvider {
        private final Element modelElement;
        private final ImageCache images;

        public ClassLoaderLabelProvider(Element modelElement) {
            this.modelElement = modelElement;
            this.images = new ImageCache();
        }

        public Image getImage(Object element) {
            int style;
            ImageDescriptor baseImageDescriptor;
            if (element instanceof IClassLoaderStructure) {
                IStatus valres = StatusBridge.create((Status)((IClassLoaderStructure)element).validation());
                baseImageDescriptor = WlsUiPlugin.IMG_DESC_CLASSLOADER;
                style = ImageCache.getStyle((int)valres.getSeverity());
            } else if (element instanceof String) {
                baseImageDescriptor = WlsUiPlugin.IMG_DESC_CLASSLOADER;
                style = 0;
            } else {
                Value uriValue = ((IModuleRef)element).getModuleUri();
                IStatus uriValueValidationStatus = StatusBridge.create((Status)uriValue.validation());
                String uriString = uriValue.text();
                style = ImageCache.getStyle((int)uriValueValidationStatus.getSeverity());
                baseImageDescriptor = uriString != null && uriString.toLowerCase().endsWith(".war") ? WlsUiPlugin.IMG_DESC_SHARED_LIB_WAR : WlsUiPlugin.IMG_DESC_SHARED_LIB_JAR;
            }
            return this.images.getImage(baseImageDescriptor, style);
        }

        public String getText(Object element) {
            if (element.equals(ClassLoaderStructurePropertyEditor.getRootClassLoaderStructure(this.modelElement))) {
                return Resources.applicationClassloader;
            }
            if (element instanceof IClassLoaderStructure) {
                return Resources.classloader;
            }
            if (element instanceof IModuleRef) {
                return ((IModuleRef)element).getModuleUri().text();
            }
            return super.getText(element);
        }

        public void dispose() {
            this.images.dispose();
        }
    }

    private final class ClassLoaderTreeEditingSupport
    extends EditingSupport {
        private final TreeViewer tree;
        private SapphireTextCellEditor cellEditor;

        public ClassLoaderTreeEditingSupport(TreeViewer tree) {
            super((ColumnViewer)tree);
            this.tree = tree;
        }

        protected boolean canEdit(Object element) {
            return element instanceof IModuleRef;
        }

        protected CellEditor getCellEditor(Object element) {
            if (this.cellEditor != null) {
                this.cellEditor.dispose();
            }
            Element el = (Element)element;
            SapphireActionGroup actions = ClassLoaderStructurePropertyEditor.this.part().getChildPropertyEditor(el, (PropertyDef)IModuleRef.PROP_MODULE_URI).getActions();
            this.cellEditor = new SapphireTextCellEditor((Presentation)ClassLoaderStructurePropertyEditor.this, (StructuredViewer)this.tree, null, el, IModuleRef.PROP_MODULE_URI, actions, 2048);
            this.cellEditor.setHorizonalIndent(3);
            this.cellEditor.setMaxWidth(150);
            return this.cellEditor;
        }

        protected Object getValue(Object element) {
            return ((IModuleRef)element).getModuleUri();
        }

        protected void setValue(Object element, Object value) {
            ((IModuleRef)element).setModuleUri((String)value);
        }
    }

    public static final class Factory
    extends PropertyEditorPresentationFactory {
        public PropertyEditorPresentation create(PropertyEditorPart part, SwtPresentation parent, Composite composite) {
            return new ClassLoaderStructurePropertyEditor(part, parent, composite);
        }
    }

    private static final class Resources
    extends NLS {
        public static String applicationClassloader;
        public static String classloader;
        public static String addClassLoaderButtonToolTip;
        public static String addModuleButtonToolTip;
        public static String editButtonToolTip;
        public static String deleteButtonToolTip;
        public static String moveUpButtonToolTip;
        public static String moveDownButtonToolTip;
        public static String addClassLoaderMenuItem;
        public static String addModuleMenuItem;
        public static String editMenuItem;
        public static String deleteMenuItem;
        public static String moveUpMenuItem;
        public static String moveDownMenuItem;

        static {
            Resources.initializeMessages((String)ClassLoaderStructurePropertyEditor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

