/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipse.tools.weblogic.ui.ddeditor.internal;

import java.util.Iterator;
import oracle.eclipse.tools.weblogic.syslib.IPathBasedSystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrariesContainerDef;
import oracle.eclipse.tools.weblogic.syslib.ISystemLibrary;
import oracle.eclipse.tools.weblogic.syslib.SystemLibrariesContainer;
import oracle.eclipse.tools.weblogic.ui.internal.WlsUiPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContext;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContribution;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistContributor;
import org.eclipse.sapphire.ui.assist.PropertyEditorAssistSection;
import org.eclipse.sapphire.ui.forms.PropertyEditorPart;

public final class AddWebLogicJarToBuildPath
extends PropertyEditorAssistContributor {
    public void contribute(PropertyEditorAssistContext context) {
        Value val;
        Element element = context.getPart().getLocalModelElement();
        final IProject project = (IProject)element.adapt(IProject.class);
        if (project != null && (val = (Value)((PropertyEditorPart)context.getPart()).property()).validation().severity() == Status.Severity.ERROR && !AddWebLogicJarToBuildPath.isWebLogicJarOnBuildPath(project)) {
            PropertyEditorAssistContribution.Factory contribution = PropertyEditorAssistContribution.factory();
            contribution.text("<p><a href=\"action\" nowrap=\"true\">" + AddWebLogicJarToBuildPath.escapeForXml((String)Resources.action) + "</a></p>");
            contribution.link("action", new Runnable(){

                @Override
                public void run() {
                    if (!AddWebLogicJarToBuildPath.isWebLogicJarOnBuildPath(project)) {
                        try {
                            ISystemLibrariesContainerDef def = SystemLibrariesContainer.getContainerDef((IProject)project);
                            try {
                                IPathBasedSystemLibrary lib = (IPathBasedSystemLibrary)def.getSystemLibraries().insert(IPathBasedSystemLibrary.TYPE);
                                lib.setRelativePath("server/lib/weblogic.jar");
                                def.resource().save();
                            }
                            finally {
                                def.dispose();
                            }
                        }
                        catch (ResourceStoreException e) {
                            WlsUiPlugin.log((Exception)((Object)e));
                        }
                    }
                }
            });
            PropertyEditorAssistSection section = context.getSection("actions");
            section.addContribution(contribution.create());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isWebLogicJarOnBuildPath(IProject project) {
        try {
            ISystemLibrariesContainerDef def = SystemLibrariesContainer.getContainerDef((IProject)project);
            try {
                IPathBasedSystemLibrary lib;
                String relpath;
                ISystemLibrary syslib;
                Iterator iterator = def.getSystemLibraries().iterator();
                do {
                    if (iterator.hasNext()) continue;
                    return false;
                } while (!((syslib = (ISystemLibrary)iterator.next()) instanceof IPathBasedSystemLibrary) || (relpath = (lib = (IPathBasedSystemLibrary)syslib).getRelativePath().text()) == null || !relpath.endsWith("weblogic.jar"));
                return true;
            }
            finally {
                def.dispose();
            }
        }
        catch (ResourceStoreException e) {
            WlsUiPlugin.log((Exception)((Object)e));
        }
        return false;
    }

    private static final class Resources
    extends NLS {
        public static String action;

        static {
            Resources.initializeMessages((String)AddWebLogicJarToBuildPath.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

